/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ContentsAccessor.java,v 1.6 2006/02/21 14:54:47 akabane Exp $
 */
package org.logical_paradox.rss.rcm.accessor;

import org.logical_paradox.rss.http.WebContents;

/**
 * ContentsAccessor
 * RecANZXC^[tF[X<br>
 * ̃C^[tF[Xɑ΂ăANZX邩́CɈˑ<br>
 * RecANZXC^[tF[Xۂ́C̃NCAg<br>
 * L\邱Ƃɒ
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.6 $
 */
public interface ContentsAccessor {
	/**
	 * ̃RecANZTڑDSRURIݒ肷D
	 * @param uri DSRURI
	 */
	public void setDSRURI(String uri);
	/**
	 * RecǗۂ̃GR[fBOݒ肷D
	 * @param encoding GR[fBO
	 */
	public void setContentsEncoding(String encoding);
	/**
	 * ɌĂ΂D
	 * @param initparam p[^
	 */
	public void init(String initparam);
	/**
	 * Recۂɓo^ĂVXeւ̐ڑJ
	 * @param openstr ڑ
	 */
	public void open(String openstr);
	/**
	 * Reco^D
	 * @param contents Rec
	 */
	public void regist(WebContents contents);
	/**
	 * Rec폜D
	 * @param url URL
	 */
	public void unregist(String url);
	/**
	 * SẴRec폜D
	 */
	public void unregistAll();
	/**
	 * RecTD
	 * @param url URL
	 * @return ꂽRec()
	 */
	public String find(String url);
	/**
	 * Xg[WƂ̐ڑD
	 */
	public void close();
}

// end of ContentsAccessor.java
