/*
 * RestrictedSiteLockMgr
 * TbNǗIuWFNg
 * bN\ȃTCgIPAhXŐ
 */
package org.logical_paradox.rss.router;

import java.net.InetAddress;

import org.logical_paradox.common.net.IPAddressRangeSet;

public class RestrictedSiteLockMgr extends SiteLockMgr {
	private final IPAddressRangeSet rangeSet;

	public RestrictedSiteLockMgr( IPAddressRangeSet rs ) {
		super();
		rangeSet = rs;
	}
	public RestrictedSiteLockMgr( long expire, IPAddressRangeSet rs ) {
		super( expire );
		rangeSet = rs;
	}

	/*
	 * bN擾
	 */
	public boolean lock( SiteLock l ) {
		boolean rc = false;
		try {
			InetAddress addr = InetAddress.getByName( l.getSiteName() );
			rc = rangeSet.includes( addr );
		} catch( Exception e ) {
			rc = false;
		}

		if( rc == true ) {
			rc = super.lock( l );
		}
		return rc;
	}
}

// end of RestrictedSiteLockMgr.java
