package org.logical_paradox.rss.router;
import java.io.Serializable;
import java.util.Calendar;

/**
 * SiteLock
 * bN̒Tm[hƁCbNĂURLi[NX<br>
 * [J̌oHirQ[^ƌoHm[h̊Ԃőݓ]̂ŁCVA\<br>
 * `ێ邱<br>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class SiteLock implements Serializable {
	/** VAo[WUID */
	private static final long serialVersionUID = 6895276413172801180L;
	protected String fqdn = null;
	protected String robotId;
	protected boolean gc = false;

	// ̃bNɑ΂ŏIANZX(~b)
	protected long lastUpdateTime = Calendar.getInstance().getTimeInMillis();


	public SiteLock(String dn, String id) {
		fqdn = dn;
		robotId = id;
	}

	public String getSiteName() {
		if(fqdn != null) {
			return new String(fqdn);
		} else {
			return null;
		}
	}

	public String toString() {
		return getSiteName();
	}

	public String getRobotId() {
		return robotId;
	}

	/**
	 * gptO𗧂Ă
	 * ̃tOĂƁCXbhIɃ\[X
	 */
	public void markGC() {
		gc = true;
	}

	/**
	 * ̃bNɑ΂čŌɍsȂꂽANZX~bPʂŕԂ
	 */
	public long getLastAccessTime() {
		return lastUpdateTime;
	}

	/**
	 * ̃bNĂ邩ǂԂ
	 * true: Ă false: ܂v
	 */
	public boolean isBroken() {
		return gc;
	}

	/**
	 * ̃bÑANZXXV
	 */
	public void touch() {
		lastUpdateTime = Calendar.getInstance().getTimeInMillis();
	}
}

// end of SiteLock.java
