package org.logical_paradox.rss.router.algorithm;

import java.util.HashSet;

/**
 * RoutingHistory
 * TǗIuWFNg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class RoutingHistory {
	private HashSet<String> tracedURLs = null;

	/**
	 * ftHgRXgN^
	 */
	public RoutingHistory() {
		tracedURLs = new HashSet<String>();
	}

	/**
	 * Rs[RXgN^
	 */
	public RoutingHistory(RoutingHistory r) {
		tracedURLs = (HashSet<String>)r.tracedURLs.clone();
	}

	/**
	 * w肳ꂽURLɒTǂԂ
 	 */
	public boolean isTraced(String url) {
		return tracedURLs.contains(url);
	}

	/**
	 * Tς݂URLǉ
	 */
	public void add(String url) {
		tracedURLs.add(url);
	}

	/**
	 * Tς݂URL폜
	 * ߋ̒TȂƂɂꍇɎgp
	 */
	public void remove(String url) {
		tracedURLs.remove(url);
	}
}

// end of RoutingHistory.java
