/*
 * JTextComponentOutputStream
 * JTextComponentɑ΂ďo͂sȂo̓Xg[NX
 */
package org.logical_paradox.rss.test.dsync;

import java.io.IOException;
import java.io.OutputStream;

import javax.swing.text.JTextComponent;

public class JTextComponentOutputStream extends OutputStream {
	public static final int OSTREAM_BUFSIZ = 4096;
	private JTextComponent out;
	private byte[] ostreambuf = new byte[ OSTREAM_BUFSIZ ];
	private int osBufCnt = 0;

	public JTextComponentOutputStream( JTextComponent compo ) {
		out = compo;
	}

	public void write( int b ) throws IOException {
		ostreambuf[ osBufCnt++ ] = (byte)(b & 0xff);
		if( osBufCnt == ostreambuf.length ) {
			flush();
		}
	}

	public void flush() throws IOException {
		if( osBufCnt == 0 ) {
			return;
		}
		String str = new String( ostreambuf, 0, osBufCnt );
		StringBuffer bf = new StringBuffer( out.getText() );
		bf.append( str );

		out.setText( bf.toString() );
		bf = null;

		osBufCnt = 0;
	}
}

// end of JTextComponentOutputStream.java
