/*
 * SyncButtonActionCallback
 * {^֘ÃR[obN
 */
package org.logical_paradox.rss.test.dsync;

import java.awt.event.ActionEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.dsync.SyncCommand;
import org.logical_paradox.rss.dsync.SyncQueueException;

public class SyncButtonActionCallback extends ButtonActionCallback {
	private static final Log log = LogFactory.getLog(SyncButtonActionCallback.class);
	public SyncButtonActionCallback( DelayedSyncTestGUI gui ) {
		super( gui );
	}

	public void actionPerformed( ActionEvent event ) {
		if( event.getSource() == parent.syncBtn && parent.commandQueue.size() > 0 ) {
			try {
				sendAllCommand();
			} catch( SyncQueueException e ) {
				log.info( "̃f[^xf[Ɋi[ł܂ł" );
				log.info( e.getMessage() );
			}
		}
	}

	public void sendAllCommand() throws SyncQueueException {
		int commandQueueSize = 0;

		synchronized( parent.commandQueue ) {
			commandQueueSize = parent.commandQueue.size();
			for( int i = 0; i < commandQueueSize; i++ ) {
				parent.syncd.add( (SyncCommand)parent.commandQueue.elementAt(i) );
			}
			parent.commandQueue.removeAllElements();
		}

		log.info( "xf[" + commandQueueSize + "̃f[^i[܂" );
		parent.commandQueueList.setListData( parent.commandQueue );
	}
}
