/*
 * $Id: I18nProperties.java,v 1.3 2006/01/26 16:27:35 rampil Exp $
 * Copyright (c) 2005 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;

/**
 * I18nProperties
 * ۉΉPropertiesNX
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class I18nProperties extends Properties {
	/** VAo[WUID */
	private static final long serialVersionUID = 6796407719137951775L;

	/**
	 * RXgN^
	 */
	public I18nProperties() {
		super();
	}
	/**
	 * RXgN^
	 * @param defaults ftHgl̐ݒ肳ĂvpeB
	 */
	public I18nProperties(Properties defaults) {
		super(defaults);
	}
	/**
	 * RXgN^
	 * @param in ̓Xg[
	 * @throws IOException ̓Xg[̑Ɏs
	 */
	public void load(InputStream in) throws IOException {
		super.load(in);

		Enumeration e = propertyNames();
		while(e.hasMoreElements()) {
			String keyname = (String)e.nextElement();
			String o = (String)get(keyname);
			byte[] buf = o.getBytes("8859_1");

			BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buf), "JISAutoDetect"));

			StringBuffer sb = new StringBuffer();
			String lineBuffer = null;
			while((lineBuffer = br.readLine()) != null) {
				if(sb.toString().length() > 0) {
					sb.append("\n");
				}
				sb.append(lineBuffer);
			}
			setProperty(keyname, sb.toString());
		}
	}
}

// end of I18nProperties.java
