/*
 * Decompiled with CFR 0.152.
 */
package com.android.draw9patch.ui;

import com.android.draw9patch.graphics.GraphicsUtilities;
import com.android.draw9patch.ui.ImageTransferHandler;
import com.android.draw9patch.ui.MainFrame;
import com.android.draw9patch.ui.PngFileFilter;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ImageEditorPanel
extends JPanel {
    private static final String EXTENSION_9PATCH = ".9.png";
    private static final int DEFAULT_ZOOM = 8;
    private static final float DEFAULT_SCALE = 2.0f;
    private String name;
    private BufferedImage image;
    private boolean is9Patch;
    private ImageViewer viewer;
    private StretchesViewer stretchesViewer;
    private JLabel xLabel;
    private JLabel yLabel;
    private TexturePaint texture;
    private List<Rectangle> patches;
    private List<Rectangle> horizontalPatches;
    private List<Rectangle> verticalPatches;
    private List<Rectangle> fixed;
    private boolean verticalStartWithPatch;
    private boolean horizontalStartWithPatch;
    private Pair<Integer> horizontalPadding;
    private Pair<Integer> verticalPadding;

    ImageEditorPanel(MainFrame mainFrame, BufferedImage image, String name) {
        this.image = image;
        this.name = name;
        this.setTransferHandler(new ImageTransferHandler(mainFrame));
        this.checkImage();
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.loadSupport();
        this.buildImageViewer();
        this.buildStatusPanel();
    }

    private void loadSupport() {
        try {
            URL resource = this.getClass().getResource("/images/checker.png");
            BufferedImage checker = GraphicsUtilities.loadCompatibleImage(resource);
            this.texture = new TexturePaint(checker, new Rectangle2D.Double(0.0, 0.0, checker.getWidth(), checker.getHeight()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void buildImageViewer() {
        this.viewer = new ImageViewer();
        JSplitPane splitter = new JSplitPane();
        splitter.setContinuousLayout(true);
        splitter.setResizeWeight(0.8);
        splitter.setBorder(null);
        JScrollPane scroller = new JScrollPane(this.viewer);
        scroller.setOpaque(false);
        scroller.setBorder(null);
        scroller.getViewport().setBorder(null);
        scroller.getViewport().setOpaque(false);
        splitter.setLeftComponent(scroller);
        splitter.setRightComponent(this.buildStretchesViewer());
        this.add(splitter);
    }

    private JComponent buildStretchesViewer() {
        this.stretchesViewer = new StretchesViewer();
        JScrollPane scroller = new JScrollPane(this.stretchesViewer);
        scroller.setBorder(null);
        scroller.getViewport().setBorder(null);
        scroller.setHorizontalScrollBarPolicy(32);
        scroller.setVerticalScrollBarPolicy(22);
        return scroller;
    }

    private void buildStatusPanel() {
        JPanel status = new JPanel(new GridBagLayout());
        status.setOpaque(false);
        JLabel label = new JLabel();
        label.setForeground(Color.WHITE);
        label.setText("Zoom: ");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 6, 0, 0), 0, 0));
        label = new JLabel();
        label.setForeground(Color.WHITE);
        label.setText("100%");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        JSlider zoomSlider = new JSlider(1, 16, 8);
        zoomSlider.setSnapToTicks(true);
        zoomSlider.putClientProperty("JComponent.sizeVariant", "small");
        zoomSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ImageEditorPanel.this.viewer.setZoom(((JSlider)evt.getSource()).getValue());
            }
        });
        status.add((Component)zoomSlider, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel maxZoomLabel = new JLabel();
        maxZoomLabel.setForeground(Color.WHITE);
        maxZoomLabel.putClientProperty("JComponent.sizeVariant", "small");
        maxZoomLabel.setText("800%");
        status.add((Component)maxZoomLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel();
        label.setForeground(Color.WHITE);
        label.setText("Patch scale: ");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 6, 0, 0), 0, 0));
        label = new JLabel();
        label.setForeground(Color.WHITE);
        label.setText("2x");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)label, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        zoomSlider = new JSlider(200, 600, 200);
        zoomSlider.setSnapToTicks(true);
        zoomSlider.putClientProperty("JComponent.sizeVariant", "small");
        zoomSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ImageEditorPanel.this.stretchesViewer.setScale((float)((JSlider)evt.getSource()).getValue() / 100.0f);
            }
        });
        status.add((Component)zoomSlider, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        maxZoomLabel = new JLabel();
        maxZoomLabel.setForeground(Color.WHITE);
        maxZoomLabel.putClientProperty("JComponent.sizeVariant", "small");
        maxZoomLabel.setText("6x");
        status.add((Component)maxZoomLabel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        JCheckBox showLock = new JCheckBox("Show lock");
        showLock.setOpaque(false);
        showLock.setForeground(Color.WHITE);
        showLock.setSelected(true);
        showLock.putClientProperty("JComponent.sizeVariant", "small");
        showLock.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ImageEditorPanel.this.viewer.setLockVisible(((JCheckBox)event.getSource()).isSelected());
            }
        });
        status.add((Component)showLock, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 12, 0, 0), 0, 0));
        JCheckBox showPatches = new JCheckBox("Show patches");
        showPatches.setOpaque(false);
        showPatches.setForeground(Color.WHITE);
        showPatches.putClientProperty("JComponent.sizeVariant", "small");
        showPatches.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ImageEditorPanel.this.viewer.setPatchesVisible(((JCheckBox)event.getSource()).isSelected());
            }
        });
        status.add((Component)showPatches, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 12, 0, 0), 0, 0));
        JCheckBox showPadding = new JCheckBox("Show content");
        showPadding.setOpaque(false);
        showPadding.setForeground(Color.WHITE);
        showPadding.putClientProperty("JComponent.sizeVariant", "small");
        showPadding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ImageEditorPanel.this.stretchesViewer.setPaddingVisible(((JCheckBox)event.getSource()).isSelected());
            }
        });
        status.add((Component)showPadding, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 12, 0, 0), 0, 0));
        status.add(Box.createHorizontalGlue(), new GridBagConstraints(6, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("X: ");
        label.setForeground(Color.WHITE);
        label.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)label, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.xLabel = new JLabel("0px");
        this.xLabel.setForeground(Color.WHITE);
        this.xLabel.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)this.xLabel, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 6), 0, 0));
        label = new JLabel("Y: ");
        label.setForeground(Color.WHITE);
        label.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)label, new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.yLabel = new JLabel("0px");
        this.yLabel.setForeground(Color.WHITE);
        this.yLabel.putClientProperty("JComponent.sizeVariant", "small");
        status.add((Component)this.yLabel, new GridBagConstraints(8, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 6), 0, 0));
        this.add((Component)status, "South");
    }

    private void checkImage() {
        this.is9Patch = this.name.endsWith(EXTENSION_9PATCH);
        if (!this.is9Patch) {
            this.convertTo9Patch();
        } else {
            this.ensure9Patch();
        }
    }

    private void ensure9Patch() {
        int pixel;
        int i;
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        for (i = 0; i < width; ++i) {
            pixel = this.image.getRGB(i, 0);
            if (pixel != 0 && pixel != -16777216) {
                this.image.setRGB(i, 0, 0);
            }
            if ((pixel = this.image.getRGB(i, height - 1)) == 0 || pixel == -16777216) continue;
            this.image.setRGB(i, height - 1, 0);
        }
        for (i = 0; i < height; ++i) {
            pixel = this.image.getRGB(0, i);
            if (pixel != 0 && pixel != -16777216) {
                this.image.setRGB(0, i, 0);
            }
            if ((pixel = this.image.getRGB(width - 1, i)) == 0 || pixel == -16777216) continue;
            this.image.setRGB(width - 1, i, 0);
        }
    }

    private void convertTo9Patch() {
        BufferedImage buffer = GraphicsUtilities.createTranslucentCompatibleImage(this.image.getWidth() + 2, this.image.getHeight() + 2);
        Graphics2D g2 = buffer.createGraphics();
        g2.drawImage((Image)this.image, 1, 1, null);
        g2.dispose();
        this.image = buffer;
        this.name = this.name.substring(0, this.name.lastIndexOf(46)) + EXTENSION_9PATCH;
    }

    File chooseSaveFile() {
        if (this.is9Patch) {
            return new File(this.name);
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new PngFileFilter());
        int choice = chooser.showSaveDialog(this);
        if (choice == 0) {
            File file = chooser.getSelectedFile();
            if (!file.getAbsolutePath().endsWith(EXTENSION_9PATCH)) {
                String path = file.getAbsolutePath();
                path = path.endsWith(".png") ? path.substring(0, path.lastIndexOf(".png")) + EXTENSION_9PATCH : path + EXTENSION_9PATCH;
                this.name = path;
                this.is9Patch = true;
                return new File(path);
            }
            this.is9Patch = true;
            return file;
        }
        return null;
    }

    RenderedImage getImage() {
        return this.image;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pair<E> {
        E first;
        E second;

        Pair(E first, E second) {
            this.first = first;
            this.second = second;
        }

        public String toString() {
            return "Pair[" + this.first + ", " + this.second + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImageViewer
    extends JComponent {
        private final Color CORRUPTED_COLOR = new Color(1.0f, 0.0f, 0.0f, 0.7f);
        private final Color LOCK_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.7f);
        private final Color STRIPES_COLOR = new Color(1.0f, 0.0f, 0.0f, 0.5f);
        private final Color BACK_COLOR = new Color(0xC0C0C0);
        private final Color HELP_COLOR = new Color(0xFFFFE1);
        private final Color PATCH_COLOR = new Color(1.0f, 0.37f, 0.99f, 0.5f);
        private final Color PATCH_ONEWAY_COLOR = new Color(0.37f, 1.0f, 0.37f, 0.5f);
        private static final float STRIPES_WIDTH = 4.0f;
        private static final double STRIPES_SPACING = 6.0;
        private static final int STRIPES_ANGLE = 45;
        private int zoom;
        private boolean showPatches;
        private boolean showLock = true;
        private Dimension size;
        private boolean locked;
        private int[] row;
        private int[] column;
        private int lastPositionX;
        private int lastPositionY;
        private int currentButton;
        private boolean showCursor;
        private JLabel helpLabel;
        private boolean eraseMode;
        private JButton checkButton;
        private List<Rectangle> corruptedPatches;
        private boolean showBadPatches;
        private JPanel helpPanel;

        ImageViewer() {
            this.setLayout(new GridBagLayout());
            this.helpPanel = new JPanel(new BorderLayout());
            this.helpPanel.setBorder(new EmptyBorder(0, 6, 0, 6));
            this.helpPanel.setBackground(this.HELP_COLOR);
            this.helpLabel = new JLabel("Press Shift to erase pixels");
            this.helpLabel.putClientProperty("JComponent.sizeVariant", "small");
            this.helpPanel.add((Component)this.helpLabel, "West");
            this.checkButton = new JButton("Show bad patches");
            this.checkButton.putClientProperty("JComponent.sizeVariant", "small");
            this.checkButton.putClientProperty("JButton.buttonType", "roundRect");
            this.helpPanel.add((Component)this.checkButton, "East");
            this.add((Component)this.helpPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.setOpaque(true);
            this.setZoom(8);
            this.findPatches();
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent event) {
                    ImageViewer.this.currentButton = event.isShiftDown() ? 3 : event.getButton();
                    ImageViewer.this.paint(event.getX(), event.getY(), ImageViewer.this.currentButton);
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent event) {
                    if (!ImageViewer.this.checkLockedRegion(event.getX(), event.getY())) {
                        ImageViewer.this.paint(event.getX(), event.getY(), ImageViewer.this.currentButton);
                    }
                }

                public void mouseMoved(MouseEvent event) {
                    ImageViewer.this.checkLockedRegion(event.getX(), event.getY());
                }
            });
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                public void eventDispatched(AWTEvent event) {
                    ImageViewer.this.enableEraseMode((KeyEvent)event);
                }
            }, 8L);
            this.checkButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (!ImageViewer.this.showBadPatches) {
                        ImageViewer.this.findBadPatches();
                        ImageViewer.this.checkButton.setText("Hide bad patches");
                    } else {
                        ImageViewer.this.checkButton.setText("Show bad patches");
                        ImageViewer.this.corruptedPatches = null;
                    }
                    ImageViewer.this.repaint();
                    ImageViewer.this.showBadPatches = !ImageViewer.this.showBadPatches;
                }
            });
        }

        private void findBadPatches() {
            this.corruptedPatches = new ArrayList<Rectangle>();
            for (Rectangle patch : ImageEditorPanel.this.patches) {
                if (!this.corruptPatch(patch)) continue;
                this.corruptedPatches.add(patch);
            }
            for (Rectangle patch : ImageEditorPanel.this.horizontalPatches) {
                if (!this.corruptHorizontalPatch(patch)) continue;
                this.corruptedPatches.add(patch);
            }
            for (Rectangle patch : ImageEditorPanel.this.verticalPatches) {
                if (!this.corruptVerticalPatch(patch)) continue;
                this.corruptedPatches.add(patch);
            }
        }

        private boolean corruptPatch(Rectangle patch) {
            int[] pixels = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, patch.x, patch.y, patch.width, patch.height, null);
            if (pixels.length > 0) {
                int reference = pixels[0];
                for (int pixel : pixels) {
                    if (pixel == reference) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean corruptHorizontalPatch(Rectangle patch) {
            int[] reference = new int[patch.height];
            int[] column = new int[patch.height];
            reference = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, patch.x, patch.y, 1, patch.height, reference);
            for (int i = 1; i < patch.width; ++i) {
                column = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, patch.x + i, patch.y, 1, patch.height, column);
                if (Arrays.equals(reference, column)) continue;
                return true;
            }
            return false;
        }

        private boolean corruptVerticalPatch(Rectangle patch) {
            int[] reference = new int[patch.width];
            int[] row = new int[patch.width];
            reference = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, patch.x, patch.y, patch.width, 1, reference);
            for (int i = 1; i < patch.height; ++i) {
                row = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, patch.x, patch.y + i, patch.width, 1, row);
                if (Arrays.equals(reference, row)) continue;
                return true;
            }
            return false;
        }

        private void enableEraseMode(KeyEvent event) {
            boolean oldEraseMode = this.eraseMode;
            this.eraseMode = event.isShiftDown();
            if (this.eraseMode != oldEraseMode) {
                if (this.eraseMode) {
                    this.helpLabel.setText("Release Shift to draw pixels");
                } else {
                    this.helpLabel.setText("Press Shift to erase pixels");
                }
            }
        }

        private void paint(int x, int y, int button) {
            int color;
            switch (button) {
                case 1: {
                    color = -16777216;
                    break;
                }
                case 3: {
                    color = 0;
                    break;
                }
                default: {
                    return;
                }
            }
            int left = (this.getWidth() - this.size.width) / 2;
            int top = (this.helpPanel.getHeight() + this.getHeight() - this.size.height) / 2;
            x = (x - left) / this.zoom;
            y = (y - top) / this.zoom;
            int width = ImageEditorPanel.this.image.getWidth();
            int height = ImageEditorPanel.this.image.getHeight();
            if ((x == 0 || x == width - 1) && y > 0 && y < height - 1 || x > 0 && x < width - 1 && (y == 0 || y == height - 1)) {
                ImageEditorPanel.this.image.setRGB(x, y, color);
                this.findPatches();
                ImageEditorPanel.this.stretchesViewer.computePatches();
                if (this.showBadPatches) {
                    this.findBadPatches();
                }
                this.repaint();
            }
        }

        private boolean checkLockedRegion(int x, int y) {
            int oldX = this.lastPositionX;
            int oldY = this.lastPositionY;
            this.lastPositionX = x;
            this.lastPositionY = y;
            int left = (this.getWidth() - this.size.width) / 2;
            int top = (this.helpPanel.getHeight() + this.getHeight() - this.size.height) / 2;
            x = (x - left) / this.zoom;
            y = (y - top) / this.zoom;
            int width = ImageEditorPanel.this.image.getWidth();
            int height = ImageEditorPanel.this.image.getHeight();
            ImageEditorPanel.this.xLabel.setText(Math.max(0, Math.min(x, width - 1)) + " px");
            ImageEditorPanel.this.yLabel.setText(Math.max(0, Math.min(y, height - 1)) + " px");
            boolean previousLock = this.locked;
            this.locked = x > 0 && x < width - 1 && y > 0 && y < height - 1;
            boolean previousCursor = this.showCursor;
            boolean bl = this.showCursor = (x == 0 || x == width - 1) && y > 0 && y < height - 1 || x > 0 && x < width - 1 && (y == 0 || y == height - 1);
            if (this.locked != previousLock) {
                this.repaint();
            } else if (this.showCursor || this.showCursor != previousCursor) {
                Rectangle clip = new Rectangle(this.lastPositionX - 1 - this.zoom / 2, this.lastPositionY - 1 - this.zoom / 2, this.zoom + 2, this.zoom + 2);
                clip = clip.union(new Rectangle(oldX - 1 - this.zoom / 2, oldY - 1 - this.zoom / 2, this.zoom + 2, this.zoom + 2));
                this.repaint(clip);
            }
            return this.locked;
        }

        @Override
        protected void paintComponent(Graphics g) {
            int x = (this.getWidth() - this.size.width) / 2;
            int y = (this.helpPanel.getHeight() + this.getHeight() - this.size.height) / 2;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(this.BACK_COLOR);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.translate(x, y);
            g2.setPaint(ImageEditorPanel.this.texture);
            g2.fillRect(0, 0, this.size.width, this.size.height);
            g2.scale(this.zoom, this.zoom);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g2.drawImage((Image)ImageEditorPanel.this.image, 0, 0, null);
            if (this.showPatches) {
                g2.setColor(this.PATCH_COLOR);
                for (Rectangle patch : ImageEditorPanel.this.patches) {
                    g2.fillRect(patch.x, patch.y, patch.width, patch.height);
                }
                g2.setColor(this.PATCH_ONEWAY_COLOR);
                for (Rectangle patch : ImageEditorPanel.this.horizontalPatches) {
                    g2.fillRect(patch.x, patch.y, patch.width, patch.height);
                }
                for (Rectangle patch : ImageEditorPanel.this.verticalPatches) {
                    g2.fillRect(patch.x, patch.y, patch.width, patch.height);
                }
            }
            if (this.corruptedPatches != null) {
                g2.setColor(this.CORRUPTED_COLOR);
                g2.setStroke(new BasicStroke(3.0f / (float)this.zoom));
                for (Rectangle patch : this.corruptedPatches) {
                    g2.draw(new RoundRectangle2D.Float((float)patch.x - 2.0f / (float)this.zoom, (float)patch.y - 2.0f / (float)this.zoom, (float)patch.width + 2.0f / (float)this.zoom, (float)patch.height + 2.0f / (float)this.zoom, 6.0f / (float)this.zoom, 6.0f / (float)this.zoom));
                }
            }
            if (this.showLock && this.locked) {
                int width = ImageEditorPanel.this.image.getWidth();
                int height = ImageEditorPanel.this.image.getHeight();
                g2.setColor(this.LOCK_COLOR);
                g2.fillRect(1, 1, width - 2, height - 2);
                g2.setColor(this.STRIPES_COLOR);
                g2.translate(1, 1);
                this.paintStripes(g2, width - 2, height - 2);
                g2.translate(-1, -1);
            }
            g2.dispose();
            if (this.showCursor) {
                Graphics cursor = g.create();
                cursor.setXORMode(Color.WHITE);
                cursor.setColor(Color.BLACK);
                cursor.drawRect(this.lastPositionX - this.zoom / 2, this.lastPositionY - this.zoom / 2, this.zoom, this.zoom);
                cursor.dispose();
            }
        }

        private void paintStripes(Graphics2D g, int width, int height) {
            Shape oldClip = g.getClip();
            Area area = new Area(new Rectangle(0, 0, width, height));
            if (oldClip != null) {
                area = new Area(oldClip);
            }
            area.intersect(new Area(new Rectangle(0, 0, width, height)));
            g.setClip(area);
            g.setStroke(new BasicStroke(4.0f));
            double hypLength = Math.sqrt(width * width + height * height);
            double radians = Math.toRadians(45.0);
            g.rotate(radians);
            double spacing = 6.0;
            int numLines = (int)(hypLength / (spacing += 4.0));
            for (int i = 0; i < numLines; ++i) {
                double x = (double)i * spacing;
                Line2D.Double line = new Line2D.Double(x, -hypLength, x, hypLength);
                g.draw(line);
            }
            g.setClip(oldClip);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.size;
        }

        void setZoom(int value) {
            int width = ImageEditorPanel.this.image.getWidth();
            int height = ImageEditorPanel.this.image.getHeight();
            this.zoom = value;
            this.size = new Dimension(width * this.zoom, height * this.zoom);
            this.setSize(this.size);
            ImageEditorPanel.this.validate();
            this.repaint();
        }

        void setPatchesVisible(boolean visible) {
            this.showPatches = visible;
            this.findPatches();
            this.repaint();
        }

        private void findPatches() {
            int width = ImageEditorPanel.this.image.getWidth();
            int height = ImageEditorPanel.this.image.getHeight();
            this.row = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, 0, 0, width, 1, this.row);
            this.column = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, 0, 0, 1, height, this.column);
            boolean[] result = new boolean[1];
            Pair<List<Pair<Integer>>> left = this.getPatches(this.column, result);
            ImageEditorPanel.this.verticalStartWithPatch = result[0];
            result = new boolean[1];
            Pair<List<Pair<Integer>>> top = this.getPatches(this.row, result);
            ImageEditorPanel.this.horizontalStartWithPatch = result[0];
            ImageEditorPanel.this.fixed = this.getRectangles((List)left.first, (List)top.first);
            ImageEditorPanel.this.patches = this.getRectangles((List)left.second, (List)top.second);
            if (ImageEditorPanel.this.fixed.size() > 0) {
                ImageEditorPanel.this.horizontalPatches = this.getRectangles((List)left.first, (List)top.second);
                ImageEditorPanel.this.verticalPatches = this.getRectangles((List)left.second, (List)top.first);
            } else if (((List)top.first).size() > 0) {
                ImageEditorPanel.this.horizontalPatches = new ArrayList(0);
                ImageEditorPanel.this.verticalPatches = this.getVerticalRectangles((List)top.first);
            } else if (((List)left.first).size() > 0) {
                ImageEditorPanel.this.horizontalPatches = this.getHorizontalRectangles((List)left.first);
                ImageEditorPanel.this.verticalPatches = new ArrayList(0);
            } else {
                ImageEditorPanel.this.horizontalPatches = (ImageEditorPanel.this.verticalPatches = new ArrayList(0));
            }
            this.row = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, 0, height - 1, width, 1, this.row);
            this.column = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, width - 1, 0, 1, height, this.column);
            top = this.getPatches(this.row, result);
            ImageEditorPanel.this.horizontalPadding = this.getPadding((List)top.first);
            left = this.getPatches(this.column, result);
            ImageEditorPanel.this.verticalPadding = this.getPadding((List)left.first);
        }

        private List<Rectangle> getVerticalRectangles(List<Pair<Integer>> topPairs) {
            ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
            for (Pair<Integer> top : topPairs) {
                int x = (Integer)top.first;
                int width = (Integer)top.second - (Integer)top.first;
                rectangles.add(new Rectangle(x, 1, width, ImageEditorPanel.this.image.getHeight() - 2));
            }
            return rectangles;
        }

        private List<Rectangle> getHorizontalRectangles(List<Pair<Integer>> leftPairs) {
            ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
            for (Pair<Integer> left : leftPairs) {
                int y = (Integer)left.first;
                int height = (Integer)left.second - (Integer)left.first;
                rectangles.add(new Rectangle(1, y, ImageEditorPanel.this.image.getWidth() - 2, height));
            }
            return rectangles;
        }

        private Pair<Integer> getPadding(List<Pair<Integer>> pairs) {
            if (pairs.size() == 0) {
                return new Pair<Integer>(0, 0);
            }
            if (pairs.size() == 1) {
                if ((Integer)pairs.get((int)0).first == 1) {
                    return new Pair<Integer>((Integer)pairs.get((int)0).second - (Integer)pairs.get((int)0).first, 0);
                }
                return new Pair<Integer>(0, (Integer)pairs.get((int)0).second - (Integer)pairs.get((int)0).first);
            }
            int index = pairs.size() - 1;
            return new Pair<Integer>((Integer)pairs.get((int)0).second - (Integer)pairs.get((int)0).first, (Integer)pairs.get((int)index).second - (Integer)pairs.get((int)index).first);
        }

        private List<Rectangle> getRectangles(List<Pair<Integer>> leftPairs, List<Pair<Integer>> topPairs) {
            ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
            for (Pair<Integer> left : leftPairs) {
                int y = (Integer)left.first;
                int height = (Integer)left.second - (Integer)left.first;
                for (Pair<Integer> top : topPairs) {
                    int x = (Integer)top.first;
                    int width = (Integer)top.second - (Integer)top.first;
                    rectangles.add(new Rectangle(x, y, width, height));
                }
            }
            return rectangles;
        }

        private Pair<List<Pair<Integer>>> getPatches(int[] pixels, boolean[] startWithPatch) {
            int lastIndex = 1;
            int lastPixel = pixels[1];
            boolean first = true;
            ArrayList<Pair<Integer>> fixed = new ArrayList<Pair<Integer>>();
            ArrayList<Pair<Integer>> patches = new ArrayList<Pair<Integer>>();
            for (int i = 1; i < pixels.length - 1; ++i) {
                int pixel = pixels[i];
                if (pixel == lastPixel) continue;
                if (lastPixel == -16777216) {
                    if (first) {
                        startWithPatch[0] = true;
                    }
                    patches.add(new Pair<Integer>(lastIndex, i));
                } else {
                    fixed.add(new Pair<Integer>(lastIndex, i));
                }
                first = false;
                lastIndex = i;
                lastPixel = pixel;
            }
            if (lastPixel == -16777216) {
                if (first) {
                    startWithPatch[0] = true;
                }
                patches.add(new Pair<Integer>(lastIndex, pixels.length - 1));
            } else {
                fixed.add(new Pair<Integer>(lastIndex, pixels.length - 1));
            }
            if (patches.size() == 0) {
                patches.add(new Pair<Integer>(1, pixels.length - 1));
                startWithPatch[0] = true;
                fixed.clear();
            }
            return new Pair<List<Pair<Integer>>>(fixed, patches);
        }

        void setLockVisible(boolean visible) {
            this.showLock = visible;
            this.repaint();
        }
    }

    private class StretchesViewer
    extends JPanel {
        private static final int MARGIN = 24;
        private StretchView horizontal;
        private StretchView vertical;
        private StretchView both;
        private Dimension size;
        private float horizontalPatchesSum;
        private float verticalPatchesSum;
        private boolean showPadding;

        StretchesViewer() {
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(24, 24, 24, 24));
            this.horizontal = new StretchView();
            this.vertical = new StretchView();
            this.both = new StretchView();
            this.setScale(2.0f);
            this.add((Component)this.vertical, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.horizontal, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.both, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setPaint(ImageEditorPanel.this.texture);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.dispose();
        }

        void setScale(float scale) {
            int patchWidth = ImageEditorPanel.this.image.getWidth() - 2;
            int patchHeight = ImageEditorPanel.this.image.getHeight() - 2;
            int scaledWidth = (int)((float)patchWidth * scale);
            int scaledHeight = (int)((float)patchHeight * scale);
            this.horizontal.scaledWidth = scaledWidth;
            this.vertical.scaledHeight = scaledHeight;
            this.both.scaledWidth = scaledWidth;
            this.both.scaledHeight = scaledHeight;
            this.size = new Dimension(scaledWidth, scaledHeight);
            this.computePatches();
        }

        void computePatches() {
            int start;
            boolean measuredWidth = false;
            boolean endRow = true;
            int remainderHorizontal = 0;
            int remainderVertical = 0;
            if (ImageEditorPanel.this.fixed.size() > 0) {
                start = ((Rectangle)((ImageEditorPanel)ImageEditorPanel.this).fixed.get((int)0)).y;
                for (Rectangle rect : ImageEditorPanel.this.fixed) {
                    if (rect.y > start) {
                        endRow = true;
                        measuredWidth = true;
                    }
                    if (!measuredWidth) {
                        remainderHorizontal += rect.width;
                    }
                    if (!endRow) continue;
                    remainderVertical += rect.height;
                    endRow = false;
                    start = rect.y;
                }
            }
            this.horizontal.remainderHorizontal = this.horizontal.scaledWidth - remainderHorizontal;
            this.vertical.remainderHorizontal = this.vertical.scaledWidth - remainderHorizontal;
            this.both.remainderHorizontal = this.both.scaledWidth - remainderHorizontal;
            this.horizontal.remainderVertical = this.horizontal.scaledHeight - remainderVertical;
            this.vertical.remainderVertical = this.vertical.scaledHeight - remainderVertical;
            this.both.remainderVertical = this.both.scaledHeight - remainderVertical;
            this.horizontalPatchesSum = 0.0f;
            if (ImageEditorPanel.this.horizontalPatches.size() > 0) {
                start = -1;
                for (Rectangle rect : ImageEditorPanel.this.horizontalPatches) {
                    if (rect.x <= start) continue;
                    this.horizontalPatchesSum += (float)rect.width;
                    start = rect.x;
                }
            } else {
                start = -1;
                for (Rectangle rect : ImageEditorPanel.this.patches) {
                    if (rect.x <= start) continue;
                    this.horizontalPatchesSum += (float)rect.width;
                    start = rect.x;
                }
            }
            this.verticalPatchesSum = 0.0f;
            if (ImageEditorPanel.this.verticalPatches.size() > 0) {
                start = -1;
                for (Rectangle rect : ImageEditorPanel.this.verticalPatches) {
                    if (rect.y <= start) continue;
                    this.verticalPatchesSum += (float)rect.height;
                    start = rect.y;
                }
            } else {
                start = -1;
                for (Rectangle rect : ImageEditorPanel.this.patches) {
                    if (rect.y <= start) continue;
                    this.verticalPatchesSum += (float)rect.height;
                    start = rect.y;
                }
            }
            this.setSize(this.size);
            ImageEditorPanel.this.validate();
            this.repaint();
        }

        void setPaddingVisible(boolean visible) {
            this.showPadding = visible;
            this.repaint();
        }

        private class StretchView
        extends JComponent {
            private final Color PADDING_COLOR = new Color(0.37f, 0.37f, 1.0f, 0.5f);
            int scaledWidth;
            int scaledHeight;
            int remainderHorizontal;
            int remainderVertical;

            StretchView() {
                this.scaledWidth = ImageEditorPanel.this.image.getWidth();
                this.scaledHeight = ImageEditorPanel.this.image.getHeight();
            }

            protected void paintComponent(Graphics g) {
                int x = (this.getWidth() - this.scaledWidth) / 2;
                int y = (this.getHeight() - this.scaledHeight) / 2;
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.translate(x, y);
                x = 0;
                y = 0;
                if (ImageEditorPanel.this.patches.size() == 0) {
                    g.drawImage(ImageEditorPanel.this.image, 0, 0, this.scaledWidth, this.scaledHeight, null);
                    g2.dispose();
                    return;
                }
                int fixedIndex = 0;
                int horizontalIndex = 0;
                int verticalIndex = 0;
                int patchIndex = 0;
                float vWeightSum = 1.0f;
                float vRemainder = this.remainderVertical;
                boolean vStretch = ImageEditorPanel.this.verticalStartWithPatch;
                while (y < this.scaledHeight - 1) {
                    boolean hStretch = ImageEditorPanel.this.horizontalStartWithPatch;
                    int height = 0;
                    float vExtra = 0.0f;
                    float hWeightSum = 1.0f;
                    float hRemainder = this.remainderHorizontal;
                    while (x < this.scaledWidth - 1) {
                        int width;
                        float extra;
                        Rectangle r;
                        if (!vStretch) {
                            if (hStretch) {
                                r = (Rectangle)ImageEditorPanel.this.horizontalPatches.get(horizontalIndex++);
                                extra = (float)r.width / StretchesViewer.this.horizontalPatchesSum;
                                width = (int)(extra * hRemainder / hWeightSum);
                                hWeightSum -= extra;
                                hRemainder -= (float)width;
                                g.drawImage(ImageEditorPanel.this.image, x, y, x + width, y + r.height, r.x, r.y, r.x + r.width, r.y + r.height, null);
                                x += width;
                            } else {
                                r = (Rectangle)ImageEditorPanel.this.fixed.get(fixedIndex++);
                                g.drawImage(ImageEditorPanel.this.image, x, y, x + r.width, y + r.height, r.x, r.y, r.x + r.width, r.y + r.height, null);
                                x += r.width;
                            }
                            height = r.height;
                        } else if (hStretch) {
                            r = (Rectangle)ImageEditorPanel.this.patches.get(patchIndex++);
                            vExtra = (float)r.height / StretchesViewer.this.verticalPatchesSum;
                            height = (int)(vExtra * vRemainder / vWeightSum);
                            extra = (float)r.width / StretchesViewer.this.horizontalPatchesSum;
                            width = (int)(extra * hRemainder / hWeightSum);
                            hWeightSum -= extra;
                            hRemainder -= (float)width;
                            g.drawImage(ImageEditorPanel.this.image, x, y, x + width, y + height, r.x, r.y, r.x + r.width, r.y + r.height, null);
                            x += width;
                        } else {
                            r = (Rectangle)ImageEditorPanel.this.verticalPatches.get(verticalIndex++);
                            vExtra = (float)r.height / StretchesViewer.this.verticalPatchesSum;
                            height = (int)(vExtra * vRemainder / vWeightSum);
                            g.drawImage(ImageEditorPanel.this.image, x, y, x + r.width, y + height, r.x, r.y, r.x + r.width, r.y + r.height, null);
                            x += r.width;
                        }
                        hStretch = !hStretch;
                    }
                    x = 0;
                    y += height;
                    if (vStretch) {
                        vWeightSum -= vExtra;
                        vRemainder -= (float)height;
                    }
                    vStretch = !vStretch;
                }
                if (StretchesViewer.this.showPadding) {
                    g.setColor(this.PADDING_COLOR);
                    g.fillRect((Integer)((ImageEditorPanel)ImageEditorPanel.this).horizontalPadding.first, (Integer)((ImageEditorPanel)ImageEditorPanel.this).verticalPadding.first, this.scaledWidth - (Integer)((ImageEditorPanel)ImageEditorPanel.this).horizontalPadding.first - (Integer)((ImageEditorPanel)ImageEditorPanel.this).horizontalPadding.second, this.scaledHeight - (Integer)((ImageEditorPanel)ImageEditorPanel.this).verticalPadding.first - (Integer)((ImageEditorPanel)ImageEditorPanel.this).verticalPadding.second);
                }
                g2.dispose();
            }

            public Dimension getPreferredSize() {
                return StretchesViewer.this.size;
            }
        }
    }
}

