/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;

public class PortFieldEditor
extends IntegerFieldEditor {
    public boolean mRecursiveCheck = false;

    public PortFieldEditor(String name, String label, Composite parent) {
        super(name, label, parent);
        this.setValidateStrategy(0);
    }

    public int getCurrentValue() {
        int val;
        try {
            val = Integer.parseInt(this.getStringValue());
        }
        catch (NumberFormatException nfe) {
            val = -1;
        }
        return val;
    }

    protected boolean checkState() {
        if (!super.checkState()) {
            return false;
        }
        boolean err = false;
        int val = this.getCurrentValue();
        if (val < 1024 || val > Short.MAX_VALUE) {
            this.setErrorMessage("Port must be between 1024 and 32767");
            err = true;
        } else {
            this.setErrorMessage(null);
            err = false;
        }
        this.showErrorMessage();
        return !err;
    }

    protected void updateCheckState(PortFieldEditor pfe) {
        pfe.refreshValidState();
    }
}

