/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.handler;

import com.android.ddmlib.SyncService;
import com.android.ddmuilib.SyncProgressMonitor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class BaseFileHandler {
    protected final Shell mParentShell;

    public BaseFileHandler(Shell parentShell) {
        this.mParentShell = parentShell;
    }

    protected SyncService.SyncResult promptAndPull(SyncService sync, String localFileName, String remoteFilePath, String title) throws InvocationTargetException, InterruptedException {
        FileDialog fileDialog = new FileDialog(this.mParentShell, 8192);
        fileDialog.setText(title);
        fileDialog.setFileName(localFileName);
        String localFilePath = fileDialog.open();
        if (localFilePath != null) {
            return this.pull(sync, localFilePath, remoteFilePath);
        }
        return null;
    }

    protected SyncService.SyncResult pull(final SyncService sync, final String localFilePath, final String remoteFilePath) throws InvocationTargetException, InterruptedException {
        final SyncService.SyncResult[] res = new SyncService.SyncResult[1];
        new ProgressMonitorDialog(this.mParentShell).run(true, true, new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) {
                try {
                    res[0] = sync.pullFile(remoteFilePath, localFilePath, (SyncService.ISyncProgressMonitor)new SyncProgressMonitor(monitor, String.format("Pulling %1$s from the device", remoteFilePath)));
                }
                finally {
                    sync.close();
                }
            }
        });
        return res[0];
    }
}

