/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.handler;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.SyncService;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.console.DdmConsole;
import com.android.ddmuilib.handler.BaseFileHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class MethodProfilingHandler
extends BaseFileHandler
implements ClientData.IMethodProfilingHandler {
    public MethodProfilingHandler(Shell parentShell) {
        super(parentShell);
    }

    public void onFailure(final Client client) {
        this.mParentShell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                MethodProfilingHandler.this.displayError("Unable to create Method Profiling file for application '%1$s'.\nCheck logcat for more information.", new Object[]{client.getClientData().getClientDescription()});
            }
        });
    }

    public void onSuccess(final String remoteFilePath, final Client client) {
        this.mParentShell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (remoteFilePath == null) {
                    MethodProfilingHandler.this.displayError("Unable to download trace file: unknown file name.\nThis can happen if you disconnected the device while recording the trace.", new Object[0]);
                    return;
                }
                IDevice device = client.getDevice();
                try {
                    SyncService sync = client.getDevice().getSyncService();
                    if (sync != null) {
                        MethodProfilingHandler.this.pullAndOpen(sync, remoteFilePath);
                    } else {
                        MethodProfilingHandler.this.displayError("Unable to download trace file from device '%1$s'.", new Object[]{device.getSerialNumber()});
                    }
                }
                catch (Exception e) {
                    MethodProfilingHandler.this.displayError("Unable to download trace file from device '%1$s'.", new Object[]{device.getSerialNumber()});
                }
            }
        });
    }

    private void pullAndOpen(SyncService sync, String remoteFilePath) throws InvocationTargetException, InterruptedException, IOException {
        File temp = File.createTempFile("android", ".trace");
        String tempPath = temp.getAbsolutePath();
        SyncService.SyncResult result = this.pull(sync, tempPath, remoteFilePath);
        if (result != null) {
            if (result.getCode() == 0) {
                this.openInTraceview(tempPath);
            } else {
                this.displayError("Unable to download trace file:\n\n%1$s", result.getMessage());
            }
        } else {
            this.displayError("Unable to download trace file.", new Object[0]);
        }
    }

    private void openInTraceview(String tempPath) {
        String[] command = new String[]{DdmUiPreferences.getTraceview(), tempPath};
        try {
            final Process p = Runtime.getRuntime().exec(command);
            new Thread("Traceview output"){

                public void run() {
                    InputStreamReader is = new InputStreamReader(p.getErrorStream());
                    BufferedReader resultReader = new BufferedReader(is);
                    try {
                        String line;
                        while ((line = resultReader.readLine()) != null) {
                            DdmConsole.printErrorToConsole("Traceview: " + line);
                        }
                        p.waitFor();
                    }
                    catch (Exception e) {
                        Log.e((String)"traceview", (Throwable)e);
                    }
                }
            }.start();
        }
        catch (IOException e) {
            Log.e((String)"traceview", (Throwable)e);
        }
    }

    private void displayError(String format, Object ... args) {
        MessageDialog.openError((Shell)this.mParentShell, (String)"Method Profiling Error", (String)String.format(format, args));
    }
}

