/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class EventLogImporter {
    private String[] mTags;
    private String[] mLog;

    public EventLogImporter(String filePath) throws FileNotFoundException {
        String top = System.getenv("ANDROID_BUILD_TOP");
        if (top == null) {
            throw new FileNotFoundException();
        }
        String tagFile = top + "/system/core/logcat/event-log-tags";
        BufferedReader tagReader = new BufferedReader(new InputStreamReader(new FileInputStream(tagFile)));
        BufferedReader eventReader = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
        try {
            this.readTags(tagReader);
            this.readLog(eventReader);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public String[] getTags() {
        return this.mTags;
    }

    public String[] getLog() {
        return this.mLog;
    }

    private void readTags(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> content = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            content.add(line);
        }
        this.mTags = content.toArray(new String[content.size()]);
    }

    private void readLog(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> content = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            content.add(line);
        }
        this.mLog = content.toArray(new String[content.size()]);
    }
}

