/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddms;

import com.android.ddmlib.DdmConstants;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Log;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.PortFieldEditor;
import com.android.sdkstats.SdkStatsService;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public final class PrefsDialog {
    private static PreferenceStore mPrefStore;
    public static final String SHELL_X = "shellX";
    public static final String SHELL_Y = "shellY";
    public static final String SHELL_WIDTH = "shellWidth";
    public static final String SHELL_HEIGHT = "shellHeight";
    public static final String EXPLORER_SHELL_X = "explorerShellX";
    public static final String EXPLORER_SHELL_Y = "explorerShellY";
    public static final String EXPLORER_SHELL_WIDTH = "explorerShellWidth";
    public static final String EXPLORER_SHELL_HEIGHT = "explorerShellHeight";
    public static final String SHOW_NATIVE_HEAP = "native";
    public static final String LOGCAT_COLUMN_MODE = "ddmsLogColumnMode";
    public static final String LOGCAT_FONT = "ddmsLogFont";
    public static final String LOGCAT_COLUMN_MODE_AUTO = "auto";
    public static final String LOGCAT_COLUMN_MODE_MANUAL = "manual";
    private static final String PREFS_DEBUG_PORT_BASE = "adbDebugBasePort";
    private static final String PREFS_SELECTED_DEBUG_PORT = "debugSelectedPort";
    private static final String PREFS_DEFAULT_THREAD_UPDATE = "defaultThreadUpdateEnabled";
    private static final String PREFS_DEFAULT_HEAP_UPDATE = "defaultHeapUpdateEnabled";
    private static final String PREFS_THREAD_REFRESH_INTERVAL = "threadStatusInterval";
    private static final String PREFS_LOG_LEVEL = "ddmsLogLevel";
    private static final String PREFS_TIMEOUT = "timeOut";

    private PrefsDialog() {
    }

    public static PreferenceStore getStore() {
        return mPrefStore;
    }

    public static void save() {
        try {
            mPrefStore.save();
        }
        catch (IOException ioe) {
            Log.w((String)"ddms", (String)("Failed saving prefs file: " + ioe.getMessage()));
        }
    }

    public static void init() {
        assert (mPrefStore == null);
        mPrefStore = SdkStatsService.getPreferenceStore();
        if (mPrefStore == null) {
            Log.e((String)"ddms", (String)"failed to access both the user HOME directory and the system wide temp folder. Quitting.");
            System.exit(1);
        }
        PrefsDialog.setDefaults(System.getProperty("user.home"));
        mPrefStore.addPropertyChangeListener((IPropertyChangeListener)new ChangeListener());
        DdmPreferences.setDebugPortBase((int)mPrefStore.getInt(PREFS_DEBUG_PORT_BASE));
        DdmPreferences.setSelectedDebugPort((int)mPrefStore.getInt(PREFS_SELECTED_DEBUG_PORT));
        DdmPreferences.setLogLevel((String)mPrefStore.getString(PREFS_LOG_LEVEL));
        DdmPreferences.setInitialThreadUpdate((boolean)mPrefStore.getBoolean(PREFS_DEFAULT_THREAD_UPDATE));
        DdmPreferences.setInitialHeapUpdate((boolean)mPrefStore.getBoolean(PREFS_DEFAULT_HEAP_UPDATE));
        DdmPreferences.setTimeOut((int)mPrefStore.getInt(PREFS_TIMEOUT));
        String out = System.getenv("ANDROID_PRODUCT_OUT");
        DdmUiPreferences.setSymbolsLocation((String)(out + File.separator + "symbols"));
        DdmUiPreferences.setAddr2LineLocation((String)"arm-eabi-addr2line");
        String traceview = System.getProperty("com.android.ddms.bindir");
        traceview = traceview != null && traceview.length() != 0 ? traceview + File.separator + DdmConstants.FN_TRACEVIEW : DdmConstants.FN_TRACEVIEW;
        DdmUiPreferences.setTraceviewLocation((String)traceview);
        DdmUiPreferences.setStore((IPreferenceStore)mPrefStore);
        DdmUiPreferences.setThreadRefreshInterval((int)mPrefStore.getInt(PREFS_THREAD_REFRESH_INTERVAL));
    }

    private static void setDefaults(String homeDir) {
        mPrefStore.setDefault(PREFS_DEBUG_PORT_BASE, 8600);
        mPrefStore.setDefault(PREFS_SELECTED_DEBUG_PORT, 8700);
        mPrefStore.setDefault(PREFS_DEFAULT_THREAD_UPDATE, true);
        mPrefStore.setDefault(PREFS_DEFAULT_HEAP_UPDATE, false);
        mPrefStore.setDefault(PREFS_THREAD_REFRESH_INTERVAL, 4);
        mPrefStore.setDefault("textSaveDir", homeDir);
        mPrefStore.setDefault("imageSaveDir", homeDir);
        mPrefStore.setDefault(PREFS_LOG_LEVEL, "info");
        mPrefStore.setDefault(PREFS_TIMEOUT, 5000);
        FontData fdat = new FontData("Courier", 10, 0);
        mPrefStore.setDefault("textOutputFont", fdat.toString());
        mPrefStore.setDefault(SHELL_X, 100);
        mPrefStore.setDefault(SHELL_Y, 100);
        mPrefStore.setDefault(SHELL_WIDTH, 800);
        mPrefStore.setDefault(SHELL_HEIGHT, 600);
        mPrefStore.setDefault(EXPLORER_SHELL_X, 50);
        mPrefStore.setDefault(EXPLORER_SHELL_Y, 50);
        mPrefStore.setDefault(SHOW_NATIVE_HEAP, false);
    }

    public static void run(Shell shell) {
        assert (mPrefStore != null);
        PreferenceManager prefMgr = new PreferenceManager();
        PreferenceNode node = new PreferenceNode("debugger", (IPreferencePage)new DebuggerPrefs());
        prefMgr.addToRoot((IPreferenceNode)node);
        PreferenceNode subNode = new PreferenceNode("panel", (IPreferencePage)new PanelPrefs());
        prefMgr.addToRoot((IPreferenceNode)subNode);
        node = new PreferenceNode("LogCat", (IPreferencePage)new LogCatPrefs());
        prefMgr.addToRoot((IPreferenceNode)node);
        node = new PreferenceNode("misc", (IPreferencePage)new MiscPrefs());
        prefMgr.addToRoot((IPreferenceNode)node);
        node = new PreferenceNode("stats", (IPreferencePage)new UsageStatsPrefs());
        prefMgr.addToRoot((IPreferenceNode)node);
        PreferenceDialog dlg = new PreferenceDialog(shell, prefMgr);
        dlg.setPreferenceStore((IPreferenceStore)mPrefStore);
        dlg.open();
        try {
            mPrefStore.save();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private static class UsageStatsPrefs
    extends PreferencePage {
        private BooleanFieldEditor mOptInCheckbox;
        private Composite mTop;

        public UsageStatsPrefs() {
            this.setTitle("Usage Stats");
        }

        protected Control createContents(Composite parent) {
            this.mTop = new Composite(parent, 0);
            this.mTop.setLayout((Layout)new GridLayout(1, false));
            this.mTop.setLayoutData((Object)new GridData(1808));
            Link text = new Link(this.mTop, 64);
            text.setLayoutData((Object)new GridData(768));
            text.setText("By choosing to send certain usage statistics to Google, you can help us improve the Android SDK.  These usage statistics let us measure things like active usage of the SDK and let us know things like which versions of the SDK are in use and which tools are the most popular with developers.  This limited data is not associated with personal information about you, is examined on an aggregate basis, and is maintained in accordance with the <a href=\"http://www.google.com/intl/en/privacy.html\">Google Privacy Policy</a>.");
            text.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SdkStatsService.openUrl((String)event.text);
                }
            });
            this.mOptInCheckbox = new BooleanFieldEditor("pingOptIn", "Send usage statistics to Google.", this.mTop);
            this.mOptInCheckbox.setPage((DialogPage)this);
            this.mOptInCheckbox.setPreferenceStore(this.getPreferenceStore());
            this.mOptInCheckbox.load();
            return null;
        }

        protected Point doComputeSize() {
            if (this.mTop != null) {
                return this.mTop.computeSize(450, -1, true);
            }
            return super.doComputeSize();
        }

        protected void performDefaults() {
            if (this.mOptInCheckbox != null) {
                this.mOptInCheckbox.loadDefault();
            }
            super.performDefaults();
        }

        public void performApply() {
            if (this.mOptInCheckbox != null) {
                this.mOptInCheckbox.store();
            }
            super.performApply();
        }

        public boolean performOk() {
            if (this.mOptInCheckbox != null) {
                this.mOptInCheckbox.store();
            }
            return super.performOk();
        }
    }

    private static class MiscPrefs
    extends FieldEditorPreferencePage {
        public MiscPrefs() {
            super(0);
            this.setTitle("Misc");
        }

        protected void createFieldEditors() {
            IntegerFieldEditor ife = new IntegerFieldEditor(PrefsDialog.PREFS_TIMEOUT, "ADB connection time out (ms):", this.getFieldEditorParent());
            this.addField((FieldEditor)ife);
            DirectoryFieldEditor dfe = new DirectoryFieldEditor("textSaveDir", "Default text save dir:", this.getFieldEditorParent());
            this.addField((FieldEditor)dfe);
            dfe = new DirectoryFieldEditor("imageSaveDir", "Default image save dir:", this.getFieldEditorParent());
            this.addField((FieldEditor)dfe);
            FontFieldEditor ffe = new FontFieldEditor("textOutputFont", "Text output font:", this.getFieldEditorParent());
            this.addField((FieldEditor)ffe);
            RadioGroupFieldEditor rgfe = new RadioGroupFieldEditor(PrefsDialog.PREFS_LOG_LEVEL, "Logging Level", 1, (String[][])new String[][]{{"Verbose", Log.LogLevel.VERBOSE.getStringValue()}, {"Debug", Log.LogLevel.DEBUG.getStringValue()}, {"Info", Log.LogLevel.INFO.getStringValue()}, {"Warning", Log.LogLevel.WARN.getStringValue()}, {"Error", Log.LogLevel.ERROR.getStringValue()}, {"Assert", Log.LogLevel.ASSERT.getStringValue()}}, this.getFieldEditorParent(), true);
            this.addField((FieldEditor)rgfe);
        }
    }

    private static class LogCatPrefs
    extends FieldEditorPreferencePage {
        public LogCatPrefs() {
            super(0);
            this.setTitle("Logcat");
        }

        protected void createFieldEditors() {
            RadioGroupFieldEditor rgfe = new RadioGroupFieldEditor(PrefsDialog.LOGCAT_COLUMN_MODE, "Message Column Resizing Mode", 1, (String[][])new String[][]{{"Manual", PrefsDialog.LOGCAT_COLUMN_MODE_MANUAL}, {"Automatic", PrefsDialog.LOGCAT_COLUMN_MODE_AUTO}}, this.getFieldEditorParent(), true);
            this.addField((FieldEditor)rgfe);
            FontFieldEditor ffe = new FontFieldEditor(PrefsDialog.LOGCAT_FONT, "Text output font:", this.getFieldEditorParent());
            this.addField((FieldEditor)ffe);
        }
    }

    private static class PanelPrefs
    extends FieldEditorPreferencePage {
        public PanelPrefs() {
            super(0);
            this.setTitle("Info Panels");
        }

        protected void createFieldEditors() {
            BooleanFieldEditor bfe = new BooleanFieldEditor(PrefsDialog.PREFS_DEFAULT_THREAD_UPDATE, "Thread updates enabled by default", this.getFieldEditorParent());
            this.addField((FieldEditor)bfe);
            bfe = new BooleanFieldEditor(PrefsDialog.PREFS_DEFAULT_HEAP_UPDATE, "Heap updates enabled by default", this.getFieldEditorParent());
            this.addField((FieldEditor)bfe);
            IntegerFieldEditor ife = new IntegerFieldEditor(PrefsDialog.PREFS_THREAD_REFRESH_INTERVAL, "Thread status interval (seconds):", this.getFieldEditorParent());
            ife.setValidRange(1, 60);
            this.addField((FieldEditor)ife);
        }
    }

    private static class DebuggerPrefs
    extends FieldEditorPreferencePage {
        public DebuggerPrefs() {
            super(1);
            this.setTitle("Debugger");
        }

        protected void createFieldEditors() {
            PortFieldEditor ife = new PortFieldEditor(PrefsDialog.PREFS_DEBUG_PORT_BASE, "Starting value for local port:", this.getFieldEditorParent());
            this.addField((FieldEditor)ife);
            ife = new PortFieldEditor(PrefsDialog.PREFS_SELECTED_DEBUG_PORT, "Port of Selected VM:", this.getFieldEditorParent());
            this.addField((FieldEditor)ife);
        }
    }

    private static class ChangeListener
    implements IPropertyChangeListener {
        private ChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String changed = event.getProperty();
            if (changed.equals(PrefsDialog.PREFS_DEBUG_PORT_BASE)) {
                DdmPreferences.setDebugPortBase((int)mPrefStore.getInt(PrefsDialog.PREFS_DEBUG_PORT_BASE));
            } else if (changed.equals(PrefsDialog.PREFS_SELECTED_DEBUG_PORT)) {
                DdmPreferences.setSelectedDebugPort((int)mPrefStore.getInt(PrefsDialog.PREFS_SELECTED_DEBUG_PORT));
            } else if (changed.equals(PrefsDialog.PREFS_LOG_LEVEL)) {
                DdmPreferences.setLogLevel((String)((String)event.getNewValue()));
            } else if (changed.equals("textSaveDir")) {
                mPrefStore.setValue("lastTextSaveDir", (String)event.getNewValue());
            } else if (changed.equals("imageSaveDir")) {
                mPrefStore.setValue("lastImageSaveDir", (String)event.getNewValue());
            } else if (changed.equals(PrefsDialog.PREFS_TIMEOUT)) {
                DdmPreferences.setTimeOut((int)mPrefStore.getInt(PrefsDialog.PREFS_TIMEOUT));
            } else {
                Log.v((String)"ddms", (String)("Preference change: " + event.getProperty() + ": '" + event.getOldValue() + "' --> '" + event.getNewValue() + "'"));
            }
        }
    }
}

