/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.app.Application;
import android.app.IActivityManager;
import android.app.Notification;
import android.content.ComponentCallbacks;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public abstract class Service
extends ContextWrapper
implements ComponentCallbacks {
    public static final String TAG = "Service";
    public static final int START_CONTINUATION_MASK = 15;
    public static final int START_STICKY_COMPATIBILITY = 0;
    public static final int START_STICKY = 1;
    public static final int START_NOT_STICKY = 2;
    public static final int START_REDELIVER_INTENT = 3;
    public static final int START_FLAG_REDELIVERY = 1;
    public static final int START_FLAG_RETRY = 2;
    public ActivityThread mThread = null;
    public String mClassName = null;
    public IBinder mToken = null;
    public Application mApplication = null;
    public IActivityManager mActivityManager = null;
    public boolean mStartCompatibility = false;

    public Service() {
        super(null);
    }

    public Application getApplication() {
        return this.mApplication;
    }

    public void onCreate() {
    }

    @Deprecated
    public void onStart(Intent intent, int startId) {
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.onStart(intent, startId);
        return this.mStartCompatibility ? 0 : 1;
    }

    public void onDestroy() {
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onLowMemory() {
    }

    public abstract IBinder onBind(Intent var1);

    public boolean onUnbind(Intent intent) {
        return false;
    }

    public void onRebind(Intent intent) {
    }

    public void stopSelf() {
        this.stopSelf(-1);
    }

    public void stopSelf(int startId) {
        if (this.mActivityManager == null) {
            return;
        }
        try {
            this.mActivityManager.stopServiceToken(new ComponentName((Context)this, this.mClassName), this.mToken, startId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean stopSelfResult(int startId) {
        if (this.mActivityManager == null) {
            return false;
        }
        try {
            return this.mActivityManager.stopServiceToken(new ComponentName((Context)this, this.mClassName), this.mToken, startId);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Deprecated
    public void setForeground(boolean isForeground) {
        Log.w(TAG, "setForeground: ignoring old API call on " + this.getClass().getName());
    }

    public void startForeground(int id2, Notification notification) {
        try {
            this.mActivityManager.setServiceForeground(new ComponentName((Context)this, this.mClassName), this.mToken, id2, notification, true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void stopForeground(boolean removeNotification) {
        try {
            this.mActivityManager.setServiceForeground(new ComponentName((Context)this, this.mClassName), this.mToken, 0, null, removeNotification);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.println("nothing to dump");
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public void attach(Context context, ActivityThread thread, String className, IBinder token, Application application, Object activityManager) {
        this.attachBaseContext(context);
        this.mThread = thread;
        this.mClassName = className;
        this.mToken = token;
        this.mApplication = application;
        this.mActivityManager = (IActivityManager)activityManager;
        this.mStartCompatibility = this.getApplicationInfo().targetSdkVersion < 5;
    }

    public String getClassName() {
        return this.mClassName;
    }
}

