/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Printer;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class WallpaperInfo
implements Parcelable {
    public static final String TAG = "WallpaperInfo";
    public final ResolveInfo mService;
    public final String mSettingsActivityName;
    public final int mThumbnailResource;
    public final int mAuthorResource;
    public final int mDescriptionResource;
    public static final Parcelable.Creator<WallpaperInfo> CREATOR = new Parcelable.Creator<WallpaperInfo>(){

        @Override
        public WallpaperInfo createFromParcel(Parcel source) {
            return new WallpaperInfo(source);
        }

        public WallpaperInfo[] newArray(int size) {
            return new WallpaperInfo[size];
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WallpaperInfo(Context context, ResolveInfo service) throws XmlPullParserException, IOException {
        this.mService = service;
        ServiceInfo si = service.serviceInfo;
        PackageManager pm = context.getPackageManager();
        String settingsActivityComponent = null;
        int thumbnailRes = -1;
        int authorRes = -1;
        int descriptionRes = -1;
        XmlResourceParser parser = null;
        try {
            int type;
            parser = si.loadXmlMetaData(pm, "android.service.wallpaper");
            if (parser == null) {
                throw new XmlPullParserException("No android.service.wallpaper meta-data");
            }
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"wallpaper".equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with wallpaper tag");
            }
            TypedArray sa = context.getResources().obtainAttributes(attrs, R.styleable.Wallpaper);
            settingsActivityComponent = sa.getString(0);
            thumbnailRes = sa.getResourceId(1, -1);
            authorRes = sa.getResourceId(2, -1);
            descriptionRes = sa.getResourceId(3, -1);
            sa.recycle();
            Object var15_14 = null;
            if (parser != null) {
                parser.close();
            }
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            if (parser != null) {
                parser.close();
            }
            throw throwable;
        }
        this.mSettingsActivityName = settingsActivityComponent;
        this.mThumbnailResource = thumbnailRes;
        this.mAuthorResource = authorRes;
        this.mDescriptionResource = descriptionRes;
    }

    public WallpaperInfo(Parcel source) {
        this.mSettingsActivityName = source.readString();
        this.mThumbnailResource = source.readInt();
        this.mAuthorResource = source.readInt();
        this.mDescriptionResource = source.readInt();
        this.mService = ResolveInfo.CREATOR.createFromParcel(source);
    }

    public String getPackageName() {
        return this.mService.serviceInfo.packageName;
    }

    public String getServiceName() {
        return this.mService.serviceInfo.name;
    }

    public ServiceInfo getServiceInfo() {
        return this.mService.serviceInfo;
    }

    public ComponentName getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    public CharSequence loadLabel(PackageManager pm) {
        return this.mService.loadLabel(pm);
    }

    public Drawable loadIcon(PackageManager pm) {
        return this.mService.loadIcon(pm);
    }

    public Drawable loadThumbnail(PackageManager pm) {
        if (this.mThumbnailResource < 0) {
            return null;
        }
        return pm.getDrawable(this.mService.serviceInfo.packageName, this.mThumbnailResource, null);
    }

    public CharSequence loadAuthor(PackageManager pm) throws Resources.NotFoundException {
        if (this.mAuthorResource <= 0) {
            throw new Resources.NotFoundException();
        }
        return pm.getText(this.mService.resolvePackageName != null ? this.mService.resolvePackageName : this.getPackageName(), this.mAuthorResource, null);
    }

    public CharSequence loadDescription(PackageManager pm) throws Resources.NotFoundException {
        if (this.mDescriptionResource <= 0) {
            throw new Resources.NotFoundException();
        }
        return pm.getText(this.mService.resolvePackageName != null ? this.mService.resolvePackageName : this.getPackageName(), this.mDescriptionResource, null);
    }

    public String getSettingsActivity() {
        return this.mSettingsActivityName;
    }

    public void dump(Printer pw, String prefix) {
        pw.println(prefix + "Service:");
        this.mService.dump(pw, prefix + "  ");
        pw.println(prefix + "mSettingsActivityName=" + this.mSettingsActivityName);
    }

    public String toString() {
        return "WallpaperInfo{" + this.mService.serviceInfo.name + ", settings: " + this.mSettingsActivityName + "}";
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mSettingsActivityName);
        dest.writeInt(this.mThumbnailResource);
        dest.writeInt(this.mAuthorResource);
        dest.writeInt(this.mDescriptionResource);
        this.mService.writeToParcel(dest, flags);
    }

    public int describeContents() {
        return 0;
    }
}

