/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.IBluetoothCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.RemoteException;

public interface IBluetooth
extends IInterface {
    public boolean isEnabled() throws RemoteException;

    public int getBluetoothState() throws RemoteException;

    public boolean enable() throws RemoteException;

    public boolean disable(boolean var1) throws RemoteException;

    public String getAddress() throws RemoteException;

    public String getName() throws RemoteException;

    public boolean setName(String var1) throws RemoteException;

    public int getScanMode() throws RemoteException;

    public boolean setScanMode(int var1, int var2) throws RemoteException;

    public int getDiscoverableTimeout() throws RemoteException;

    public boolean setDiscoverableTimeout(int var1) throws RemoteException;

    public boolean startDiscovery() throws RemoteException;

    public boolean cancelDiscovery() throws RemoteException;

    public boolean isDiscovering() throws RemoteException;

    public boolean createBond(String var1) throws RemoteException;

    public boolean cancelBondProcess(String var1) throws RemoteException;

    public boolean removeBond(String var1) throws RemoteException;

    public String[] listBonds() throws RemoteException;

    public int getBondState(String var1) throws RemoteException;

    public String getRemoteName(String var1) throws RemoteException;

    public int getRemoteClass(String var1) throws RemoteException;

    public ParcelUuid[] getRemoteUuids(String var1) throws RemoteException;

    public boolean fetchRemoteUuids(String var1, ParcelUuid var2, IBluetoothCallback var3) throws RemoteException;

    public int getRemoteServiceChannel(String var1, ParcelUuid var2) throws RemoteException;

    public boolean setPin(String var1, byte[] var2) throws RemoteException;

    public boolean setPasskey(String var1, int var2) throws RemoteException;

    public boolean setPairingConfirmation(String var1, boolean var2) throws RemoteException;

    public boolean cancelPairingUserInput(String var1) throws RemoteException;

    public boolean setTrust(String var1, boolean var2) throws RemoteException;

    public boolean getTrustState(String var1) throws RemoteException;

    public int addRfcommServiceRecord(String var1, ParcelUuid var2, int var3, IBinder var4) throws RemoteException;

    public void removeServiceRecord(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetooth {
        public static final String DESCRIPTOR = "android.bluetooth.IBluetooth";
        public static final int TRANSACTION_isEnabled = 1;
        public static final int TRANSACTION_getBluetoothState = 2;
        public static final int TRANSACTION_enable = 3;
        public static final int TRANSACTION_disable = 4;
        public static final int TRANSACTION_getAddress = 5;
        public static final int TRANSACTION_getName = 6;
        public static final int TRANSACTION_setName = 7;
        public static final int TRANSACTION_getScanMode = 8;
        public static final int TRANSACTION_setScanMode = 9;
        public static final int TRANSACTION_getDiscoverableTimeout = 10;
        public static final int TRANSACTION_setDiscoverableTimeout = 11;
        public static final int TRANSACTION_startDiscovery = 12;
        public static final int TRANSACTION_cancelDiscovery = 13;
        public static final int TRANSACTION_isDiscovering = 14;
        public static final int TRANSACTION_createBond = 15;
        public static final int TRANSACTION_cancelBondProcess = 16;
        public static final int TRANSACTION_removeBond = 17;
        public static final int TRANSACTION_listBonds = 18;
        public static final int TRANSACTION_getBondState = 19;
        public static final int TRANSACTION_getRemoteName = 20;
        public static final int TRANSACTION_getRemoteClass = 21;
        public static final int TRANSACTION_getRemoteUuids = 22;
        public static final int TRANSACTION_fetchRemoteUuids = 23;
        public static final int TRANSACTION_getRemoteServiceChannel = 24;
        public static final int TRANSACTION_setPin = 25;
        public static final int TRANSACTION_setPasskey = 26;
        public static final int TRANSACTION_setPairingConfirmation = 27;
        public static final int TRANSACTION_cancelPairingUserInput = 28;
        public static final int TRANSACTION_setTrust = 29;
        public static final int TRANSACTION_getTrustState = 30;
        public static final int TRANSACTION_addRfcommServiceRecord = 31;
        public static final int TRANSACTION_removeServiceRecord = 32;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetooth asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetooth) {
                return (IBluetooth)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getBluetoothState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.enable();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _arg0 = 0 != data.readInt();
                    boolean _result = this.disable(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getAddress();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    boolean _result = this.setName(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getScanMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _result = this.setScanMode(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getDiscoverableTimeout();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    boolean _result = this.setDiscoverableTimeout(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.startDiscovery();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.cancelDiscovery();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 14: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isDiscovering();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 15: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    boolean _result = this.createBond(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 16: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    boolean _result = this.cancelBondProcess(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 17: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    boolean _result = this.removeBond(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(DESCRIPTOR);
                    String[] _result = this.listBonds();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 19: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _result = this.getBondState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 20: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _result = this.getRemoteName(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 21: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _result = this.getRemoteClass(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 22: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    Parcelable[] _result = this.getRemoteUuids(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 23: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    ParcelUuid _arg1 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    IBluetoothCallback _arg2 = IBluetoothCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.fetchRemoteUuids(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 24: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    ParcelUuid _arg1 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _result = this.getRemoteServiceChannel(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 25: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    byte[] _arg1 = data.createByteArray();
                    boolean _result = this.setPin(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 26: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.setPasskey(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 27: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _result = this.setPairingConfirmation(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 28: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    boolean _result = this.cancelPairingUserInput(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 29: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _result = this.setTrust(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 30: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    boolean _result = this.getTrustState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 31: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    ParcelUuid _arg1 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    IBinder _arg3 = data.readStrongBinder();
                    int _result = this.addRfcommServiceRecord(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 32: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.removeServiceRecord(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static class Proxy
        implements IBluetooth {
            public IBinder mRemote;

            public Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int getBluetoothState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean enable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean disable(boolean persistSetting) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(persistSetting ? 1 : 0);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String getAddress() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String getName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setName(String name) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int getScanMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setScanMode(int mode, int duration) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeInt(duration);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var7_6 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int getDiscoverableTimeout() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setDiscoverableTimeout(int timeout) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(timeout);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean startDiscovery() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancelDiscovery() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isDiscovering() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean createBond(String address) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancelBondProcess(String address) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean removeBond(String address) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] listBonds() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int getBondState(String address) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String getRemoteName(String address) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int getRemoteClass(String address) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ParcelUuid[] getRemoteUuids(String address) throws RemoteException {
                ParcelUuid[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(ParcelUuid.CREATOR);
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean fetchRemoteUuids(String address, ParcelUuid uuid, IBluetoothCallback callback) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    if (uuid != null) {
                        _data.writeInt(1);
                        uuid.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var8_7 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int getRemoteServiceChannel(String address, ParcelUuid uuid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    if (uuid != null) {
                        _data.writeInt(1);
                        uuid.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    Object var7_6 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setPin(String address, byte[] pin) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeByteArray(pin);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var7_6 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setPasskey(String address, int passkey) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(passkey);
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var7_6 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setPairingConfirmation(String address, boolean confirm) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(confirm ? 1 : 0);
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var7_6 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancelPairingUserInput(String address) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setTrust(String address, boolean value) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(value ? 1 : 0);
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var7_6 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean getTrustState(String address) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int addRfcommServiceRecord(String serviceName, ParcelUuid uuid, int channel, IBinder b) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(serviceName);
                    if (uuid != null) {
                        _data.writeInt(1);
                        uuid.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(channel);
                    _data.writeStrongBinder(b);
                    this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    Object var9_8 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeServiceRecord(int handle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(handle);
                    this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }
        }
    }
}

