/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.SyncContext;
import android.content.SyncResult;
import android.content.SyncableContentProvider;
import android.content.TempProviderSyncResult;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Debug;
import android.text.TextUtils;
import android.util.Log;

public abstract class AbstractTableMerger {
    public ContentValues mValues;
    public SQLiteDatabase mDb;
    public String mTable;
    public Uri mTableURL;
    public String mDeletedTable;
    public Uri mDeletedTableURL;
    public static ContentValues mSyncMarkValues = new ContentValues();
    public static boolean TRACE;
    public static final String TAG = "AbstractTableMerger";
    public static final String[] syncDirtyProjection;
    public static final String[] syncIdAndVersionProjection;
    public volatile boolean mIsMergeCancelled;
    public static final String SELECT_MARKED = "_sync_mark> 0 and _sync_account=? and _sync_account_type=?";
    public static final String SELECT_BY_SYNC_ID_AND_ACCOUNT = "_sync_id=? and _sync_account=? and _sync_account_type=?";
    public static final String SELECT_BY_ID = "_id=?";
    public static final String SELECT_UNSYNCED = "(_sync_account IS NULL OR (_sync_account=? and _sync_account_type=?)) and (_sync_id IS NULL OR (_sync_dirty > 0 and _sync_version IS NOT NULL))";

    public AbstractTableMerger(SQLiteDatabase database, String table, Uri tableURL, String deletedTable, Uri deletedTableURL) {
        this.mDb = database;
        this.mTable = table;
        this.mTableURL = tableURL;
        this.mDeletedTable = deletedTable;
        this.mDeletedTableURL = deletedTableURL;
        this.mValues = new ContentValues();
    }

    public abstract void insertRow(ContentProvider var1, Cursor var2);

    public abstract void updateRow(long var1, ContentProvider var3, Cursor var4);

    public abstract void resolveRow(long var1, String var3, ContentProvider var4, Cursor var5);

    public void deleteRow(Cursor localCursor) {
        localCursor.deleteRow();
    }

    public abstract void notifyChanges();

    public static boolean findInCursor(Cursor cursor, int column, String id2) {
        while (!cursor.isAfterLast() && !cursor.isNull(column)) {
            int comp = id2.compareTo(cursor.getString(column));
            if (comp > 0) {
                cursor.moveToNext();
                continue;
            }
            return comp == 0;
        }
        return false;
    }

    public void onMergeCancelled() {
        this.mIsMergeCancelled = true;
    }

    public void merge(SyncContext context, Account account, SyncableContentProvider serverDiffs, TempProviderSyncResult result, SyncResult syncResult, SyncableContentProvider temporaryInstanceFactory) {
        this.mIsMergeCancelled = false;
        if (serverDiffs != null) {
            if (!this.mDb.isDbLockedByCurrentThread()) {
                throw new IllegalStateException("this must be called from within a DB transaction");
            }
            this.mergeServerDiffs(context, account, serverDiffs, syncResult);
            this.notifyChanges();
        }
        if (result != null) {
            this.findLocalChanges(result, temporaryInstanceFactory, account, syncResult);
        }
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "merge complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mergeServerDiffs(SyncContext context, Account account, SyncableContentProvider serverDiffs, SyncResult syncResult) {
        boolean diffsArePartial = serverDiffs.getContainsDiffs();
        this.mDb.update(this.mTable, mSyncMarkValues, null, null);
        if (this.mDeletedTable != null) {
            this.mDb.update(this.mDeletedTable, mSyncMarkValues, null, null);
        }
        Cursor localCursor = null;
        Cursor deletedCursor = null;
        Cursor diffsCursor = null;
        try {
            int localCount;
            block64: {
                String[] accountSelectionArgs = new String[]{account.name, account.type};
                localCursor = this.mDb.query(this.mTable, syncDirtyProjection, SELECT_MARKED, accountSelectionArgs, null, null, this.mTable + "." + "_sync_id");
                deletedCursor = this.mDeletedTable != null ? this.mDb.query(this.mDeletedTable, syncIdAndVersionProjection, SELECT_MARKED, accountSelectionArgs, null, null, this.mDeletedTable + "." + "_sync_id") : this.mDb.rawQuery("select 'a' as _sync_id, 'b' as _sync_version limit 0", null);
                diffsCursor = serverDiffs.query(this.mTableURL, null, null, null, this.mTable + "." + "_sync_id");
                int deletedSyncIDColumn = deletedCursor.getColumnIndexOrThrow("_sync_id");
                int deletedSyncVersionColumn = deletedCursor.getColumnIndexOrThrow("_sync_version");
                int serverSyncIDColumn = diffsCursor.getColumnIndexOrThrow("_sync_id");
                int serverSyncVersionColumn = diffsCursor.getColumnIndexOrThrow("_sync_version");
                int serverSyncLocalIdColumn = diffsCursor.getColumnIndexOrThrow("_sync_local_id");
                String lastSyncId = null;
                int diffsCount = 0;
                localCount = 0;
                localCursor.moveToFirst();
                deletedCursor.moveToFirst();
                while (true) {
                    boolean insert;
                    boolean update;
                    boolean conflict;
                    long localRowId;
                    String serverSyncId;
                    block65: {
                        block66: {
                            boolean recordChanged;
                            boolean localSyncDirty;
                            String localSyncID;
                            String localSyncVersion;
                            String serverSyncVersion;
                            if (diffsCursor.moveToNext()) {
                                if (this.mIsMergeCancelled) {
                                    Object var31_30 = null;
                                    if (diffsCursor != null) {
                                        diffsCursor.close();
                                    }
                                    if (localCursor != null) {
                                        localCursor.close();
                                    }
                                    if (deletedCursor == null) return;
                                    deletedCursor.close();
                                    return;
                                }
                                this.mDb.yieldIfContended();
                                serverSyncId = diffsCursor.getString(serverSyncIDColumn);
                                serverSyncVersion = diffsCursor.getString(serverSyncVersionColumn);
                                localRowId = 0L;
                                localSyncVersion = null;
                                context.setStatusText("Processing " + ++diffsCount + "/" + diffsCursor.getCount());
                                if (Log.isLoggable(TAG, 2)) {
                                    Log.v(TAG, "processing server entry " + diffsCount + ", " + serverSyncId);
                                }
                                if (TRACE) {
                                    if (diffsCount == 10) {
                                        Debug.startMethodTracing("atmtrace");
                                    }
                                    if (diffsCount == 20) {
                                        Debug.stopMethodTracing();
                                    }
                                }
                                conflict = false;
                                update = false;
                                insert = false;
                                if (Log.isLoggable(TAG, 2)) {
                                    Log.v(TAG, "found event with serverSyncID " + serverSyncId);
                                }
                                if (TextUtils.isEmpty(serverSyncId)) {
                                    if (!Log.isLoggable(TAG, 2)) continue;
                                    Log.e(TAG, "server entry doesn't have a serverSyncID");
                                    continue;
                                }
                                if (serverSyncId.equals(lastSyncId)) {
                                    if (!Log.isLoggable(TAG, 2)) continue;
                                    Log.v(TAG, "skipping record with duplicate remote server id " + lastSyncId);
                                    continue;
                                }
                                lastSyncId = serverSyncId;
                                localSyncID = null;
                                localSyncDirty = false;
                            } else {
                                if (Log.isLoggable(TAG, 2)) {
                                    Log.v(TAG, "processed " + diffsCount + " server entries");
                                }
                                if (!diffsArePartial) {
                                    break;
                                }
                                break block64;
                            }
                            while (!localCursor.isAfterLast()) {
                                if (this.mIsMergeCancelled) {
                                    Object var31_31 = null;
                                    if (diffsCursor != null) {
                                        diffsCursor.close();
                                    }
                                    if (localCursor != null) {
                                        localCursor.close();
                                    }
                                    if (deletedCursor == null) return;
                                    deletedCursor.close();
                                    return;
                                }
                                ++localCount;
                                localSyncID = localCursor.getString(2);
                                if (TextUtils.isEmpty(localSyncID)) {
                                    if (Log.isLoggable(TAG, 2)) {
                                        Log.v(TAG, "local record " + localCursor.getLong(1) + " has no _sync_id, ignoring");
                                    }
                                    localCursor.moveToNext();
                                    localSyncID = null;
                                    continue;
                                }
                                int comp = serverSyncId.compareTo(localSyncID);
                                if (comp > 0) {
                                    if (Log.isLoggable(TAG, 2)) {
                                        Log.v(TAG, "local record " + localCursor.getLong(1) + " has _sync_id " + localSyncID + " that is < server _sync_id " + serverSyncId);
                                    }
                                    if (diffsArePartial) {
                                        localCursor.moveToNext();
                                    } else {
                                        this.deleteRow(localCursor);
                                        if (this.mDeletedTable != null) {
                                            this.mDb.delete(this.mDeletedTable, "_sync_id=?", new String[]{localSyncID});
                                        }
                                        ++syncResult.stats.numDeletes;
                                        this.mDb.yieldIfContended();
                                    }
                                    localSyncID = null;
                                    continue;
                                }
                                if (comp < 0) {
                                    if (Log.isLoggable(TAG, 2)) {
                                        Log.v(TAG, "local record " + localCursor.getLong(1) + " has _sync_id " + localSyncID + " that is > server _sync_id " + serverSyncId);
                                    }
                                    localSyncID = null;
                                }
                                if (comp != 0) break;
                                if (Log.isLoggable(TAG, 2)) {
                                    Log.v(TAG, "local record " + localCursor.getLong(1) + " has _sync_id " + localSyncID + " that matches the server _sync_id");
                                }
                                localSyncDirty = localCursor.getInt(0) != 0;
                                localRowId = localCursor.getLong(1);
                                localSyncVersion = localCursor.getString(3);
                                localCursor.moveToNext();
                                break;
                            }
                            if (AbstractTableMerger.findInCursor(deletedCursor, deletedSyncIDColumn, serverSyncId)) {
                                String deletedSyncVersion;
                                if (Log.isLoggable(TAG, 2)) {
                                    Log.v(TAG, "remote record " + serverSyncId + " is in the deleted table");
                                }
                                if (TextUtils.equals(deletedSyncVersion = deletedCursor.getString(deletedSyncVersionColumn), serverSyncVersion)) continue;
                                if (Log.isLoggable(TAG, 2)) {
                                    Log.v(TAG, "setting version of deleted record " + serverSyncId + " to " + serverSyncVersion);
                                }
                                ContentValues values = new ContentValues();
                                values.put("_sync_version", serverSyncVersion);
                                this.mDb.update(this.mDeletedTable, values, "_sync_id=?", new String[]{serverSyncId});
                                continue;
                            }
                            if (!diffsCursor.isNull(serverSyncLocalIdColumn)) {
                                localRowId = diffsCursor.getLong(serverSyncLocalIdColumn);
                                if (Log.isLoggable(TAG, 2)) {
                                    Log.v(TAG, "the remote record with sync id " + serverSyncId + " has a local sync id, " + localRowId);
                                }
                                localSyncID = serverSyncId;
                                localSyncDirty = false;
                                localSyncVersion = null;
                            }
                            if (TextUtils.isEmpty(localSyncID)) break block66;
                            boolean bl = recordChanged = localSyncVersion == null || serverSyncVersion == null || !serverSyncVersion.equals(localSyncVersion);
                            if (recordChanged) {
                                if (localSyncDirty) {
                                    if (Log.isLoggable(TAG, 2)) {
                                        Log.v(TAG, "remote record " + serverSyncId + " conflicts with local _sync_id " + localSyncID + ", local _id " + localRowId);
                                    }
                                    conflict = true;
                                    break block65;
                                } else {
                                    if (Log.isLoggable(TAG, 2)) {
                                        Log.v(TAG, "remote record " + serverSyncId + " updates local _sync_id " + localSyncID + ", local _id " + localRowId);
                                    }
                                    update = true;
                                }
                                break block65;
                            } else if (Log.isLoggable(TAG, 2)) {
                                Log.v(TAG, "Skipping update: localSyncVersion: " + localSyncVersion + ", serverSyncVersion: " + serverSyncVersion);
                            }
                            break block65;
                        }
                        if (Log.isLoggable(TAG, 2)) {
                            Log.v(TAG, "remote record " + serverSyncId + " is new, inserting");
                        }
                        insert = true;
                    }
                    if (update) {
                        this.updateRow(localRowId, serverDiffs, diffsCursor);
                        ++syncResult.stats.numUpdates;
                        continue;
                    }
                    if (conflict) {
                        this.resolveRow(localRowId, serverSyncId, serverDiffs, diffsCursor);
                        ++syncResult.stats.numUpdates;
                        continue;
                    }
                    if (!insert) continue;
                    this.insertRow(serverDiffs, diffsCursor);
                    ++syncResult.stats.numInserts;
                }
                while (!localCursor.isAfterLast() && !TextUtils.isEmpty(localCursor.getString(2))) {
                    if (this.mIsMergeCancelled) {
                        Object var31_32 = null;
                        if (diffsCursor != null) {
                            diffsCursor.close();
                        }
                        if (localCursor != null) {
                            localCursor.close();
                        }
                        if (deletedCursor == null) return;
                        deletedCursor.close();
                        return;
                    }
                    ++localCount;
                    String localSyncId = localCursor.getString(2);
                    if (Log.isLoggable(TAG, 2)) {
                        Log.v(TAG, "deleting local record " + localCursor.getLong(1) + " _sync_id " + localSyncId);
                    }
                    this.deleteRow(localCursor);
                    if (this.mDeletedTable != null) {
                        this.mDb.delete(this.mDeletedTable, "_sync_id=?", new String[]{localSyncId});
                    }
                    ++syncResult.stats.numDeletes;
                    this.mDb.yieldIfContended();
                }
            }
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "checked " + localCount + " local entries");
            }
            Object var31_33 = null;
            if (diffsCursor != null) {
                diffsCursor.close();
            }
            if (localCursor != null) {
                localCursor.close();
            }
            if (deletedCursor != null) {
                deletedCursor.close();
            }
        }
        catch (Throwable throwable) {
            Object var31_34 = null;
            if (diffsCursor != null) {
                diffsCursor.close();
            }
            if (localCursor != null) {
                localCursor.close();
            }
            if (deletedCursor == null) throw throwable;
            deletedCursor.close();
            throw throwable;
        }
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "applying deletions from the server");
        }
        if (this.mDeletedTableURL == null) return;
        diffsCursor = serverDiffs.query(this.mDeletedTableURL, null, null, null, null);
        try {
            while (diffsCursor.moveToNext()) {
                if (this.mIsMergeCancelled) {
                    Object var33_36 = null;
                    diffsCursor.close();
                    return;
                }
                this.fullyDeleteMatchingRows(diffsCursor, account, syncResult);
                this.mDb.yieldIfContended();
            }
            Object var33_37 = null;
            diffsCursor.close();
            return;
        }
        catch (Throwable throwable) {
            Object var33_38 = null;
            diffsCursor.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullyDeleteMatchingRows(Cursor diffsCursor, Account account, SyncResult syncResult) {
        String[] selectionArgs;
        int serverSyncIdColumn = diffsCursor.getColumnIndexOrThrow("_sync_id");
        boolean deleteBySyncId = !diffsCursor.isNull(serverSyncIdColumn);
        Cursor c = null;
        try {
            if (deleteBySyncId) {
                selectionArgs = new String[]{diffsCursor.getString(serverSyncIdColumn), account.name, account.type};
                c = this.mDb.query(this.mTable, new String[]{"_id"}, SELECT_BY_SYNC_ID_AND_ACCOUNT, selectionArgs, null, null, null);
            } else {
                int serverSyncLocalIdColumn = diffsCursor.getColumnIndexOrThrow("_sync_local_id");
                selectionArgs = new String[]{diffsCursor.getString(serverSyncLocalIdColumn)};
                c = this.mDb.query(this.mTable, new String[]{"_id"}, SELECT_BY_ID, selectionArgs, null, null, null);
            }
            c.moveToFirst();
            while (!c.isAfterLast()) {
                this.deleteRow(c);
                ++syncResult.stats.numDeletes;
            }
            Object var10_9 = null;
            if (c != null) {
                c.close();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (c != null) {
                c.close();
            }
            throw throwable;
        }
        if (deleteBySyncId && this.mDeletedTable != null) {
            this.mDb.delete(this.mDeletedTable, SELECT_BY_SYNC_ID_AND_ACCOUNT, selectionArgs);
        }
    }

    public void cursorRowToContentValues(Cursor cursor, ContentValues map) {
        DatabaseUtils.cursorRowToContentValues(cursor, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findLocalChanges(TempProviderSyncResult mergeResult, SyncableContentProvider temporaryInstanceFactory, Account account, SyncResult syncResult) {
        SyncableContentProvider clientDiffs = mergeResult.tempContentProvider;
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "generating client updates");
        }
        String[] accountSelectionArgs = new String[]{account.name, account.type};
        long numInsertsOrUpdates = 0L;
        Cursor localChangesCursor = this.mDb.query(this.mTable, null, SELECT_UNSYNCED, accountSelectionArgs, null, null, null);
        try {
            numInsertsOrUpdates = localChangesCursor.getCount();
            while (localChangesCursor.moveToNext()) {
                if (this.mIsMergeCancelled) {
                    Object var11_9 = null;
                    localChangesCursor.close();
                    return;
                }
                if (clientDiffs == null) {
                    clientDiffs = temporaryInstanceFactory.getTemporaryInstance();
                }
                this.mValues.clear();
                this.cursorRowToContentValues(localChangesCursor, this.mValues);
                this.mValues.remove("_id");
                DatabaseUtils.cursorLongToContentValues(localChangesCursor, "_id", this.mValues, "_sync_local_id");
                clientDiffs.insert(this.mTableURL, this.mValues);
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            localChangesCursor.close();
            throw throwable;
        }
        Object var11_10 = null;
        localChangesCursor.close();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "generating client deletions");
        }
        long numEntries = DatabaseUtils.queryNumEntries(this.mDb, this.mTable);
        long numDeletedEntries = 0L;
        if (this.mDeletedTable != null) {
            Cursor deletedCursor = this.mDb.query(this.mDeletedTable, syncIdAndVersionProjection, "_sync_account=? AND _sync_account_type=? AND _sync_id IS NOT NULL", accountSelectionArgs, null, null, this.mDeletedTable + "." + "_sync_id");
            try {
                numDeletedEntries = deletedCursor.getCount();
                while (deletedCursor.moveToNext()) {
                    if (this.mIsMergeCancelled) {
                        Object var16_16 = null;
                        deletedCursor.close();
                        return;
                    }
                    if (clientDiffs == null) {
                        clientDiffs = temporaryInstanceFactory.getTemporaryInstance();
                    }
                    this.mValues.clear();
                    DatabaseUtils.cursorRowToContentValues(deletedCursor, this.mValues);
                    clientDiffs.insert(this.mDeletedTableURL, this.mValues);
                }
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                deletedCursor.close();
                throw throwable;
            }
            Object var16_17 = null;
            deletedCursor.close();
            {
            }
        }
        if (clientDiffs != null) {
            mergeResult.tempContentProvider = clientDiffs;
        }
        syncResult.stats.numDeletes += numDeletedEntries;
        syncResult.stats.numUpdates += numInsertsOrUpdates;
        syncResult.stats.numEntries += numEntries;
    }

    static {
        mSyncMarkValues.put("_sync_mark", 1);
        TRACE = false;
        syncDirtyProjection = new String[]{"_sync_dirty", "_id", "_sync_id", "_sync_version"};
        syncIdAndVersionProjection = new String[]{"_sync_id", "_sync_version"};
    }
}

