/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.ActiveSyncInfo;
import android.content.ContentProviderClient;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.Context;
import android.content.Entity;
import android.content.EntityIterator;
import android.content.IContentProvider;
import android.content.IContentService;
import android.content.ISyncStatusObserver;
import android.content.OperationApplicationException;
import android.content.SyncAdapterType;
import android.content.SyncStatusInfo;
import android.content.SyncStatusObserver;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.CursorWrapper;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentResolver {
    @Deprecated
    public static final String SYNC_EXTRAS_ACCOUNT = "account";
    public static final String SYNC_EXTRAS_EXPEDITED = "expedited";
    @Deprecated
    public static final String SYNC_EXTRAS_FORCE = "force";
    public static final String SYNC_EXTRAS_MANUAL = "force";
    public static final String SYNC_EXTRAS_UPLOAD = "upload";
    public static final String SYNC_EXTRAS_OVERRIDE_TOO_MANY_DELETIONS = "deletions_override";
    public static final String SYNC_EXTRAS_DISCARD_LOCAL_DELETIONS = "discard_deletions";
    public static final String SYNC_EXTRAS_INITIALIZE = "initialize";
    public static final String SCHEME_CONTENT = "content";
    public static final String SCHEME_ANDROID_RESOURCE = "android.resource";
    public static final String SCHEME_FILE = "file";
    public static final String CURSOR_ITEM_BASE_TYPE = "vnd.android.cursor.item";
    public static final String CURSOR_DIR_BASE_TYPE = "vnd.android.cursor.dir";
    public static final int SYNC_ERROR_SYNC_ALREADY_IN_PROGRESS = 1;
    public static final int SYNC_ERROR_AUTHENTICATION = 2;
    public static final int SYNC_ERROR_IO = 3;
    public static final int SYNC_ERROR_PARSE = 4;
    public static final int SYNC_ERROR_CONFLICT = 5;
    public static final int SYNC_ERROR_TOO_MANY_DELETIONS = 6;
    public static final int SYNC_ERROR_TOO_MANY_RETRIES = 7;
    public static final int SYNC_ERROR_INTERNAL = 8;
    public static final int SYNC_OBSERVER_TYPE_SETTINGS = 1;
    public static final int SYNC_OBSERVER_TYPE_PENDING = 2;
    public static final int SYNC_OBSERVER_TYPE_ACTIVE = 4;
    public static final int SYNC_OBSERVER_TYPE_STATUS = 8;
    public static final int SYNC_OBSERVER_TYPE_ALL = Integer.MAX_VALUE;
    public static final String CONTENT_SERVICE_NAME = "content";
    public static IContentService sContentService;
    public final Context mContext;
    public static final String TAG = "ContentResolver";

    public ContentResolver(Context context) {
        this.mContext = context;
    }

    public abstract IContentProvider acquireProvider(Context var1, String var2);

    public abstract boolean releaseProvider(IContentProvider var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getType(Uri url) {
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            return null;
        }
        try {
            try {
                String string2 = provider.getType(url);
                Object var6_6 = null;
                this.releaseProvider(provider);
                return string2;
            }
            catch (RemoteException e) {
                String string3 = null;
                Object var6_7 = null;
                this.releaseProvider(provider);
                return string3;
            }
            catch (Exception e) {
                String string4 = null;
                Object var6_8 = null;
                this.releaseProvider(provider);
                return string4;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.releaseProvider(provider);
            throw throwable;
        }
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        IContentProvider provider = this.acquireProvider(uri);
        if (provider == null) {
            return null;
        }
        try {
            Cursor qCursor = provider.query(uri, projection, selection, selectionArgs, sortOrder);
            if (qCursor == null) {
                this.releaseProvider(provider);
                return null;
            }
            return new CursorWrapperInner(qCursor, provider);
        }
        catch (RemoteException e) {
            this.releaseProvider(provider);
            return null;
        }
        catch (RuntimeException e) {
            this.releaseProvider(provider);
            throw e;
        }
    }

    public EntityIterator queryEntities(Uri uri, String selection, String[] selectionArgs, String sortOrder) throws RemoteException {
        ContentProviderClient provider = this.acquireContentProviderClient(uri);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown URL " + uri);
        }
        try {
            EntityIterator entityIterator = provider.queryEntities(uri, selection, selectionArgs, sortOrder);
            return new EntityIteratorWrapper(entityIterator, provider);
        }
        catch (RuntimeException e) {
            provider.release();
            throw e;
        }
        catch (RemoteException e) {
            provider.release();
            throw e;
        }
    }

    public InputStream openInputStream(Uri uri) throws FileNotFoundException {
        String scheme = uri.getScheme();
        if (SCHEME_ANDROID_RESOURCE.equals(scheme)) {
            OpenResourceIdResult r = this.getResourceId(uri);
            try {
                InputStream stream = r.r.openRawResource(r.id);
                return stream;
            }
            catch (Resources.NotFoundException ex) {
                throw new FileNotFoundException("Resource does not exist: " + uri);
            }
        }
        if (SCHEME_FILE.equals(scheme)) {
            return new FileInputStream(uri.getPath());
        }
        AssetFileDescriptor fd = this.openAssetFileDescriptor(uri, "r");
        try {
            return fd != null ? fd.createInputStream() : null;
        }
        catch (IOException e) {
            throw new FileNotFoundException("Unable to create stream");
        }
    }

    public OutputStream openOutputStream(Uri uri) throws FileNotFoundException {
        return this.openOutputStream(uri, "w");
    }

    public OutputStream openOutputStream(Uri uri, String mode) throws FileNotFoundException {
        AssetFileDescriptor fd = this.openAssetFileDescriptor(uri, mode);
        try {
            return fd != null ? fd.createOutputStream() : null;
        }
        catch (IOException e) {
            throw new FileNotFoundException("Unable to create stream");
        }
    }

    public ParcelFileDescriptor openFileDescriptor(Uri uri, String mode) throws FileNotFoundException {
        AssetFileDescriptor afd = this.openAssetFileDescriptor(uri, mode);
        if (afd == null) {
            return null;
        }
        if (afd.getDeclaredLength() < 0L) {
            return afd.getParcelFileDescriptor();
        }
        try {
            afd.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        throw new FileNotFoundException("Not a whole file");
    }

    public AssetFileDescriptor openAssetFileDescriptor(Uri uri, String mode) throws FileNotFoundException {
        String scheme = uri.getScheme();
        if (SCHEME_ANDROID_RESOURCE.equals(scheme)) {
            if (!"r".equals(mode)) {
                throw new FileNotFoundException("Can't write resources: " + uri);
            }
            OpenResourceIdResult r = this.getResourceId(uri);
            try {
                return r.r.openRawResourceFd(r.id);
            }
            catch (Resources.NotFoundException ex) {
                throw new FileNotFoundException("Resource does not exist: " + uri);
            }
        }
        if (SCHEME_FILE.equals(scheme)) {
            ParcelFileDescriptor pfd = ParcelFileDescriptor.open(new File(uri.getPath()), ContentResolver.modeToMode(uri, mode));
            return new AssetFileDescriptor(pfd, 0L, -1L);
        }
        IContentProvider provider = this.acquireProvider(uri);
        if (provider == null) {
            throw new FileNotFoundException("No content provider: " + uri);
        }
        try {
            AssetFileDescriptor fd = provider.openAssetFile(uri, mode);
            if (fd == null) {
                this.releaseProvider(provider);
                return null;
            }
            ParcelFileDescriptorInner pfd = new ParcelFileDescriptorInner(fd.getParcelFileDescriptor(), provider);
            return new AssetFileDescriptor(pfd, fd.getStartOffset(), fd.getDeclaredLength());
        }
        catch (RemoteException e) {
            this.releaseProvider(provider);
            throw new FileNotFoundException("Dead content provider: " + uri);
        }
        catch (FileNotFoundException e) {
            this.releaseProvider(provider);
            throw e;
        }
        catch (RuntimeException e) {
            this.releaseProvider(provider);
            throw e;
        }
    }

    public OpenResourceIdResult getResourceId(Uri uri) throws FileNotFoundException {
        int id2;
        Resources r;
        String authority = uri.getAuthority();
        if (TextUtils.isEmpty(authority)) {
            throw new FileNotFoundException("No authority: " + uri);
        }
        try {
            r = this.mContext.getPackageManager().getResourcesForApplication(authority);
        }
        catch (PackageManager.NameNotFoundException ex) {
            throw new FileNotFoundException("No package found for authority: " + uri);
        }
        List<String> path = uri.getPathSegments();
        if (path == null) {
            throw new FileNotFoundException("No path: " + uri);
        }
        int len = path.size();
        if (len == 1) {
            try {
                id2 = Integer.parseInt(path.get(0));
            }
            catch (NumberFormatException e) {
                throw new FileNotFoundException("Single path segment is not a resource ID: " + uri);
            }
        } else if (len == 2) {
            id2 = r.getIdentifier(path.get(1), path.get(0), authority);
        } else {
            throw new FileNotFoundException("More than two path segments: " + uri);
        }
        if (id2 == 0) {
            throw new FileNotFoundException("No resource found for: " + uri);
        }
        OpenResourceIdResult res = new OpenResourceIdResult();
        res.r = r;
        res.id = id2;
        return res;
    }

    public static int modeToMode(Uri uri, String mode) throws FileNotFoundException {
        int modeBits;
        if ("r".equals(mode)) {
            modeBits = 0x10000000;
        } else if ("w".equals(mode) || "wt".equals(mode)) {
            modeBits = 0x2C000000;
        } else if ("wa".equals(mode)) {
            modeBits = 0x2A000000;
        } else if ("rw".equals(mode)) {
            modeBits = 0x38000000;
        } else if ("rwt".equals(mode)) {
            modeBits = 0x3C000000;
        } else {
            throw new FileNotFoundException("Bad mode for " + uri + ": " + mode);
        }
        return modeBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri insert(Uri url, ContentValues values) {
        Uri uri;
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown URL " + url);
        }
        try {
            uri = provider.insert(url, values);
            Object var7_6 = null;
            this.releaseProvider(provider);
        }
        catch (RemoteException e) {
            Uri uri2;
            try {
                uri2 = null;
                Object var7_7 = null;
                this.releaseProvider(provider);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.releaseProvider(provider);
                throw throwable;
            }
            return uri2;
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentProviderResult[] applyBatch(String authority, ArrayList<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        ContentProviderResult[] contentProviderResultArray;
        ContentProviderClient provider = this.acquireContentProviderClient(authority);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown authority " + authority);
        }
        try {
            contentProviderResultArray = provider.applyBatch(operations);
            Object var6_5 = null;
            provider.release();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            provider.release();
            throw throwable;
        }
        return contentProviderResultArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(Uri url, ContentValues[] values) {
        int n;
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown URL " + url);
        }
        try {
            n = provider.bulkInsert(url, values);
            Object var7_6 = null;
            this.releaseProvider(provider);
        }
        catch (RemoteException e) {
            int n2;
            try {
                n2 = 0;
                Object var7_7 = null;
                this.releaseProvider(provider);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.releaseProvider(provider);
                throw throwable;
            }
            return n2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Uri url, String where, String[] selectionArgs) {
        int n;
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown URL " + url);
        }
        try {
            n = provider.delete(url, where, selectionArgs);
            Object var8_7 = null;
            this.releaseProvider(provider);
        }
        catch (RemoteException e) {
            int n2;
            try {
                n2 = -1;
                Object var8_8 = null;
                this.releaseProvider(provider);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.releaseProvider(provider);
                throw throwable;
            }
            return n2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Uri uri, ContentValues values, String where, String[] selectionArgs) {
        int n;
        IContentProvider provider = this.acquireProvider(uri);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        try {
            n = provider.update(uri, values, where, selectionArgs);
            Object var9_8 = null;
            this.releaseProvider(provider);
        }
        catch (RemoteException e) {
            int n2;
            try {
                n2 = -1;
                Object var9_9 = null;
                this.releaseProvider(provider);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.releaseProvider(provider);
                throw throwable;
            }
            return n2;
        }
        return n;
    }

    public IContentProvider acquireProvider(Uri uri) {
        if (!"content".equals(uri.getScheme())) {
            return null;
        }
        String auth = uri.getAuthority();
        if (auth != null) {
            return this.acquireProvider(this.mContext, uri.getAuthority());
        }
        return null;
    }

    public IContentProvider acquireProvider(String name) {
        if (name == null) {
            return null;
        }
        return this.acquireProvider(this.mContext, name);
    }

    public ContentProviderClient acquireContentProviderClient(Uri uri) {
        IContentProvider provider = this.acquireProvider(uri);
        if (provider != null) {
            return new ContentProviderClient(this, provider);
        }
        return null;
    }

    public ContentProviderClient acquireContentProviderClient(String name) {
        IContentProvider provider = this.acquireProvider(name);
        if (provider != null) {
            return new ContentProviderClient(this, provider);
        }
        return null;
    }

    public void registerContentObserver(Uri uri, boolean notifyForDescendents, ContentObserver observer) {
        try {
            ContentResolver.getContentService().registerContentObserver(uri, notifyForDescendents, observer.getContentObserver());
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void unregisterContentObserver(ContentObserver observer) {
        try {
            IContentObserver contentObserver = observer.releaseContentObserver();
            if (contentObserver != null) {
                ContentResolver.getContentService().unregisterContentObserver(contentObserver);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyChange(Uri uri, ContentObserver observer) {
        this.notifyChange(uri, observer, true);
    }

    public void notifyChange(Uri uri, ContentObserver observer, boolean syncToNetwork) {
        try {
            ContentResolver.getContentService().notifyChange(uri, observer == null ? null : observer.getContentObserver(), observer != null && observer.deliverSelfNotifications(), syncToNetwork);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    @Deprecated
    public void startSync(Uri uri, Bundle extras) {
        Account account = null;
        if (extras != null) {
            String accountName = extras.getString(SYNC_EXTRAS_ACCOUNT);
            if (!TextUtils.isEmpty(accountName)) {
                account = new Account(accountName, "com.google");
            }
            extras.remove(SYNC_EXTRAS_ACCOUNT);
        }
        ContentResolver.requestSync(account, uri != null ? uri.getAuthority() : null, extras);
    }

    public static void requestSync(Account account, String authority, Bundle extras) {
        ContentResolver.validateSyncExtrasBundle(extras);
        try {
            ContentResolver.getContentService().requestSync(account, authority, extras);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static void validateSyncExtrasBundle(Bundle extras) {
        try {
            for (String key : extras.keySet()) {
                Object value = extras.get(key);
                if (value == null || value instanceof Long || value instanceof Integer || value instanceof Boolean || value instanceof Float || value instanceof Double || value instanceof String || value instanceof Account) continue;
                throw new IllegalArgumentException("unexpected value type: " + value.getClass().getName());
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException exc) {
            throw new IllegalArgumentException("error unparceling Bundle", exc);
        }
    }

    @Deprecated
    public void cancelSync(Uri uri) {
        ContentResolver.cancelSync(null, uri != null ? uri.getAuthority() : null);
    }

    public static void cancelSync(Account account, String authority) {
        try {
            ContentResolver.getContentService().cancelSync(account, authority);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static SyncAdapterType[] getSyncAdapterTypes() {
        try {
            return ContentResolver.getContentService().getSyncAdapterTypes();
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    public static boolean getSyncAutomatically(Account account, String authority) {
        try {
            return ContentResolver.getContentService().getSyncAutomatically(account, authority);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    public static void setSyncAutomatically(Account account, String authority, boolean sync) {
        try {
            ContentResolver.getContentService().setSyncAutomatically(account, authority, sync);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static int getIsSyncable(Account account, String authority) {
        try {
            return ContentResolver.getContentService().getIsSyncable(account, authority);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    public static void setIsSyncable(Account account, String authority, int syncable) {
        try {
            ContentResolver.getContentService().setIsSyncable(account, authority, syncable);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static boolean getMasterSyncAutomatically() {
        try {
            return ContentResolver.getContentService().getMasterSyncAutomatically();
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    public static void setMasterSyncAutomatically(boolean sync) {
        try {
            ContentResolver.getContentService().setMasterSyncAutomatically(sync);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static boolean isSyncActive(Account account, String authority) {
        try {
            return ContentResolver.getContentService().isSyncActive(account, authority);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    public static ActiveSyncInfo getActiveSync() {
        try {
            return ContentResolver.getContentService().getActiveSync();
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    public static SyncStatusInfo getSyncStatus(Account account, String authority) {
        try {
            return ContentResolver.getContentService().getSyncStatus(account, authority);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    public static boolean isSyncPending(Account account, String authority) {
        try {
            return ContentResolver.getContentService().isSyncPending(account, authority);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    public static Object addStatusChangeListener(int mask, final SyncStatusObserver callback) {
        try {
            ISyncStatusObserver.Stub observer = new ISyncStatusObserver.Stub(){

                public void onStatusChanged(int which) throws RemoteException {
                    callback.onStatusChanged(which);
                }
            };
            ContentResolver.getContentService().addStatusChangeListener(mask, observer);
            return observer;
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    public static void removeStatusChangeListener(Object handle) {
        try {
            ContentResolver.getContentService().removeStatusChangeListener((ISyncStatusObserver.Stub)handle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static IContentService getContentService() {
        if (sContentService != null) {
            return sContentService;
        }
        IBinder b = ServiceManager.getService("content");
        sContentService = IContentService.Stub.asInterface(b);
        return sContentService;
    }

    public class ParcelFileDescriptorInner
    extends ParcelFileDescriptor {
        public IContentProvider mContentProvider;
        public static final String TAG = "ParcelFileDescriptorInner";
        public boolean mReleaseProviderFlag;

        public ParcelFileDescriptorInner(ParcelFileDescriptor pfd, IContentProvider icp) {
            super(pfd);
            this.mReleaseProviderFlag = false;
            this.mContentProvider = icp;
        }

        public void close() throws IOException {
            if (!this.mReleaseProviderFlag) {
                super.close();
                ContentResolver.this.releaseProvider(this.mContentProvider);
                this.mReleaseProviderFlag = true;
            }
        }

        public void finalize() throws Throwable {
            if (!this.mReleaseProviderFlag) {
                this.close();
            }
        }
    }

    public class CursorWrapperInner
    extends CursorWrapper {
        public IContentProvider mContentProvider;
        public static final String TAG = "CursorWrapperInner";
        public boolean mCloseFlag;

        public CursorWrapperInner(Cursor cursor, IContentProvider icp) {
            super(cursor);
            this.mCloseFlag = false;
            this.mContentProvider = icp;
        }

        public void close() {
            super.close();
            ContentResolver.this.releaseProvider(this.mContentProvider);
            this.mCloseFlag = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finalize() throws Throwable {
            try {
                if (!this.mCloseFlag) {
                    ContentResolver.this.releaseProvider(this.mContentProvider);
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                super.finalize();
                throw throwable;
            }
            super.finalize();
        }
    }

    public class OpenResourceIdResult {
        public Resources r;
        public int id;
    }

    public class EntityIteratorWrapper
    implements EntityIterator {
        public final EntityIterator mInner;
        public final ContentProviderClient mClient;
        public volatile boolean mClientReleased;

        public EntityIteratorWrapper(EntityIterator inner, ContentProviderClient client) {
            this.mInner = inner;
            this.mClient = client;
            this.mClientReleased = false;
        }

        public boolean hasNext() throws RemoteException {
            if (this.mClientReleased) {
                throw new IllegalStateException("this iterator is already closed");
            }
            return this.mInner.hasNext();
        }

        public Entity next() throws RemoteException {
            if (this.mClientReleased) {
                throw new IllegalStateException("this iterator is already closed");
            }
            return this.mInner.next();
        }

        public void reset() throws RemoteException {
            if (this.mClientReleased) {
                throw new IllegalStateException("this iterator is already closed");
            }
            this.mInner.reset();
        }

        public void close() {
            this.mClient.release();
            this.mInner.close();
            this.mClientReleased = true;
        }

        public void finalize() throws Throwable {
            if (!this.mClientReleased) {
                this.mClient.release();
            }
            super.finalize();
        }
    }
}

