/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SyncAdapter;
import android.content.SyncContext;
import android.content.SyncResult;
import android.content.SyncStats;
import android.content.SyncableContentProvider;
import android.content.TempProviderSyncResult;
import android.database.SQLException;
import android.os.Bundle;
import android.os.Debug;
import android.os.NetStat;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.TimingLogger;
import java.io.IOException;

public abstract class TempProviderSyncAdapter
extends SyncAdapter {
    public static final String TAG = "Sync";
    public static final int MAX_GET_SERVER_DIFFS_LOOP_COUNT = 20;
    public static final int MAX_UPLOAD_CHANGES_LOOP_COUNT = 10;
    public static final int NUM_ALLOWED_SIMULTANEOUS_DELETIONS = 5;
    public static final long PERCENT_ALLOWED_SIMULTANEOUS_DELETIONS = 20L;
    public volatile SyncableContentProvider mProvider;
    public volatile SyncThread mSyncThread = null;
    public volatile boolean mProviderSyncStarted;
    public volatile boolean mAdapterSyncStarted;
    public Context mContext;

    public TempProviderSyncAdapter(SyncableContentProvider provider) {
        this.mProvider = provider;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public Context getContext() {
        return this.mContext;
    }

    public abstract void onSyncStarting(SyncContext var1, Account var2, boolean var3, SyncResult var4);

    public abstract void onSyncEnding(SyncContext var1, boolean var2);

    public abstract boolean isReadOnly();

    public abstract boolean getIsSyncable(Account var1) throws IOException, AuthenticatorException, OperationCanceledException;

    public abstract void getServerDiffs(SyncContext var1, SyncData var2, SyncableContentProvider var3, Bundle var4, Object var5, SyncResult var6);

    public abstract void sendClientDiffs(SyncContext var1, SyncableContentProvider var2, SyncableContentProvider var3, SyncResult var4, boolean var5);

    public SyncData readSyncData(SyncableContentProvider contentProvider) {
        return null;
    }

    public SyncData newSyncData() {
        return null;
    }

    public void writeSyncData(SyncData syncData, SyncableContentProvider contentProvider) {
    }

    public abstract void onSyncCanceled();

    public void initTempProvider(SyncableContentProvider cp) {
    }

    public Object createSyncInfo() {
        return null;
    }

    public abstract void onAccountsChanged(Account[] var1);

    public void logSyncDetails(long bytesSent, long bytesReceived, SyncResult result) {
        EventLog.writeEvent(2743, TAG, bytesSent, bytesReceived, "");
    }

    public void startSync(SyncContext syncContext, Account account, String authority, Bundle extras) {
        if (this.mSyncThread != null) {
            syncContext.onFinished(SyncResult.ALREADY_IN_PROGRESS);
            return;
        }
        this.mSyncThread = new SyncThread(syncContext, account, authority, extras);
        this.mSyncThread.start();
    }

    public void cancelSync() {
        if (this.mSyncThread != null) {
            this.mSyncThread.cancelSync();
        }
    }

    public boolean hasTooManyDeletions(SyncStats stats) {
        long numEntries = stats.numEntries;
        long numDeletedEntries = stats.numDeletes;
        long percentDeleted = numDeletedEntries == 0L ? 0L : 100L * numDeletedEntries / (numEntries + numDeletedEntries);
        boolean tooManyDeletions = numDeletedEntries > 5L && percentDeleted > 20L;
        return tooManyDeletions;
    }

    public class SyncThread
    extends Thread {
        public final Account mAccount;
        public final String mAuthority;
        public final Bundle mExtras;
        public final SyncContext mSyncContext;
        public volatile boolean mIsCanceled;
        public long mInitialTxBytes;
        public long mInitialRxBytes;
        public final SyncResult mResult;

        public SyncThread(SyncContext syncContext, Account account, String authority, Bundle extras) {
            super("SyncThread");
            this.mIsCanceled = false;
            this.mAccount = account;
            this.mAuthority = authority;
            this.mExtras = extras;
            this.mSyncContext = syncContext;
            this.mResult = new SyncResult();
        }

        public void cancelSync() {
            this.mIsCanceled = true;
            if (TempProviderSyncAdapter.this.mAdapterSyncStarted) {
                TempProviderSyncAdapter.this.onSyncCanceled();
            }
            if (TempProviderSyncAdapter.this.mProviderSyncStarted) {
                TempProviderSyncAdapter.this.mProvider.onSyncCanceled();
            }
            int uid = Process.myUid();
            TempProviderSyncAdapter.this.logSyncDetails(NetStat.getUidTxBytes(uid) - this.mInitialTxBytes, NetStat.getUidRxBytes(uid) - this.mInitialRxBytes, this.mResult);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Process.setThreadPriority(Process.myTid(), 10);
            int uid = Process.myUid();
            this.mInitialTxBytes = NetStat.getUidTxBytes(uid);
            this.mInitialRxBytes = NetStat.getUidRxBytes(uid);
            try {
                try {
                    this.sync(this.mSyncContext, this.mAccount, this.mAuthority, this.mExtras);
                }
                catch (SQLException e) {
                    Log.e(TempProviderSyncAdapter.TAG, "Sync failed", e);
                    this.mResult.databaseError = true;
                    Object var4_3 = null;
                    TempProviderSyncAdapter.this.mSyncThread = null;
                    if (this.mIsCanceled) return;
                    TempProviderSyncAdapter.this.logSyncDetails(NetStat.getUidTxBytes(uid) - this.mInitialTxBytes, NetStat.getUidRxBytes(uid) - this.mInitialRxBytes, this.mResult);
                    this.mSyncContext.onFinished(this.mResult);
                    return;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                TempProviderSyncAdapter.this.mSyncThread = null;
                if (this.mIsCanceled) throw throwable;
                TempProviderSyncAdapter.this.logSyncDetails(NetStat.getUidTxBytes(uid) - this.mInitialTxBytes, NetStat.getUidRxBytes(uid) - this.mInitialRxBytes, this.mResult);
                this.mSyncContext.onFinished(this.mResult);
                throw throwable;
            }
            TempProviderSyncAdapter.this.mSyncThread = null;
            if (this.mIsCanceled) return;
            TempProviderSyncAdapter.this.logSyncDetails(NetStat.getUidTxBytes(uid) - this.mInitialTxBytes, NetStat.getUidRxBytes(uid) - this.mInitialRxBytes, this.mResult);
            this.mSyncContext.onFinished(this.mResult);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void sync(SyncContext syncContext, Account account, String authority, Bundle extras) {
            String message;
            block25: {
                block23: {
                    block22: {
                        this.mIsCanceled = false;
                        TempProviderSyncAdapter.this.mProviderSyncStarted = false;
                        TempProviderSyncAdapter.this.mAdapterSyncStarted = false;
                        message = null;
                        int isSyncable = ContentResolver.getIsSyncable(account, authority);
                        if (isSyncable < 0) {
                            try {
                                isSyncable = TempProviderSyncAdapter.this.getIsSyncable(account) ? 1 : 0;
                                ContentResolver.setIsSyncable(account, authority, isSyncable);
                            }
                            catch (IOException e) {
                                ++this.mResult.stats.numIoExceptions;
                            }
                            catch (AuthenticatorException e) {
                                ++this.mResult.stats.numParseExceptions;
                            }
                            catch (OperationCanceledException e) {
                                // empty catch block
                            }
                        }
                        if (extras.getBoolean("initialize", false)) {
                            return;
                        }
                        if (isSyncable <= 0) {
                            return;
                        }
                        boolean manualSync = extras.getBoolean("force", false);
                        try {
                            block24: {
                                TempProviderSyncAdapter.this.mProvider.onSyncStart(syncContext, account);
                                TempProviderSyncAdapter.this.mProviderSyncStarted = true;
                                TempProviderSyncAdapter.this.onSyncStarting(syncContext, account, manualSync, this.mResult);
                                if (this.mResult.hasError()) {
                                    message = "SyncAdapter failed while trying to start sync";
                                    Object var13_12 = null;
                                    break block22;
                                }
                                TempProviderSyncAdapter.this.mAdapterSyncStarted = true;
                                if (this.mIsCanceled) {
                                    break block23;
                                }
                                String syncTracingEnabledValue = SystemProperties.get("SyncTracing");
                                boolean syncTracingEnabled = !TextUtils.isEmpty(syncTracingEnabledValue);
                                try {
                                    if (syncTracingEnabled) {
                                        System.gc();
                                        System.gc();
                                        Debug.startMethodTracing("synctrace." + System.currentTimeMillis());
                                    }
                                    this.runSyncLoop(syncContext, account, extras);
                                    Object var11_18 = null;
                                    if (!syncTracingEnabled) break block24;
                                }
                                catch (Throwable throwable) {
                                    Object var11_19 = null;
                                    if (!syncTracingEnabled) throw throwable;
                                    Debug.stopMethodTracing();
                                    throw throwable;
                                }
                                Debug.stopMethodTracing();
                            }
                            TempProviderSyncAdapter.this.onSyncEnding(syncContext, !this.mResult.hasError());
                            TempProviderSyncAdapter.this.mAdapterSyncStarted = false;
                            TempProviderSyncAdapter.this.mProvider.onSyncStop(syncContext, true);
                            TempProviderSyncAdapter.this.mProviderSyncStarted = false;
                            break block25;
                        }
                        catch (Throwable throwable) {
                            Object var13_15 = null;
                            if (TempProviderSyncAdapter.this.mAdapterSyncStarted) {
                                TempProviderSyncAdapter.this.mAdapterSyncStarted = false;
                                TempProviderSyncAdapter.this.onSyncEnding(syncContext, false);
                            }
                            if (TempProviderSyncAdapter.this.mProviderSyncStarted) {
                                TempProviderSyncAdapter.this.mProviderSyncStarted = false;
                                TempProviderSyncAdapter.this.mProvider.onSyncStop(syncContext, false);
                            }
                            if (this.mIsCanceled) throw throwable;
                            if (message == null) throw throwable;
                            syncContext.setStatusText(message);
                            throw throwable;
                        }
                    }
                    if (TempProviderSyncAdapter.this.mAdapterSyncStarted) {
                        TempProviderSyncAdapter.this.mAdapterSyncStarted = false;
                        TempProviderSyncAdapter.this.onSyncEnding(syncContext, false);
                    }
                    if (TempProviderSyncAdapter.this.mProviderSyncStarted) {
                        TempProviderSyncAdapter.this.mProviderSyncStarted = false;
                        TempProviderSyncAdapter.this.mProvider.onSyncStop(syncContext, false);
                    }
                    if (this.mIsCanceled) return;
                    if (message == null) return;
                    syncContext.setStatusText(message);
                    return;
                }
                Object var13_13 = null;
                if (TempProviderSyncAdapter.this.mAdapterSyncStarted) {
                    TempProviderSyncAdapter.this.mAdapterSyncStarted = false;
                    TempProviderSyncAdapter.this.onSyncEnding(syncContext, false);
                }
                if (TempProviderSyncAdapter.this.mProviderSyncStarted) {
                    TempProviderSyncAdapter.this.mProviderSyncStarted = false;
                    TempProviderSyncAdapter.this.mProvider.onSyncStop(syncContext, false);
                }
                if (this.mIsCanceled) return;
                if (message == null) return;
                syncContext.setStatusText(message);
                return;
            }
            Object var13_14 = null;
            if (TempProviderSyncAdapter.this.mAdapterSyncStarted) {
                TempProviderSyncAdapter.this.mAdapterSyncStarted = false;
                TempProviderSyncAdapter.this.onSyncEnding(syncContext, false);
            }
            if (TempProviderSyncAdapter.this.mProviderSyncStarted) {
                TempProviderSyncAdapter.this.mProviderSyncStarted = false;
                TempProviderSyncAdapter.this.mProvider.onSyncStop(syncContext, false);
            }
            if (this.mIsCanceled) return;
            if (message == null) return;
            syncContext.setStatusText(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void runSyncLoop(SyncContext syncContext, Account account, Bundle extras) {
            TempProviderSyncResult result;
            SyncableContentProvider serverDiffs;
            boolean discardLocalDeletions;
            TimingLogger syncTimer;
            block50: {
                block49: {
                    block48: {
                        block47: {
                            syncTimer = new TimingLogger("SyncProfiling", "sync");
                            syncTimer.addSplit("start");
                            int loopCount = 0;
                            boolean tooManyGetServerDiffsAttempts = false;
                            boolean overrideTooManyDeletions = extras.getBoolean("deletions_override", false);
                            discardLocalDeletions = extras.getBoolean("discard_deletions", false);
                            boolean uploadOnly = extras.getBoolean("upload", false);
                            serverDiffs = null;
                            result = new TempProviderSyncResult();
                            try {
                                if (!uploadOnly) {
                                    while (!this.mIsCanceled) {
                                        if (loopCount++ == 20) {
                                            Log.e(TempProviderSyncAdapter.TAG, "runSyncLoop: Hit max loop count while getting server diffs " + this.getClass().getName());
                                            tooManyGetServerDiffsAttempts = true;
                                            break;
                                        }
                                        if (serverDiffs != null) {
                                            serverDiffs.close();
                                        }
                                        serverDiffs = TempProviderSyncAdapter.this.mProvider.getTemporaryInstance();
                                        TempProviderSyncAdapter.this.initTempProvider(serverDiffs);
                                        Object syncInfo = TempProviderSyncAdapter.this.createSyncInfo();
                                        SyncData syncData = TempProviderSyncAdapter.this.readSyncData(serverDiffs);
                                        if (syncData == null) {
                                            TempProviderSyncAdapter.this.mProvider.wipeAccount(account);
                                            syncData = TempProviderSyncAdapter.this.newSyncData();
                                        }
                                        this.mResult.clear();
                                        if (Log.isLoggable(TempProviderSyncAdapter.TAG, 2)) {
                                            Log.v(TempProviderSyncAdapter.TAG, "runSyncLoop: running getServerDiffs using syncData " + syncData.toString());
                                        }
                                        TempProviderSyncAdapter.this.getServerDiffs(syncContext, syncData, serverDiffs, extras, syncInfo, this.mResult);
                                        if (this.mIsCanceled) {
                                            Object var21_16 = null;
                                            if (discardLocalDeletions) {
                                                this.mResult.fullSyncRequested = true;
                                            }
                                            if (serverDiffs != null) {
                                                serverDiffs.close();
                                            }
                                            if (result.tempContentProvider != null) {
                                                result.tempContentProvider.close();
                                            }
                                            syncTimer.addSplit("stop");
                                            syncTimer.dumpToLog();
                                            return;
                                        }
                                        if (Log.isLoggable(TempProviderSyncAdapter.TAG, 2)) {
                                            Log.v(TempProviderSyncAdapter.TAG, "runSyncLoop: result: " + this.mResult);
                                        }
                                        if (this.mResult.hasError()) {
                                            break block47;
                                        }
                                        if (this.mResult.partialSyncUnavailable) {
                                            Log.d(TempProviderSyncAdapter.TAG, "partialSyncUnavailable is set, setting ignoreSyncData and retrying");
                                            TempProviderSyncAdapter.this.mProvider.wipeAccount(account);
                                            continue;
                                        }
                                        TempProviderSyncAdapter.this.writeSyncData(syncData, serverDiffs);
                                        if (Log.isLoggable(TempProviderSyncAdapter.TAG, 2)) {
                                            Log.v(TempProviderSyncAdapter.TAG, "runSyncLoop: running merge");
                                        }
                                        TempProviderSyncAdapter.this.mProvider.merge(syncContext, serverDiffs, null, this.mResult);
                                        if (this.mIsCanceled) {
                                            break block48;
                                        }
                                        if (Log.isLoggable(TempProviderSyncAdapter.TAG, 2)) {
                                            Log.v(TempProviderSyncAdapter.TAG, "runSyncLoop: result: " + this.mResult);
                                        }
                                        if (!this.mResult.moreRecordsToGet) {
                                            if (!Log.isLoggable(TempProviderSyncAdapter.TAG, 2)) break;
                                            Log.v(TempProviderSyncAdapter.TAG, "runSyncLoop: fetched all data, moving on");
                                            break;
                                        }
                                        if (!Log.isLoggable(TempProviderSyncAdapter.TAG, 2)) continue;
                                        Log.v(TempProviderSyncAdapter.TAG, "runSyncLoop: more data to fetch, looping");
                                    }
                                }
                                loopCount = 0;
                                boolean readOnly = TempProviderSyncAdapter.this.isReadOnly();
                                long previousNumModifications = 0L;
                                if (serverDiffs != null) {
                                    serverDiffs.close();
                                    serverDiffs = null;
                                }
                                if (discardLocalDeletions) {
                                    serverDiffs = TempProviderSyncAdapter.this.mProvider.getTemporaryInstance();
                                    TempProviderSyncAdapter.this.initTempProvider(serverDiffs);
                                    TempProviderSyncAdapter.this.writeSyncData(null, serverDiffs);
                                }
                                while (!this.mIsCanceled) {
                                    SyncableContentProvider clientDiffs;
                                    if (result.tempContentProvider != null) {
                                        result.tempContentProvider.close();
                                        result.tempContentProvider = null;
                                    }
                                    this.mResult.clear();
                                    TempProviderSyncAdapter.this.mProvider.merge(syncContext, serverDiffs, readOnly ? null : result, this.mResult);
                                    if (this.mIsCanceled) {
                                        break block49;
                                    }
                                    if (Log.isLoggable(TempProviderSyncAdapter.TAG, 2)) {
                                        Log.v(TempProviderSyncAdapter.TAG, "runSyncLoop: result: " + this.mResult);
                                    }
                                    SyncableContentProvider syncableContentProvider = clientDiffs = readOnly ? null : result.tempContentProvider;
                                    if (clientDiffs == null) break;
                                    long numModifications = this.mResult.stats.numUpdates + this.mResult.stats.numDeletes + this.mResult.stats.numInserts;
                                    if (numModifications < previousNumModifications) {
                                        loopCount = 0;
                                    }
                                    previousNumModifications = numModifications;
                                    if (loopCount++ >= 10) {
                                        Log.e(TempProviderSyncAdapter.TAG, "runSyncLoop: Hit max loop count while syncing " + this.getClass().getName());
                                        this.mResult.tooManyRetries = true;
                                        break;
                                    }
                                    if (!overrideTooManyDeletions && !discardLocalDeletions && TempProviderSyncAdapter.this.hasTooManyDeletions(this.mResult.stats)) {
                                        Log.d(TempProviderSyncAdapter.TAG, "runSyncLoop: Too many deletions were found in provider " + this.getClass().getName() + ", not doing any more updates");
                                        long numDeletes = this.mResult.stats.numDeletes;
                                        this.mResult.stats.clear();
                                        this.mResult.tooManyDeletions = true;
                                        this.mResult.stats.numDeletes = numDeletes;
                                        break;
                                    }
                                    if (serverDiffs != null) {
                                        serverDiffs.close();
                                    }
                                    serverDiffs = clientDiffs.getTemporaryInstance();
                                    TempProviderSyncAdapter.this.initTempProvider(serverDiffs);
                                    this.mResult.clear();
                                    TempProviderSyncAdapter.this.sendClientDiffs(syncContext, clientDiffs, serverDiffs, this.mResult, discardLocalDeletions);
                                    if (Log.isLoggable(TempProviderSyncAdapter.TAG, 2)) {
                                        Log.v(TempProviderSyncAdapter.TAG, "runSyncLoop: result: " + this.mResult);
                                    }
                                    if (!this.mResult.madeSomeProgress()) {
                                        if (!Log.isLoggable(TempProviderSyncAdapter.TAG, 2)) break;
                                        Log.v(TempProviderSyncAdapter.TAG, "runSyncLoop: No data from client diffs merge");
                                        break;
                                    }
                                    if (!Log.isLoggable(TempProviderSyncAdapter.TAG, 2)) continue;
                                    Log.v(TempProviderSyncAdapter.TAG, "runSyncLoop: made some progress, looping");
                                }
                                this.mResult.tooManyRetries |= tooManyGetServerDiffsAttempts;
                                if (Log.isLoggable(TempProviderSyncAdapter.TAG, 2)) {
                                    Log.v(TempProviderSyncAdapter.TAG, "runSyncLoop: final result: " + this.mResult);
                                }
                                break block50;
                            }
                            catch (Throwable throwable) {
                                Object var21_21 = null;
                                if (discardLocalDeletions) {
                                    this.mResult.fullSyncRequested = true;
                                }
                                if (serverDiffs != null) {
                                    serverDiffs.close();
                                }
                                if (result.tempContentProvider != null) {
                                    result.tempContentProvider.close();
                                }
                                syncTimer.addSplit("stop");
                                syncTimer.dumpToLog();
                                throw throwable;
                            }
                        }
                        Object var21_17 = null;
                        if (discardLocalDeletions) {
                            this.mResult.fullSyncRequested = true;
                        }
                        if (serverDiffs != null) {
                            serverDiffs.close();
                        }
                        if (result.tempContentProvider != null) {
                            result.tempContentProvider.close();
                        }
                        syncTimer.addSplit("stop");
                        syncTimer.dumpToLog();
                        return;
                    }
                    Object var21_18 = null;
                    if (discardLocalDeletions) {
                        this.mResult.fullSyncRequested = true;
                    }
                    if (serverDiffs != null) {
                        serverDiffs.close();
                    }
                    if (result.tempContentProvider != null) {
                        result.tempContentProvider.close();
                    }
                    syncTimer.addSplit("stop");
                    syncTimer.dumpToLog();
                    return;
                }
                Object var21_19 = null;
                if (discardLocalDeletions) {
                    this.mResult.fullSyncRequested = true;
                }
                if (serverDiffs != null) {
                    serverDiffs.close();
                }
                if (result.tempContentProvider != null) {
                    result.tempContentProvider.close();
                }
                syncTimer.addSplit("stop");
                syncTimer.dumpToLog();
                return;
            }
            Object var21_20 = null;
            if (discardLocalDeletions) {
                this.mResult.fullSyncRequested = true;
            }
            if (serverDiffs != null) {
                serverDiffs.close();
            }
            if (result.tempContentProvider != null) {
                result.tempContentProvider.close();
            }
            syncTimer.addSplit("stop");
            syncTimer.dumpToLog();
        }
    }

    public static abstract class SyncData
    implements Parcelable {
    }
}

