/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.Log;

public abstract class SQLiteOpenHelper {
    public static final String TAG = SQLiteOpenHelper.class.getSimpleName();
    public final Context mContext;
    public final String mName;
    public final SQLiteDatabase.CursorFactory mFactory;
    public final int mNewVersion;
    public SQLiteDatabase mDatabase = null;
    public boolean mIsInitializing = false;

    public SQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        if (version < 1) {
            throw new IllegalArgumentException("Version must be >= 1, was " + version);
        }
        this.mContext = context;
        this.mName = name;
        this.mFactory = factory;
        this.mNewVersion = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SQLiteDatabase getWritableDatabase() {
        SQLiteDatabase sQLiteDatabase;
        block22: {
            SQLiteDatabase db;
            block17: {
                block18: {
                    if (this.mDatabase != null && this.mDatabase.isOpen() && !this.mDatabase.isReadOnly()) {
                        return this.mDatabase;
                    }
                    if (this.mIsInitializing) {
                        throw new IllegalStateException("getWritableDatabase called recursively");
                    }
                    boolean success = false;
                    db = null;
                    if (this.mDatabase != null) {
                        this.mDatabase.lock();
                    }
                    try {
                        this.mIsInitializing = true;
                        db = this.mName == null ? SQLiteDatabase.create(null) : this.mContext.openOrCreateDatabase(this.mName, 0, this.mFactory);
                        int version = db.getVersion();
                        if (version != this.mNewVersion) {
                            db.beginTransaction();
                            try {
                                if (version == 0) {
                                    this.onCreate(db);
                                } else {
                                    this.onUpgrade(db, version, this.mNewVersion);
                                }
                                db.setVersion(this.mNewVersion);
                                db.setTransactionSuccessful();
                                Object var5_4 = null;
                                db.endTransaction();
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                db.endTransaction();
                                throw throwable;
                            }
                        }
                        this.onOpen(db);
                        success = true;
                        sQLiteDatabase = db;
                        Object var7_8 = null;
                        this.mIsInitializing = false;
                        if (!success) break block17;
                        if (this.mDatabase == null) break block18;
                    }
                    catch (Throwable throwable) {
                        block21: {
                            block20: {
                                Object var7_9 = null;
                                this.mIsInitializing = false;
                                if (!success) break block20;
                                if (this.mDatabase != null) {
                                    try {
                                        this.mDatabase.close();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    this.mDatabase.unlock();
                                }
                                this.mDatabase = db;
                                break block21;
                            }
                            if (this.mDatabase != null) {
                                this.mDatabase.unlock();
                            }
                            if (db == null) break block21;
                            db.close();
                        }
                        throw throwable;
                    }
                    try {
                        this.mDatabase.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.mDatabase.unlock();
                }
                this.mDatabase = db;
                break block22;
            }
            if (this.mDatabase != null) {
                this.mDatabase.unlock();
            }
            if (db != null) {
                db.close();
            }
        }
        return sQLiteDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SQLiteDatabase getReadableDatabase() {
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            return this.mDatabase;
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getReadableDatabase called recursively");
        }
        try {
            return this.getWritableDatabase();
        }
        catch (SQLiteException e) {
            if (this.mName == null) {
                throw e;
            }
            Log.e(TAG, "Couldn't open " + this.mName + " for writing (will try read-only):", e);
            SQLiteDatabase db = null;
            try {
                this.mIsInitializing = true;
                String path = this.mContext.getDatabasePath(this.mName).getPath();
                db = SQLiteDatabase.openDatabase(path, this.mFactory, 1);
                if (db.getVersion() != this.mNewVersion) {
                    throw new SQLiteException("Can't upgrade read-only database from version " + db.getVersion() + " to " + this.mNewVersion + ": " + path);
                }
                this.onOpen(db);
                Log.w(TAG, "Opened " + this.mName + " in read-only mode");
                SQLiteDatabase sQLiteDatabase = this.mDatabase = db;
                Object var5_5 = null;
                this.mIsInitializing = false;
                if (db != null && db != this.mDatabase) {
                    db.close();
                }
                return sQLiteDatabase;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var5_6 = null;
                    this.mIsInitializing = false;
                    if (db == null || db == this.mDatabase) break block9;
                    db.close();
                }
                throw throwable;
            }
        }
    }

    public synchronized void close() {
        if (this.mIsInitializing) {
            throw new IllegalStateException("Closed during initialization");
        }
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            this.mDatabase.close();
            this.mDatabase = null;
        }
    }

    public abstract void onCreate(SQLiteDatabase var1);

    public abstract void onUpgrade(SQLiteDatabase var1, int var2, int var3);

    public void onOpen(SQLiteDatabase db) {
    }
}

