/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDebug;
import android.database.sqlite.SQLiteProgram;
import android.os.SystemClock;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;

public class SQLiteStatement
extends SQLiteProgram {
    public static final String TAG = "SQLiteStatement";
    public final String mSql;

    public SQLiteStatement(SQLiteDatabase db, String sql) {
        super(db, sql);
        this.mSql = SQLiteDebug.DEBUG_SQL_STATEMENTS ? sql : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.mDatabase.lock();
        boolean logStats = this.mDatabase.mLogStats;
        long startTime = logStats ? SystemClock.elapsedRealtime() : 0L;
        this.acquireReference();
        try {
            if (SQLiteDebug.DEBUG_SQL_STATEMENTS) {
                Log.v(TAG, "execute() for [" + this.mSql + "]");
            }
            this.native_execute();
            if (logStats) {
                this.mDatabase.logTimeStat(false, startTime, SystemClock.elapsedRealtime());
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.releaseReference();
            this.mDatabase.unlock();
            throw throwable;
        }
        this.releaseReference();
        this.mDatabase.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeInsert() {
        long l;
        this.mDatabase.lock();
        boolean logStats = this.mDatabase.mLogStats;
        long startTime = logStats ? SystemClock.elapsedRealtime() : 0L;
        this.acquireReference();
        try {
            if (SQLiteDebug.DEBUG_SQL_STATEMENTS) {
                Log.v(TAG, "executeInsert() for [" + this.mSql + "]");
            }
            this.native_execute();
            if (logStats) {
                this.mDatabase.logTimeStat(false, startTime, SystemClock.elapsedRealtime());
            }
            l = this.mDatabase.lastInsertRow();
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.releaseReference();
            this.mDatabase.unlock();
            throw throwable;
        }
        this.releaseReference();
        this.mDatabase.unlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long simpleQueryForLong() {
        long l;
        this.mDatabase.lock();
        boolean logStats = this.mDatabase.mLogStats;
        long startTime = logStats ? SystemClock.elapsedRealtime() : 0L;
        this.acquireReference();
        try {
            if (SQLiteDebug.DEBUG_SQL_STATEMENTS) {
                Log.v(TAG, "simpleQueryForLong() for [" + this.mSql + "]");
            }
            long retValue = this.native_1x1_long();
            if (logStats) {
                this.mDatabase.logTimeStat(false, startTime, SystemClock.elapsedRealtime());
            }
            l = retValue;
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            this.releaseReference();
            this.mDatabase.unlock();
            throw throwable;
        }
        this.releaseReference();
        this.mDatabase.unlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String simpleQueryForString() {
        String string2;
        this.mDatabase.lock();
        boolean logStats = this.mDatabase.mLogStats;
        long startTime = logStats ? SystemClock.elapsedRealtime() : 0L;
        this.acquireReference();
        try {
            if (SQLiteDebug.DEBUG_SQL_STATEMENTS) {
                Log.v(TAG, "simpleQueryForString() for [" + this.mSql + "]");
            }
            String retValue = this.native_1x1_string();
            if (logStats) {
                this.mDatabase.logTimeStat(false, startTime, SystemClock.elapsedRealtime());
            }
            string2 = retValue;
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.releaseReference();
            this.mDatabase.unlock();
            throw throwable;
        }
        this.releaseReference();
        this.mDatabase.unlock();
        return string2;
    }

    public void native_execute() {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteStatement#native_execute()V", true, this);
    }

    public long native_1x1_long() {
        return OverrideMethod.invokeL("android.database.sqlite.SQLiteStatement#native_1x1_long()J", true, this);
    }

    public String native_1x1_string() {
        return (String)OverrideMethod.invokeA("android.database.sqlite.SQLiteStatement#native_1x1_string()Ljava/lang/String;", true, this);
    }
}

