/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.os.Debug;
import android.util.Log;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleProfiling
extends ChunkHandler {
    public static final int CHUNK_MPRS = DdmHandleProfiling.type("MPRS");
    public static final int CHUNK_MPRE = DdmHandleProfiling.type("MPRE");
    public static final int CHUNK_MPRQ = DdmHandleProfiling.type("MPRQ");
    public static DdmHandleProfiling mInstance = new DdmHandleProfiling();

    public static void register() {
        DdmServer.registerHandler(CHUNK_MPRS, mInstance);
        DdmServer.registerHandler(CHUNK_MPRE, mInstance);
        DdmServer.registerHandler(CHUNK_MPRQ, mInstance);
    }

    public void connected() {
    }

    public void disconnected() {
    }

    public Chunk handleChunk(Chunk request) {
        int type = request.type;
        if (type == CHUNK_MPRS) {
            return this.handleMPRS(request);
        }
        if (type == CHUNK_MPRE) {
            return this.handleMPRE(request);
        }
        if (type == CHUNK_MPRQ) {
            return this.handleMPRQ(request);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name(type));
    }

    public Chunk handleMPRS(Chunk request) {
        ByteBuffer in = DdmHandleProfiling.wrapChunk(request);
        int bufferSize = in.getInt();
        int flags = in.getInt();
        int len = in.getInt();
        String fileName = DdmHandleProfiling.getString(in, len);
        try {
            Debug.startMethodTracing(fileName, bufferSize, flags);
            return null;
        }
        catch (RuntimeException re) {
            return DdmHandleProfiling.createFailChunk(1, re.getMessage());
        }
    }

    public Chunk handleMPRE(Chunk request) {
        byte result;
        try {
            Debug.stopMethodTracing();
            result = 0;
        }
        catch (RuntimeException re) {
            Log.w("ddm-heap", "Method profiling end failed: " + re.getMessage());
            result = 1;
        }
        byte[] reply = new byte[]{result};
        return new Chunk(CHUNK_MPRE, reply, 0, reply.length);
    }

    public Chunk handleMPRQ(Chunk request) {
        boolean result = Debug.isMethodTracingActive();
        byte[] reply = new byte[]{(byte)(result ? 1 : 0)};
        return new Chunk(CHUNK_MPRQ, reply, 0, reply.length);
    }
}

