/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.Gesture;
import android.gesture.GesturePoint;
import android.gesture.GestureStroke;
import android.gesture.OrientedBoundingBox;
import android.graphics.RectF;
import android.util.Log;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GestureUtilities {
    public static final int TEMPORAL_SAMPLING_RATE = 16;

    public static void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                Log.e("Gestures", "Could not close stream", e);
            }
        }
    }

    public static float[] spatialSampling(Gesture gesture, int sampleMatrixDimension) {
        float targetPatchSize = sampleMatrixDimension - 1;
        float[] sample = new float[sampleMatrixDimension * sampleMatrixDimension];
        Arrays.fill(sample, 0.0f);
        RectF rect = gesture.getBoundingBox();
        float sx = targetPatchSize / rect.width();
        float sy = targetPatchSize / rect.height();
        float scale = sx < sy ? sx : sy;
        float preDx = -rect.centerX();
        float preDy = -rect.centerY();
        float postDx = targetPatchSize / 2.0f;
        float postDy = targetPatchSize / 2.0f;
        ArrayList<GestureStroke> strokes = gesture.getStrokes();
        int count = strokes.size();
        for (int index = 0; index < count; ++index) {
            GestureStroke stroke = strokes.get(index);
            float[] strokepoints = stroke.points;
            int size = strokepoints.length;
            float[] pts = new float[size];
            for (int i = 0; i < size; i += 2) {
                pts[i] = (strokepoints[i] + preDx) * scale + postDx;
                pts[i + 1] = (strokepoints[i + 1] + preDy) * scale + postDy;
            }
            float segmentEndX = -1.0f;
            float segmentEndY = -1.0f;
            for (int i = 0; i < size; i += 2) {
                float segmentStartY;
                float segmentStartX = pts[i] < 0.0f ? 0.0f : pts[i];
                float f = segmentStartY = pts[i + 1] < 0.0f ? 0.0f : pts[i + 1];
                if (segmentStartX > targetPatchSize) {
                    segmentStartX = targetPatchSize;
                }
                if (segmentStartY > targetPatchSize) {
                    segmentStartY = targetPatchSize;
                }
                GestureUtilities.plot(segmentStartX, segmentStartY, sample, sampleMatrixDimension);
                if (segmentEndX != -1.0f) {
                    float invertSlope;
                    float ypos;
                    float xpos;
                    float slope;
                    if (segmentEndX > segmentStartX) {
                        slope = (segmentEndY - segmentStartY) / (segmentEndX - segmentStartX);
                        for (xpos = (float)Math.ceil(segmentStartX); xpos < segmentEndX; xpos += 1.0f) {
                            ypos = slope * (xpos - segmentStartX) + segmentStartY;
                            GestureUtilities.plot(xpos, ypos, sample, sampleMatrixDimension);
                        }
                    } else if (segmentEndX < segmentStartX) {
                        slope = (segmentEndY - segmentStartY) / (segmentEndX - segmentStartX);
                        for (xpos = (float)Math.ceil(segmentEndX); xpos < segmentStartX; xpos += 1.0f) {
                            ypos = slope * (xpos - segmentStartX) + segmentStartY;
                            GestureUtilities.plot(xpos, ypos, sample, sampleMatrixDimension);
                        }
                    }
                    if (segmentEndY > segmentStartY) {
                        invertSlope = (segmentEndX - segmentStartX) / (segmentEndY - segmentStartY);
                        for (ypos = (float)Math.ceil(segmentStartY); ypos < segmentEndY; ypos += 1.0f) {
                            xpos = invertSlope * (ypos - segmentStartY) + segmentStartX;
                            GestureUtilities.plot(xpos, ypos, sample, sampleMatrixDimension);
                        }
                    } else if (segmentEndY < segmentStartY) {
                        invertSlope = (segmentEndX - segmentStartX) / (segmentEndY - segmentStartY);
                        for (ypos = (float)Math.ceil(segmentEndY); ypos < segmentStartY; ypos += 1.0f) {
                            xpos = invertSlope * (ypos - segmentStartY) + segmentStartX;
                            GestureUtilities.plot(xpos, ypos, sample, sampleMatrixDimension);
                        }
                    }
                }
                segmentEndX = segmentStartX;
                segmentEndY = segmentStartY;
            }
        }
        return sample;
    }

    public static void plot(float x, float y, float[] sample, int sampleSize) {
        x = x < 0.0f ? 0.0f : x;
        y = y < 0.0f ? 0.0f : y;
        int xFloor = (int)Math.floor(x);
        int xCeiling = (int)Math.ceil(x);
        int yFloor = (int)Math.floor(y);
        int yCeiling = (int)Math.ceil(y);
        if (x == (float)xFloor && y == (float)yFloor) {
            int index = yCeiling * sampleSize + xCeiling;
            if (sample[index] < 1.0f) {
                sample[index] = 1.0f;
            }
        } else {
            int index;
            double btmRight;
            double btmLeft;
            double topRight;
            double sum;
            double topLeft = Math.sqrt(Math.pow((float)xFloor - x, 2.0) + Math.pow((float)yFloor - y, 2.0));
            double value = topLeft / (sum = topLeft + (topRight = Math.sqrt(Math.pow((float)xCeiling - x, 2.0) + Math.pow((float)yFloor - y, 2.0))) + (btmLeft = Math.sqrt(Math.pow((float)xFloor - x, 2.0) + Math.pow((float)yCeiling - y, 2.0))) + (btmRight = Math.sqrt(Math.pow((float)xCeiling - x, 2.0) + Math.pow((float)yCeiling - y, 2.0))));
            if (value > (double)sample[index = yFloor * sampleSize + xFloor]) {
                sample[index] = (float)value;
            }
            if ((value = topRight / sum) > (double)sample[index = yFloor * sampleSize + xCeiling]) {
                sample[index] = (float)value;
            }
            if ((value = btmLeft / sum) > (double)sample[index = yCeiling * sampleSize + xFloor]) {
                sample[index] = (float)value;
            }
            if ((value = btmRight / sum) > (double)sample[index = yCeiling * sampleSize + xCeiling]) {
                sample[index] = (float)value;
            }
        }
    }

    public static float[] temporalSampling(GestureStroke stroke, int sampleSize) {
        float increment = stroke.length / (float)(sampleSize - 1);
        int vectorLength = sampleSize * 2;
        float[] vector = new float[vectorLength];
        float distanceSoFar = 0.0f;
        float[] pts = stroke.points;
        float lstPointX = pts[0];
        float lstPointY = pts[1];
        int index = 0;
        float currentPointX = Float.MIN_VALUE;
        float currentPointY = Float.MIN_VALUE;
        vector[index] = lstPointX;
        vector[++index] = lstPointY;
        ++index;
        int i = 0;
        int count = pts.length / 2;
        while (i < count) {
            float deltaY;
            float deltaX;
            float distance;
            if (currentPointX == Float.MIN_VALUE) {
                if (++i >= count) break;
                currentPointX = pts[i * 2];
                currentPointY = pts[i * 2 + 1];
            }
            if (distanceSoFar + (distance = (float)Math.sqrt((deltaX = currentPointX - lstPointX) * deltaX + (deltaY = currentPointY - lstPointY) * deltaY)) >= increment) {
                float ratio = (increment - distanceSoFar) / distance;
                float nx = lstPointX + ratio * deltaX;
                float ny = lstPointY + ratio * deltaY;
                vector[index] = nx;
                vector[++index] = ny;
                ++index;
                lstPointX = nx;
                lstPointY = ny;
                distanceSoFar = 0.0f;
                continue;
            }
            lstPointX = currentPointX;
            lstPointY = currentPointY;
            currentPointX = Float.MIN_VALUE;
            currentPointY = Float.MIN_VALUE;
            distanceSoFar += distance;
        }
        for (i = index; i < vectorLength; i += 2) {
            vector[i] = lstPointX;
            vector[i + 1] = lstPointY;
        }
        return vector;
    }

    public static float[] computeCentroid(float[] points) {
        float centerX = 0.0f;
        float centerY = 0.0f;
        int count = points.length;
        for (int i = 0; i < count; ++i) {
            centerX += points[i];
            centerY += points[++i];
        }
        float[] center = new float[]{2.0f * centerX / (float)count, 2.0f * centerY / (float)count};
        return center;
    }

    public static double[][] computeCoVariance(float[] points) {
        double[][] array2 = new double[2][2];
        array2[0][0] = 0.0;
        array2[0][1] = 0.0;
        array2[1][0] = 0.0;
        array2[1][1] = 0.0;
        int count = points.length;
        for (int i = 0; i < count; ++i) {
            float x = points[i];
            float y = points[++i];
            double[] dArray = array2[0];
            dArray[0] = dArray[0] + (double)(x * x);
            double[] dArray2 = array2[0];
            dArray2[1] = dArray2[1] + (double)(x * y);
            array2[1][0] = array2[0][1];
            double[] dArray3 = array2[1];
            dArray3[1] = dArray3[1] + (double)(y * y);
        }
        double[] dArray = array2[0];
        dArray[0] = dArray[0] / (double)(count / 2);
        double[] dArray4 = array2[0];
        dArray4[1] = dArray4[1] / (double)(count / 2);
        double[] dArray5 = array2[1];
        dArray5[0] = dArray5[0] / (double)(count / 2);
        double[] dArray6 = array2[1];
        dArray6[1] = dArray6[1] / (double)(count / 2);
        return array2;
    }

    public static float computeTotalLength(float[] points) {
        float sum = 0.0f;
        int count = points.length - 4;
        for (int i = 0; i < count; i += 2) {
            float dx = points[i + 2] - points[i];
            float dy = points[i + 3] - points[i + 1];
            sum = (float)((double)sum + Math.sqrt(dx * dx + dy * dy));
        }
        return sum;
    }

    public static double computeStraightness(float[] points) {
        float totalLen = GestureUtilities.computeTotalLength(points);
        float dx = points[2] - points[0];
        float dy = points[3] - points[1];
        return Math.sqrt(dx * dx + dy * dy) / (double)totalLen;
    }

    public static double computeStraightness(float[] points, float totalLen) {
        float dx = points[2] - points[0];
        float dy = points[3] - points[1];
        return Math.sqrt(dx * dx + dy * dy) / (double)totalLen;
    }

    public static double squaredEuclideanDistance(float[] vector1, float[] vector2) {
        double squaredDistance = 0.0;
        int size = vector1.length;
        for (int i = 0; i < size; ++i) {
            float difference = vector1[i] - vector2[i];
            squaredDistance += (double)(difference * difference);
        }
        return squaredDistance / (double)size;
    }

    public static double cosineDistance(float[] vector1, float[] vector2) {
        float sum = 0.0f;
        int len = vector1.length;
        for (int i = 0; i < len; ++i) {
            sum += vector1[i] * vector2[i];
        }
        return Math.acos(sum);
    }

    public static OrientedBoundingBox computeOrientedBoundingBox(ArrayList<GesturePoint> pts) {
        GestureStroke stroke = new GestureStroke(pts);
        float[] points = GestureUtilities.temporalSampling(stroke, 16);
        return GestureUtilities.computeOrientedBoundingBox(points);
    }

    public static OrientedBoundingBox computeOrientedBoundingBox(float[] points) {
        float[] meanVector = GestureUtilities.computeCentroid(points);
        return GestureUtilities.computeOrientedBoundingBox(points, meanVector);
    }

    public static OrientedBoundingBox computeOrientedBoundingBox(float[] points, float[] centroid) {
        float angle;
        GestureUtilities.translate(points, -centroid[0], -centroid[1]);
        double[][] array2 = GestureUtilities.computeCoVariance(points);
        double[] targetVector = GestureUtilities.computeOrientation(array2);
        if (targetVector[0] == 0.0 && targetVector[1] == 0.0) {
            angle = -1.5707964f;
        } else {
            angle = (float)Math.atan2(targetVector[1], targetVector[0]);
            GestureUtilities.rotate(points, -angle);
        }
        float minx = Float.MAX_VALUE;
        float miny = Float.MAX_VALUE;
        float maxx = Float.MIN_VALUE;
        float maxy = Float.MIN_VALUE;
        int count = points.length;
        for (int i = 0; i < count; ++i) {
            if (points[i] < minx) {
                minx = points[i];
            }
            if (points[i] > maxx) {
                maxx = points[i];
            }
            if (points[++i] < miny) {
                miny = points[i];
            }
            if (!(points[i] > maxy)) continue;
            maxy = points[i];
        }
        return new OrientedBoundingBox((float)((double)(angle * 180.0f) / Math.PI), centroid[0], centroid[1], maxx - minx, maxy - miny);
    }

    public static double[] computeOrientation(double[][] covarianceMatrix) {
        double lambda2;
        double[] targetVector = new double[2];
        if (covarianceMatrix[0][1] == 0.0 || covarianceMatrix[1][0] == 0.0) {
            targetVector[0] = 1.0;
            targetVector[1] = 0.0;
        }
        double a = -covarianceMatrix[0][0] - covarianceMatrix[1][1];
        double b = covarianceMatrix[0][0] * covarianceMatrix[1][1] - covarianceMatrix[0][1] * covarianceMatrix[1][0];
        double value = a / 2.0;
        double rightside = Math.sqrt(Math.pow(value, 2.0) - b);
        double lambda1 = -value + rightside;
        if (lambda1 == (lambda2 = -value - rightside)) {
            targetVector[0] = 0.0;
            targetVector[1] = 0.0;
        } else {
            double lambda = lambda1 > lambda2 ? lambda1 : lambda2;
            targetVector[0] = 1.0;
            targetVector[1] = (lambda - covarianceMatrix[0][0]) / covarianceMatrix[0][1];
        }
        return targetVector;
    }

    public static float[] rotate(float[] points, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        int size = points.length;
        for (int i = 0; i < size; i += 2) {
            float x = (float)((double)points[i] * cos - (double)points[i + 1] * sin);
            float y = (float)((double)points[i] * sin + (double)points[i + 1] * cos);
            points[i] = x;
            points[i + 1] = y;
        }
        return points;
    }

    public static float[] translate(float[] points, float dx, float dy) {
        int size = points.length;
        for (int i = 0; i < size; i += 2) {
            int n = i;
            points[n] = points[n] + dx;
            int n2 = i + 1;
            points[n2] = points[n2] + dy;
        }
        return points;
    }

    public static float[] scale(float[] points, float sx, float sy) {
        int size = points.length;
        for (int i = 0; i < size; i += 2) {
            int n = i;
            points[n] = points[n] * sx;
            int n2 = i + 1;
            points[n2] = points[n2] * sy;
        }
        return points;
    }
}

