/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Shader;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;

public class LinearGradient
extends Shader {
    private GradientPaint mGradientPaint;

    public LinearGradient(float x0, float y0, float x1, float y1, int[] colors, float[] positions, Shader.TileMode tile) {
        if (colors.length < 2) {
            throw new IllegalArgumentException("needs >= 2 number of colors");
        }
        if (positions != null && colors.length != positions.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
    }

    public LinearGradient(float x0, float y0, float x1, float y1, int color0, int color1, Shader.TileMode tile) {
        this.mGradientPaint = new GradientPaint(x0, y0, new Color(color0, true), x1, y1, new Color(color1, true), tile != Shader.TileMode.CLAMP);
    }

    public Paint getPaint() {
        return this.mGradientPaint;
    }
}

