/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.RectF;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.PrintWriter;

public class _Original_Matrix {
    public static final int MSCALE_X = 0;
    public static final int MSKEW_X = 1;
    public static final int MTRANS_X = 2;
    public static final int MSKEW_Y = 3;
    public static final int MSCALE_Y = 4;
    public static final int MTRANS_Y = 5;
    public static final int MPERSP_0 = 6;
    public static final int MPERSP_1 = 7;
    public static final int MPERSP_2 = 8;
    public int native_instance;

    public _Original_Matrix() {
        this.native_instance = _Original_Matrix.native_create(0);
    }

    public _Original_Matrix(_Original_Matrix src) {
        this.native_instance = _Original_Matrix.native_create(src != null ? src.native_instance : 0);
    }

    public boolean isIdentity() {
        return _Original_Matrix.native_isIdentity(this.native_instance);
    }

    public boolean rectStaysRect() {
        return _Original_Matrix.native_rectStaysRect(this.native_instance);
    }

    public void set(_Original_Matrix src) {
        if (src == null) {
            this.reset();
        } else {
            _Original_Matrix.native_set(this.native_instance, src.native_instance);
        }
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof _Original_Matrix && _Original_Matrix.native_equals(this.native_instance, ((_Original_Matrix)obj).native_instance);
    }

    public void reset() {
        _Original_Matrix.native_reset(this.native_instance);
    }

    public void setTranslate(float dx, float dy) {
        _Original_Matrix.native_setTranslate(this.native_instance, dx, dy);
    }

    public void setScale(float sx, float sy, float px, float py) {
        _Original_Matrix.native_setScale(this.native_instance, sx, sy, px, py);
    }

    public void setScale(float sx, float sy) {
        _Original_Matrix.native_setScale(this.native_instance, sx, sy);
    }

    public void setRotate(float degrees, float px, float py) {
        _Original_Matrix.native_setRotate(this.native_instance, degrees, px, py);
    }

    public void setRotate(float degrees) {
        _Original_Matrix.native_setRotate(this.native_instance, degrees);
    }

    public void setSinCos(float sinValue, float cosValue, float px, float py) {
        _Original_Matrix.native_setSinCos(this.native_instance, sinValue, cosValue, px, py);
    }

    public void setSinCos(float sinValue, float cosValue) {
        _Original_Matrix.native_setSinCos(this.native_instance, sinValue, cosValue);
    }

    public void setSkew(float kx, float ky, float px, float py) {
        _Original_Matrix.native_setSkew(this.native_instance, kx, ky, px, py);
    }

    public void setSkew(float kx, float ky) {
        _Original_Matrix.native_setSkew(this.native_instance, kx, ky);
    }

    public boolean setConcat(_Original_Matrix a, _Original_Matrix b) {
        return _Original_Matrix.native_setConcat(this.native_instance, a.native_instance, b.native_instance);
    }

    public boolean preTranslate(float dx, float dy) {
        return _Original_Matrix.native_preTranslate(this.native_instance, dx, dy);
    }

    public boolean preScale(float sx, float sy, float px, float py) {
        return _Original_Matrix.native_preScale(this.native_instance, sx, sy, px, py);
    }

    public boolean preScale(float sx, float sy) {
        return _Original_Matrix.native_preScale(this.native_instance, sx, sy);
    }

    public boolean preRotate(float degrees, float px, float py) {
        return _Original_Matrix.native_preRotate(this.native_instance, degrees, px, py);
    }

    public boolean preRotate(float degrees) {
        return _Original_Matrix.native_preRotate(this.native_instance, degrees);
    }

    public boolean preSkew(float kx, float ky, float px, float py) {
        return _Original_Matrix.native_preSkew(this.native_instance, kx, ky, px, py);
    }

    public boolean preSkew(float kx, float ky) {
        return _Original_Matrix.native_preSkew(this.native_instance, kx, ky);
    }

    public boolean preConcat(_Original_Matrix other) {
        return _Original_Matrix.native_preConcat(this.native_instance, other.native_instance);
    }

    public boolean postTranslate(float dx, float dy) {
        return _Original_Matrix.native_postTranslate(this.native_instance, dx, dy);
    }

    public boolean postScale(float sx, float sy, float px, float py) {
        return _Original_Matrix.native_postScale(this.native_instance, sx, sy, px, py);
    }

    public boolean postScale(float sx, float sy) {
        return _Original_Matrix.native_postScale(this.native_instance, sx, sy);
    }

    public boolean postRotate(float degrees, float px, float py) {
        return _Original_Matrix.native_postRotate(this.native_instance, degrees, px, py);
    }

    public boolean postRotate(float degrees) {
        return _Original_Matrix.native_postRotate(this.native_instance, degrees);
    }

    public boolean postSkew(float kx, float ky, float px, float py) {
        return _Original_Matrix.native_postSkew(this.native_instance, kx, ky, px, py);
    }

    public boolean postSkew(float kx, float ky) {
        return _Original_Matrix.native_postSkew(this.native_instance, kx, ky);
    }

    public boolean postConcat(_Original_Matrix other) {
        return _Original_Matrix.native_postConcat(this.native_instance, other.native_instance);
    }

    public boolean setRectToRect(RectF src, RectF dst, ScaleToFit stf) {
        if (dst == null || src == null) {
            throw new NullPointerException();
        }
        return _Original_Matrix.native_setRectToRect(this.native_instance, src, dst, stf.nativeInt);
    }

    public static void checkPointArrays(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
        int srcStop = srcIndex + (pointCount << 1);
        int dstStop = dstIndex + (pointCount << 1);
        if ((pointCount | srcIndex | dstIndex | srcStop | dstStop) < 0 || srcStop > src.length || dstStop > dst.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public boolean setPolyToPoly(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
        if (pointCount > 4) {
            throw new IllegalArgumentException();
        }
        _Original_Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, pointCount);
        return _Original_Matrix.native_setPolyToPoly(this.native_instance, src, srcIndex, dst, dstIndex, pointCount);
    }

    public boolean invert(_Original_Matrix inverse) {
        return _Original_Matrix.native_invert(this.native_instance, inverse.native_instance);
    }

    public void mapPoints(float[] dst, int dstIndex, float[] src, int srcIndex, int pointCount) {
        _Original_Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, pointCount);
        _Original_Matrix.native_mapPoints(this.native_instance, dst, dstIndex, src, srcIndex, pointCount, true);
    }

    public void mapVectors(float[] dst, int dstIndex, float[] src, int srcIndex, int vectorCount) {
        _Original_Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, vectorCount);
        _Original_Matrix.native_mapPoints(this.native_instance, dst, dstIndex, src, srcIndex, vectorCount, false);
    }

    public void mapPoints(float[] dst, float[] src) {
        if (dst.length != src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mapPoints(dst, 0, src, 0, dst.length >> 1);
    }

    public void mapVectors(float[] dst, float[] src) {
        if (dst.length != src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mapVectors(dst, 0, src, 0, dst.length >> 1);
    }

    public void mapPoints(float[] pts) {
        this.mapPoints(pts, 0, pts, 0, pts.length >> 1);
    }

    public void mapVectors(float[] vecs) {
        this.mapVectors(vecs, 0, vecs, 0, vecs.length >> 1);
    }

    public boolean mapRect(RectF dst, RectF src) {
        if (dst == null || src == null) {
            throw new NullPointerException();
        }
        return _Original_Matrix.native_mapRect(this.native_instance, dst, src);
    }

    public boolean mapRect(RectF rect) {
        return this.mapRect(rect, rect);
    }

    public float mapRadius(float radius) {
        return _Original_Matrix.native_mapRadius(this.native_instance, radius);
    }

    public void getValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        _Original_Matrix.native_getValues(this.native_instance, values);
    }

    public void setValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        _Original_Matrix.native_setValues(this.native_instance, values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Matrix{");
        this.toShortString(sb);
        sb.append('}');
        return sb.toString();
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder(64);
        this.toShortString(sb);
        return sb.toString();
    }

    public void toShortString(StringBuilder sb) {
        float[] values = new float[9];
        this.getValues(values);
        sb.append('[');
        sb.append(values[0]);
        sb.append(", ");
        sb.append(values[1]);
        sb.append(", ");
        sb.append(values[2]);
        sb.append("][");
        sb.append(values[3]);
        sb.append(", ");
        sb.append(values[4]);
        sb.append(", ");
        sb.append(values[5]);
        sb.append("][");
        sb.append(values[6]);
        sb.append(", ");
        sb.append(values[7]);
        sb.append(", ");
        sb.append(values[8]);
        sb.append(']');
    }

    public void printShortString(PrintWriter pw) {
        float[] values = new float[9];
        this.getValues(values);
        pw.print('[');
        pw.print(values[0]);
        pw.print(", ");
        pw.print(values[1]);
        pw.print(", ");
        pw.print(values[2]);
        pw.print("][");
        pw.print(values[3]);
        pw.print(", ");
        pw.print(values[4]);
        pw.print(", ");
        pw.print(values[5]);
        pw.print("][");
        pw.print(values[6]);
        pw.print(", ");
        pw.print(values[7]);
        pw.print(", ");
        pw.print(values[8]);
        pw.print(']');
    }

    public void finalize() throws Throwable {
        _Original_Matrix.finalizer(this.native_instance);
    }

    public int ni() {
        return this.native_instance;
    }

    public static int native_create(int n) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_create(I)I", true, null);
    }

    public static boolean native_isIdentity(int n) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_isIdentity(I)Z", true, null) != 0;
    }

    public static boolean native_rectStaysRect(int n) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_rectStaysRect(I)Z", true, null) != 0;
    }

    public static void native_reset(int n) {
        OverrideMethod.invokeV("android.graphics._Original_Matrix#native_reset(I)V", true, null);
    }

    public static void native_set(int n, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Matrix#native_set(II)V", true, null);
    }

    public static void native_setTranslate(int n, float f, float f2) {
        OverrideMethod.invokeV("android.graphics._Original_Matrix#native_setTranslate(IFF)V", true, null);
    }

    public static void native_setScale(int n, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("android.graphics._Original_Matrix#native_setScale(IFFFF)V", true, null);
    }

    public static void native_setScale(int n, float f, float f2) {
        OverrideMethod.invokeV("android.graphics._Original_Matrix#native_setScale(IFF)V", true, null);
    }

    public static void native_setRotate(int n, float f, float f2, float f3) {
        OverrideMethod.invokeV("android.graphics._Original_Matrix#native_setRotate(IFFF)V", true, null);
    }

    public static void native_setRotate(int n, float f) {
        OverrideMethod.invokeV("android.graphics._Original_Matrix#native_setRotate(IF)V", true, null);
    }

    public static void native_setSinCos(int n, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("android.graphics._Original_Matrix#native_setSinCos(IFFFF)V", true, null);
    }

    public static void native_setSinCos(int n, float f, float f2) {
        OverrideMethod.invokeV("android.graphics._Original_Matrix#native_setSinCos(IFF)V", true, null);
    }

    public static void native_setSkew(int n, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("android.graphics._Original_Matrix#native_setSkew(IFFFF)V", true, null);
    }

    public static void native_setSkew(int n, float f, float f2) {
        OverrideMethod.invokeV("android.graphics._Original_Matrix#native_setSkew(IFF)V", true, null);
    }

    public static boolean native_setConcat(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_setConcat(III)Z", true, null) != 0;
    }

    public static boolean native_preTranslate(int n, float f, float f2) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_preTranslate(IFF)Z", true, null) != 0;
    }

    public static boolean native_preScale(int n, float f, float f2, float f3, float f4) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_preScale(IFFFF)Z", true, null) != 0;
    }

    public static boolean native_preScale(int n, float f, float f2) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_preScale(IFF)Z", true, null) != 0;
    }

    public static boolean native_preRotate(int n, float f, float f2, float f3) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_preRotate(IFFF)Z", true, null) != 0;
    }

    public static boolean native_preRotate(int n, float f) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_preRotate(IF)Z", true, null) != 0;
    }

    public static boolean native_preSkew(int n, float f, float f2, float f3, float f4) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_preSkew(IFFFF)Z", true, null) != 0;
    }

    public static boolean native_preSkew(int n, float f, float f2) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_preSkew(IFF)Z", true, null) != 0;
    }

    public static boolean native_preConcat(int n, int n2) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_preConcat(II)Z", true, null) != 0;
    }

    public static boolean native_postTranslate(int n, float f, float f2) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_postTranslate(IFF)Z", true, null) != 0;
    }

    public static boolean native_postScale(int n, float f, float f2, float f3, float f4) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_postScale(IFFFF)Z", true, null) != 0;
    }

    public static boolean native_postScale(int n, float f, float f2) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_postScale(IFF)Z", true, null) != 0;
    }

    public static boolean native_postRotate(int n, float f, float f2, float f3) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_postRotate(IFFF)Z", true, null) != 0;
    }

    public static boolean native_postRotate(int n, float f) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_postRotate(IF)Z", true, null) != 0;
    }

    public static boolean native_postSkew(int n, float f, float f2, float f3, float f4) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_postSkew(IFFFF)Z", true, null) != 0;
    }

    public static boolean native_postSkew(int n, float f, float f2) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_postSkew(IFF)Z", true, null) != 0;
    }

    public static boolean native_postConcat(int n, int n2) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_postConcat(II)Z", true, null) != 0;
    }

    public static boolean native_setRectToRect(int n, RectF rectF, RectF rectF2, int n2) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_setRectToRect(ILandroid/graphics/RectF;Landroid/graphics/RectF;I)Z", true, null) != 0;
    }

    public static boolean native_setPolyToPoly(int n, float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_setPolyToPoly(I[FI[FII)Z", true, null) != 0;
    }

    public static boolean native_invert(int n, int n2) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_invert(II)Z", true, null) != 0;
    }

    public static void native_mapPoints(int n, float[] fArray, int n2, float[] fArray2, int n3, int n4, boolean bl) {
        OverrideMethod.invokeV("android.graphics._Original_Matrix#native_mapPoints(I[FI[FIIZ)V", true, null);
    }

    public static boolean native_mapRect(int n, RectF rectF, RectF rectF2) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_mapRect(ILandroid/graphics/RectF;Landroid/graphics/RectF;)Z", true, null) != 0;
    }

    public static float native_mapRadius(int n, float f) {
        return OverrideMethod.invokeF("android.graphics._Original_Matrix#native_mapRadius(IF)F", true, null);
    }

    public static void native_getValues(int n, float[] fArray) {
        OverrideMethod.invokeV("android.graphics._Original_Matrix#native_getValues(I[F)V", true, null);
    }

    public static void native_setValues(int n, float[] fArray) {
        OverrideMethod.invokeV("android.graphics._Original_Matrix#native_setValues(I[F)V", true, null);
    }

    public static boolean native_equals(int n, int n2) {
        return OverrideMethod.invokeI("android.graphics._Original_Matrix#native_equals(II)Z", true, null) != 0;
    }

    public static void finalizer(int n) {
        OverrideMethod.invokeV("android.graphics._Original_Matrix#finalizer(I)V", true, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScaleToFit {
        FILL(0),
        START(1),
        CENTER(2),
        END(3);

        public final int nativeInt;

        public ScaleToFit(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

