/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.RectF;
import com.android.tools.layoutlib.create.OverrideMethod;

public class _Original_Path {
    public static final FillType[] sFillTypeArray = new FillType[]{FillType.WINDING, FillType.EVEN_ODD, FillType.INVERSE_WINDING, FillType.INVERSE_EVEN_ODD};
    public final int mNativePath;

    public _Original_Path() {
        this.mNativePath = _Original_Path.init1();
    }

    public _Original_Path(_Original_Path src) {
        int valNative = 0;
        if (src != null) {
            valNative = src.mNativePath;
        }
        this.mNativePath = _Original_Path.init2(valNative);
    }

    public void reset() {
        _Original_Path.native_reset(this.mNativePath);
    }

    public void rewind() {
        _Original_Path.native_rewind(this.mNativePath);
    }

    public void set(_Original_Path src) {
        if (this != src) {
            _Original_Path.native_set(this.mNativePath, src.mNativePath);
        }
    }

    public FillType getFillType() {
        return sFillTypeArray[_Original_Path.native_getFillType(this.mNativePath)];
    }

    public void setFillType(FillType ft) {
        _Original_Path.native_setFillType(this.mNativePath, ft.nativeInt);
    }

    public boolean isInverseFillType() {
        int ft = _Original_Path.native_getFillType(this.mNativePath);
        return (ft & 2) != 0;
    }

    public void toggleInverseFillType() {
        int ft = _Original_Path.native_getFillType(this.mNativePath);
        _Original_Path.native_setFillType(this.mNativePath, ft ^= 2);
    }

    public boolean isEmpty() {
        return _Original_Path.native_isEmpty(this.mNativePath);
    }

    public boolean isRect(RectF rect) {
        return _Original_Path.native_isRect(this.mNativePath, rect);
    }

    public void computeBounds(RectF bounds, boolean exact) {
        _Original_Path.native_computeBounds(this.mNativePath, bounds, exact ? 1 : 0);
    }

    public void incReserve(int extraPtCount) {
        _Original_Path.native_incReserve(this.mNativePath, extraPtCount);
    }

    public void moveTo(float x, float y) {
        _Original_Path.native_moveTo(this.mNativePath, x, y);
    }

    public void rMoveTo(float dx, float dy) {
        _Original_Path.native_rMoveTo(this.mNativePath, dx, dy);
    }

    public void lineTo(float x, float y) {
        _Original_Path.native_lineTo(this.mNativePath, x, y);
    }

    public void rLineTo(float dx, float dy) {
        _Original_Path.native_rLineTo(this.mNativePath, dx, dy);
    }

    public void quadTo(float x1, float y1, float x2, float y2) {
        _Original_Path.native_quadTo(this.mNativePath, x1, y1, x2, y2);
    }

    public void rQuadTo(float dx1, float dy1, float dx2, float dy2) {
        _Original_Path.native_rQuadTo(this.mNativePath, dx1, dy1, dx2, dy2);
    }

    public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        _Original_Path.native_cubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    public void rCubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        _Original_Path.native_rCubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    public void arcTo(RectF oval, float startAngle, float sweepAngle, boolean forceMoveTo) {
        _Original_Path.native_arcTo(this.mNativePath, oval, startAngle, sweepAngle, forceMoveTo);
    }

    public void arcTo(RectF oval, float startAngle, float sweepAngle) {
        _Original_Path.native_arcTo(this.mNativePath, oval, startAngle, sweepAngle, false);
    }

    public void close() {
        _Original_Path.native_close(this.mNativePath);
    }

    public void addRect(RectF rect, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        _Original_Path.native_addRect(this.mNativePath, rect, dir.nativeInt);
    }

    public void addRect(float left, float top, float right, float bottom, Direction dir) {
        _Original_Path.native_addRect(this.mNativePath, left, top, right, bottom, dir.nativeInt);
    }

    public void addOval(RectF oval, Direction dir) {
        if (oval == null) {
            throw new NullPointerException("need oval parameter");
        }
        _Original_Path.native_addOval(this.mNativePath, oval, dir.nativeInt);
    }

    public void addCircle(float x, float y, float radius, Direction dir) {
        _Original_Path.native_addCircle(this.mNativePath, x, y, radius, dir.nativeInt);
    }

    public void addArc(RectF oval, float startAngle, float sweepAngle) {
        if (oval == null) {
            throw new NullPointerException("need oval parameter");
        }
        _Original_Path.native_addArc(this.mNativePath, oval, startAngle, sweepAngle);
    }

    public void addRoundRect(RectF rect, float rx, float ry, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        _Original_Path.native_addRoundRect(this.mNativePath, rect, rx, ry, dir.nativeInt);
    }

    public void addRoundRect(RectF rect, float[] radii, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        if (radii.length < 8) {
            throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
        }
        _Original_Path.native_addRoundRect(this.mNativePath, rect, radii, dir.nativeInt);
    }

    public void addPath(_Original_Path src, float dx, float dy) {
        _Original_Path.native_addPath(this.mNativePath, src.mNativePath, dx, dy);
    }

    public void addPath(_Original_Path src) {
        _Original_Path.native_addPath(this.mNativePath, src.mNativePath);
    }

    public void addPath(_Original_Path src, Matrix matrix) {
        _Original_Path.native_addPath(this.mNativePath, src.mNativePath, matrix.native_instance);
    }

    public void offset(float dx, float dy, _Original_Path dst) {
        int dstNative = 0;
        if (dst != null) {
            dstNative = dst.mNativePath;
        }
        _Original_Path.native_offset(this.mNativePath, dx, dy, dstNative);
    }

    public void offset(float dx, float dy) {
        _Original_Path.native_offset(this.mNativePath, dx, dy);
    }

    public void setLastPoint(float dx, float dy) {
        _Original_Path.native_setLastPoint(this.mNativePath, dx, dy);
    }

    public void transform(Matrix matrix, _Original_Path dst) {
        int dstNative = 0;
        if (dst != null) {
            dstNative = dst.mNativePath;
        }
        _Original_Path.native_transform(this.mNativePath, matrix.native_instance, dstNative);
    }

    public void transform(Matrix matrix) {
        _Original_Path.native_transform(this.mNativePath, matrix.native_instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            _Original_Path.finalizer(this.mNativePath);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public int ni() {
        return this.mNativePath;
    }

    public static int init1() {
        return OverrideMethod.invokeI("android.graphics._Original_Path#init1()I", true, null);
    }

    public static int init2(int n) {
        return OverrideMethod.invokeI("android.graphics._Original_Path#init2(I)I", true, null);
    }

    public static void native_reset(int n) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_reset(I)V", true, null);
    }

    public static void native_rewind(int n) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_rewind(I)V", true, null);
    }

    public static void native_set(int n, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_set(II)V", true, null);
    }

    public static int native_getFillType(int n) {
        return OverrideMethod.invokeI("android.graphics._Original_Path#native_getFillType(I)I", true, null);
    }

    public static void native_setFillType(int n, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_setFillType(II)V", true, null);
    }

    public static boolean native_isEmpty(int n) {
        return OverrideMethod.invokeI("android.graphics._Original_Path#native_isEmpty(I)Z", true, null) != 0;
    }

    public static boolean native_isRect(int n, RectF rectF) {
        return OverrideMethod.invokeI("android.graphics._Original_Path#native_isRect(ILandroid/graphics/RectF;)Z", true, null) != 0;
    }

    public static void native_computeBounds(int n, RectF rectF, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_computeBounds(ILandroid/graphics/RectF;I)V", true, null);
    }

    public static void native_incReserve(int n, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_incReserve(II)V", true, null);
    }

    public static void native_moveTo(int n, float f, float f2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_moveTo(IFF)V", true, null);
    }

    public static void native_rMoveTo(int n, float f, float f2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_rMoveTo(IFF)V", true, null);
    }

    public static void native_lineTo(int n, float f, float f2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_lineTo(IFF)V", true, null);
    }

    public static void native_rLineTo(int n, float f, float f2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_rLineTo(IFF)V", true, null);
    }

    public static void native_quadTo(int n, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_quadTo(IFFFF)V", true, null);
    }

    public static void native_rQuadTo(int n, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_rQuadTo(IFFFF)V", true, null);
    }

    public static void native_cubicTo(int n, float f, float f2, float f3, float f4, float f5, float f6) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_cubicTo(IFFFFFF)V", true, null);
    }

    public static void native_rCubicTo(int n, float f, float f2, float f3, float f4, float f5, float f6) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_rCubicTo(IFFFFFF)V", true, null);
    }

    public static void native_arcTo(int n, RectF rectF, float f, float f2, boolean bl) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_arcTo(ILandroid/graphics/RectF;FFZ)V", true, null);
    }

    public static void native_close(int n) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_close(I)V", true, null);
    }

    public static void native_addRect(int n, RectF rectF, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_addRect(ILandroid/graphics/RectF;I)V", true, null);
    }

    public static void native_addRect(int n, float f, float f2, float f3, float f4, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_addRect(IFFFFI)V", true, null);
    }

    public static void native_addOval(int n, RectF rectF, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_addOval(ILandroid/graphics/RectF;I)V", true, null);
    }

    public static void native_addCircle(int n, float f, float f2, float f3, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_addCircle(IFFFI)V", true, null);
    }

    public static void native_addArc(int n, RectF rectF, float f, float f2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_addArc(ILandroid/graphics/RectF;FF)V", true, null);
    }

    public static void native_addRoundRect(int n, RectF rectF, float f, float f2, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_addRoundRect(ILandroid/graphics/RectF;FFI)V", true, null);
    }

    public static void native_addRoundRect(int n, RectF rectF, float[] fArray, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_addRoundRect(ILandroid/graphics/RectF;[FI)V", true, null);
    }

    public static void native_addPath(int n, int n2, float f, float f2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_addPath(IIFF)V", true, null);
    }

    public static void native_addPath(int n, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_addPath(II)V", true, null);
    }

    public static void native_addPath(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_addPath(III)V", true, null);
    }

    public static void native_offset(int n, float f, float f2, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_offset(IFFI)V", true, null);
    }

    public static void native_offset(int n, float f, float f2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_offset(IFF)V", true, null);
    }

    public static void native_setLastPoint(int n, float f, float f2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_setLastPoint(IFF)V", true, null);
    }

    public static void native_transform(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_transform(III)V", true, null);
    }

    public static void native_transform(int n, int n2) {
        OverrideMethod.invokeV("android.graphics._Original_Path#native_transform(II)V", true, null);
    }

    public static void finalizer(int n) {
        OverrideMethod.invokeV("android.graphics._Original_Path#finalizer(I)V", true, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        CW(0),
        CCW(1);

        public final int nativeInt;

        public Direction(int ni) {
            this.nativeInt = ni;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FillType {
        WINDING(0),
        EVEN_ODD(1),
        INVERSE_WINDING(2),
        INVERSE_EVEN_ODD(3);

        public final int nativeInt;

        public FillType(int ni) {
            this.nativeInt = ni;
        }
    }
}

