/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LevelListDrawable
extends DrawableContainer {
    public final LevelListState mLevelListState;
    public boolean mMutated;

    public LevelListDrawable() {
        this(null, null);
    }

    public void addLevel(int low, int high, Drawable drawable2) {
        if (drawable2 != null) {
            this.mLevelListState.addLevel(low, high, drawable2);
            this.onLevelChange(this.getLevel());
        }
    }

    public boolean onLevelChange(int level) {
        int idx = this.mLevelListState.indexOfLevel(level);
        if (this.selectDrawable(idx)) {
            return true;
        }
        return super.onLevelChange(level);
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int depth;
        int type;
        super.inflate(r, parser, attrs);
        int low = 0;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            Drawable dr;
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            TypedArray a = r.obtainAttributes(attrs, R.styleable.LevelListDrawableItem);
            low = a.getInt(1, 0);
            int high = a.getInt(2, 0);
            int drawableRes = a.getResourceId(0, 0);
            a.recycle();
            if (high < 0) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'maxLevel' attribute");
            }
            if (drawableRes != 0) {
                dr = r.getDrawable(drawableRes);
            } else {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
                }
                dr = Drawable.createFromXmlInner(r, parser, attrs);
            }
            this.mLevelListState.addLevel(low, high, dr);
        }
        this.onLevelChange(this.getLevel());
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            LevelListState.access$002(this.mLevelListState, (int[])this.mLevelListState.mLows.clone());
            LevelListState.access$102(this.mLevelListState, (int[])this.mLevelListState.mHighs.clone());
            this.mMutated = true;
        }
        return this;
    }

    public LevelListDrawable(LevelListState state, Resources res) {
        LevelListState as;
        this.mLevelListState = as = new LevelListState(state, this, res);
        this.setConstantState(as);
        this.onLevelChange(this.getLevel());
    }

    public /* synthetic */ LevelListDrawable(LevelListState x0, Resources x1, 1 x2) {
        this(x0, x1);
    }

    public static class 1 {
    }

    public static class LevelListState
    extends DrawableContainer.DrawableContainerState {
        public int[] mLows;
        public int[] mHighs;

        public LevelListState(LevelListState orig, LevelListDrawable owner, Resources res) {
            super(orig, owner, res);
            if (orig != null) {
                this.mLows = orig.mLows;
                this.mHighs = orig.mHighs;
            } else {
                this.mLows = new int[this.getChildren().length];
                this.mHighs = new int[this.getChildren().length];
            }
        }

        public void addLevel(int low, int high, Drawable drawable2) {
            int pos = this.addChild(drawable2);
            this.mLows[pos] = low;
            this.mHighs[pos] = high;
        }

        public int indexOfLevel(int level) {
            int[] lows = this.mLows;
            int[] highs = this.mHighs;
            int N = this.getChildCount();
            for (int i = 0; i < N; ++i) {
                if (level < lows[i] || level > highs[i]) continue;
                return i;
            }
            return -1;
        }

        public Drawable newDrawable() {
            return new LevelListDrawable(this, null, null);
        }

        public Drawable newDrawable(Resources res) {
            return new LevelListDrawable(this, res, null);
        }

        public void growArray(int oldSize, int newSize) {
            super.growArray(oldSize, newSize);
            int[] newInts = new int[newSize];
            System.arraycopy(this.mLows, 0, newInts, 0, oldSize);
            this.mLows = newInts;
            newInts = new int[newSize];
            System.arraycopy(this.mHighs, 0, newInts, 0, oldSize);
            this.mHighs = newInts;
        }

        public static /* synthetic */ int[] access$002(LevelListState x0, int[] x1) {
            x0.mLows = x1;
            return x1;
        }

        public static /* synthetic */ int[] access$102(LevelListState x0, int[] x1) {
            x0.mHighs = x1;
            return x1;
        }
    }
}

