/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.util.AttributeSet;
import com.android.internal.R;
import org.xmlpull.v1.XmlPullParser;

public class PaintDrawable
extends ShapeDrawable {
    public PaintDrawable() {
    }

    public PaintDrawable(int color2) {
        this.getPaint().setColor(color2);
    }

    public void setCornerRadius(float radius) {
        float[] radii = null;
        if (radius > 0.0f) {
            radii = new float[8];
            for (int i = 0; i < 8; ++i) {
                radii[i] = radius;
            }
        }
        this.setCornerRadii(radii);
    }

    public void setCornerRadii(float[] radii) {
        if (radii == null) {
            if (this.getShape() != null) {
                this.setShape(null);
            }
        } else {
            this.setShape(new RoundRectShape(radii, null, null));
        }
    }

    public boolean inflateTag(String name, Resources r, XmlPullParser parser, AttributeSet attrs) {
        if (name.equals("corners")) {
            TypedArray a = r.obtainAttributes(attrs, R.styleable.DrawableCorners);
            int radius = a.getDimensionPixelSize(0, 0);
            this.setCornerRadius(radius);
            int topLeftRadius = a.getDimensionPixelSize(1, radius);
            int topRightRadius = a.getDimensionPixelSize(2, radius);
            int bottomLeftRadius = a.getDimensionPixelSize(3, radius);
            int bottomRightRadius = a.getDimensionPixelSize(4, radius);
            if (topLeftRadius != radius || topRightRadius != radius || bottomLeftRadius != radius || bottomRightRadius != radius) {
                this.setCornerRadii(new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomLeftRadius, bottomLeftRadius, bottomRightRadius, bottomRightRadius});
            }
            a.recycle();
            return true;
        }
        return super.inflateTag(name, r, parser, attrs);
    }
}

