/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.util.AttributeSet;
import android.util.StateSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StateListDrawable
extends DrawableContainer {
    public static final boolean DEFAULT_DITHER = true;
    public final StateListState mStateListState;
    public boolean mMutated;

    public StateListDrawable() {
        this(null, null);
    }

    public void addState(int[] stateSet, Drawable drawable2) {
        if (drawable2 != null) {
            this.mStateListState.addStateSet(stateSet, drawable2);
            this.onStateChange(this.getState());
        }
    }

    public boolean isStateful() {
        return true;
    }

    public boolean onStateChange(int[] stateSet) {
        int idx = this.mStateListState.indexOfStateSet(stateSet);
        if (idx < 0) {
            idx = this.mStateListState.indexOfStateSet(StateSet.WILD_CARD);
        }
        if (this.selectDrawable(idx)) {
            return true;
        }
        return super.onStateChange(stateSet);
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int depth;
        int type;
        TypedArray a = r.obtainAttributes(attrs, R.styleable.StateListDrawable);
        super.inflateWithAttributes(r, parser, a, 1);
        this.mStateListState.setVariablePadding(a.getBoolean(2, false));
        this.mStateListState.setConstantSize(a.getBoolean(3, false));
        this.setDither(a.getBoolean(0, true));
        a.recycle();
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            Drawable dr;
            int stateResId;
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            int drawableRes = 0;
            int j = 0;
            int numAttrs = attrs.getAttributeCount();
            int[] states = new int[numAttrs];
            for (int i = 0; i < numAttrs && (stateResId = attrs.getAttributeNameResource(i)) != 0; ++i) {
                if (stateResId == 0x1010199) {
                    drawableRes = attrs.getAttributeResourceValue(i, 0);
                    continue;
                }
                states[j++] = attrs.getAttributeBooleanValue(i, false) ? stateResId : -stateResId;
            }
            states = StateSet.trimStateSet(states, j);
            if (drawableRes != 0) {
                dr = r.getDrawable(drawableRes);
            } else {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
                }
                dr = Drawable.createFromXmlInner(r, parser, attrs);
            }
            this.mStateListState.addStateSet(states, dr);
        }
        this.onStateChange(this.getState());
    }

    public StateListState getStateListState() {
        return this.mStateListState;
    }

    public int getStateCount() {
        return this.mStateListState.getChildCount();
    }

    public int[] getStateSet(int index) {
        return this.mStateListState.mStateSets[index];
    }

    public Drawable getStateDrawable(int index) {
        return this.mStateListState.getChildren()[index];
    }

    public int getStateDrawableIndex(int[] stateSet) {
        return this.mStateListState.indexOfStateSet(stateSet);
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            int[][] sets = this.mStateListState.mStateSets;
            int count = sets.length;
            StateListState.access$102(this.mStateListState, new int[count][]);
            for (int i = 0; i < count; ++i) {
                ((StateListState)this.mStateListState).mStateSets[i] = (int[])sets[i].clone();
            }
            this.mMutated = true;
        }
        return this;
    }

    public StateListDrawable(StateListState state, Resources res) {
        StateListState as;
        this.mStateListState = as = new StateListState(state, this, res);
        this.setConstantState(as);
        this.onStateChange(this.getState());
    }

    public /* synthetic */ StateListDrawable(StateListState x0, Resources x1, 1 x2) {
        this(x0, x1);
    }

    public static class 1 {
    }

    public static class StateListState
    extends DrawableContainer.DrawableContainerState {
        public int[][] mStateSets;

        public StateListState(StateListState orig, StateListDrawable owner, Resources res) {
            super(orig, owner, res);
            this.mStateSets = orig != null ? orig.mStateSets : (int[][])new int[this.getChildren().length][];
        }

        public int addStateSet(int[] stateSet, Drawable drawable2) {
            int pos = this.addChild(drawable2);
            this.mStateSets[pos] = stateSet;
            return pos;
        }

        public int indexOfStateSet(int[] stateSet) {
            int[][] stateSets = this.mStateSets;
            int N = this.getChildCount();
            for (int i = 0; i < N; ++i) {
                if (!StateSet.stateSetMatches(stateSets[i], stateSet)) continue;
                return i;
            }
            return -1;
        }

        public Drawable newDrawable() {
            return new StateListDrawable(this, null, null);
        }

        public Drawable newDrawable(Resources res) {
            return new StateListDrawable(this, res, null);
        }

        public void growArray(int oldSize, int newSize) {
            super.growArray(oldSize, newSize);
            int[][] newStateSets = new int[newSize][];
            System.arraycopy(this.mStateSets, 0, newStateSets, 0, oldSize);
            this.mStateSets = newStateSets;
        }

        public static /* synthetic */ int[][] access$102(StateListState x0, int[][] x1) {
            x0.mStateSets = x1;
            return x1;
        }
    }
}

