/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.GpsSatellite;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GpsStatus {
    public static final int NUM_SATELLITES = 255;
    public int mTimeToFirstFix;
    public GpsSatellite[] mSatellites = new GpsSatellite[255];
    public Iterable<GpsSatellite> mSatelliteList = new Iterable<GpsSatellite>(){

        @Override
        public Iterator<GpsSatellite> iterator() {
            return new SatelliteIterator(GpsStatus.this.mSatellites);
        }
    };
    public static final int GPS_EVENT_STARTED = 1;
    public static final int GPS_EVENT_STOPPED = 2;
    public static final int GPS_EVENT_FIRST_FIX = 3;
    public static final int GPS_EVENT_SATELLITE_STATUS = 4;

    public GpsStatus() {
        for (int i = 0; i < this.mSatellites.length; ++i) {
            this.mSatellites[i] = new GpsSatellite(i + 1);
        }
    }

    public synchronized void setStatus(int svCount, int[] prns, float[] snrs, float[] elevations, float[] azimuths, int ephemerisMask, int almanacMask, int usedInFixMask) {
        int i;
        for (i = 0; i < this.mSatellites.length; ++i) {
            this.mSatellites[i].mValid = false;
        }
        for (i = 0; i < svCount; ++i) {
            int prn = prns[i] - 1;
            int prnShift = 1 << prn;
            GpsSatellite satellite = this.mSatellites[prn];
            satellite.mValid = true;
            satellite.mSnr = snrs[i];
            satellite.mElevation = elevations[i];
            satellite.mAzimuth = azimuths[i];
            satellite.mHasEphemeris = (ephemerisMask & prnShift) != 0;
            satellite.mHasAlmanac = (almanacMask & prnShift) != 0;
            satellite.mUsedInFix = (usedInFixMask & prnShift) != 0;
        }
    }

    public void setStatus(GpsStatus status) {
        this.mTimeToFirstFix = status.getTimeToFirstFix();
        for (int i = 0; i < this.mSatellites.length; ++i) {
            this.mSatellites[i].setStatus(status.mSatellites[i]);
        }
    }

    public void setTimeToFirstFix(int ttff) {
        this.mTimeToFirstFix = ttff;
    }

    public int getTimeToFirstFix() {
        return this.mTimeToFirstFix;
    }

    public Iterable<GpsSatellite> getSatellites() {
        return this.mSatelliteList;
    }

    public int getMaxSatellites() {
        return 255;
    }

    public static interface NmeaListener {
        public void onNmeaReceived(long var1, String var3);
    }

    public static interface Listener {
        public void onGpsStatusChanged(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SatelliteIterator
    implements Iterator<GpsSatellite> {
        public GpsSatellite[] mSatellites;
        public int mIndex = 0;

        public SatelliteIterator(GpsSatellite[] satellites) {
            this.mSatellites = satellites;
        }

        @Override
        public boolean hasNext() {
            for (int i = this.mIndex; i < this.mSatellites.length; ++i) {
                if (!this.mSatellites[i].mValid) continue;
                return true;
            }
            return false;
        }

        @Override
        public GpsSatellite next() {
            while (this.mIndex < this.mSatellites.length) {
                GpsSatellite satellite = this.mSatellites[this.mIndex++];
                if (!satellite.mValid) continue;
                return satellite;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

