/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.Location;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ILocationListener
extends IInterface {
    public void onLocationChanged(Location var1) throws RemoteException;

    public void onStatusChanged(String var1, int var2, Bundle var3) throws RemoteException;

    public void onProviderEnabled(String var1) throws RemoteException;

    public void onProviderDisabled(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILocationListener {
        public static final String DESCRIPTOR = "android.location.ILocationListener";
        public static final int TRANSACTION_onLocationChanged = 1;
        public static final int TRANSACTION_onStatusChanged = 2;
        public static final int TRANSACTION_onProviderEnabled = 3;
        public static final int TRANSACTION_onProviderDisabled = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ILocationListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ILocationListener) {
                return (ILocationListener)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    Location _arg0 = 0 != data.readInt() ? Location.CREATOR.createFromParcel(data) : null;
                    this.onLocationChanged(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    Bundle _arg2 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.onStatusChanged(_arg0, _arg1, _arg2);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.onProviderEnabled(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.onProviderDisabled(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static class Proxy
        implements ILocationListener {
            public IBinder mRemote;

            public Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onLocationChanged(Location location) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (location != null) {
                        _data.writeInt(1);
                        location.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(1, _data, null, 1);
                    Object var4_3 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onStatusChanged(String provider, int status, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeInt(status);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(2, _data, null, 1);
                    Object var6_5 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onProviderEnabled(String provider) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    this.mRemote.transact(3, _data, null, 1);
                    Object var4_3 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onProviderDisabled(String provider) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    this.mRemote.transact(4, _data, null, 1);
                    Object var4_3 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _data.recycle();
                    throw throwable;
                }
            }
        }
    }
}

