/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.app.PendingIntent;
import android.location.Criteria;
import android.location.GpsStatus;
import android.location.IGeocodeProvider;
import android.location.IGpsStatusListener;
import android.location.ILocationListener;
import android.location.ILocationManager;
import android.location.ILocationProvider;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationProvider;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.location.DummyLocationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationManager {
    public static final String TAG = "LocationManager";
    public ILocationManager mService;
    public final HashMap<GpsStatus.Listener, GpsStatusListenerTransport> mGpsStatusListeners = new HashMap();
    public final HashMap<GpsStatus.NmeaListener, GpsStatusListenerTransport> mNmeaListeners = new HashMap();
    public final GpsStatus mGpsStatus = new GpsStatus();
    public static final String NETWORK_PROVIDER = "network";
    public static final String GPS_PROVIDER = "gps";
    public static final String KEY_PROXIMITY_ENTERING = "entering";
    public static final String KEY_STATUS_CHANGED = "status";
    public static final String KEY_PROVIDER_ENABLED = "providerEnabled";
    public static final String KEY_LOCATION_CHANGED = "location";
    public HashMap<LocationListener, ListenerTransport> mListeners = new HashMap();

    public LocationManager(ILocationManager service) {
        Log.d(TAG, "Constructor: service = " + service);
        this.mService = service;
    }

    public LocationProvider createProvider(String name, Bundle info) {
        DummyLocationProvider provider = new DummyLocationProvider(name);
        provider.setRequiresNetwork(info.getBoolean(NETWORK_PROVIDER));
        provider.setRequiresSatellite(info.getBoolean("satellite"));
        provider.setRequiresCell(info.getBoolean("cell"));
        provider.setHasMonetaryCost(info.getBoolean("cost"));
        provider.setSupportsAltitude(info.getBoolean("altitude"));
        provider.setSupportsSpeed(info.getBoolean("speed"));
        provider.setSupportsBearing(info.getBoolean("bearing"));
        provider.setPowerRequirement(info.getInt("power"));
        provider.setAccuracy(info.getInt("accuracy"));
        return provider;
    }

    public List<String> getAllProviders() {
        Log.d(TAG, "getAllProviders");
        try {
            return this.mService.getAllProviders();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "getAllProviders: RemoteException", ex);
            return null;
        }
    }

    public List<String> getProviders(boolean enabledOnly) {
        try {
            return this.mService.getProviders(enabledOnly);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "getProviders: RemoteException", ex);
            return null;
        }
    }

    public LocationProvider getProvider(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        try {
            Bundle info = this.mService.getProviderInfo(name);
            if (info == null) {
                return null;
            }
            return this.createProvider(name, info);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "getProvider: RemoteException", ex);
            return null;
        }
    }

    public List<String> getProviders(Criteria criteria, boolean enabledOnly) {
        List<String> goodProviders = Collections.emptyList();
        List<String> providers = this.getProviders(enabledOnly);
        for (String providerName : providers) {
            LocationProvider provider = this.getProvider(providerName);
            if (!provider.meetsCriteria(criteria)) continue;
            if (goodProviders.isEmpty()) {
                goodProviders = new ArrayList<String>();
            }
            goodProviders.add(providerName);
        }
        return goodProviders;
    }

    public int nextPower(int power) {
        switch (power) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    public int nextAccuracy(int accuracy) {
        if (accuracy == 1) {
            return 2;
        }
        return 0;
    }

    public LocationProvider best(List<String> providerNames) {
        int idx;
        ArrayList<LocationProvider> providers = new ArrayList<LocationProvider>(providerNames.size());
        for (String name : providerNames) {
            providers.add(this.getProvider(name));
        }
        if (providers.size() < 2) {
            return (LocationProvider)providers.get(0);
        }
        Collections.sort(providers, new LpPowerComparator(null));
        int power = ((LocationProvider)providers.get(0)).getPowerRequirement();
        if (power < ((LocationProvider)providers.get(1)).getPowerRequirement()) {
            return (LocationProvider)providers.get(0);
        }
        ArrayList tmp = new ArrayList();
        int size = providers.size();
        for (idx = 0; idx < size && ((LocationProvider)providers.get(idx)).getPowerRequirement() == power; ++idx) {
            tmp.add(providers.get(idx));
        }
        Collections.sort(tmp, new LpAccuracyComparator(null));
        int acc = ((LocationProvider)tmp.get(0)).getAccuracy();
        if (acc < ((LocationProvider)tmp.get(1)).getAccuracy()) {
            return (LocationProvider)tmp.get(0);
        }
        ArrayList tmp2 = new ArrayList();
        size = tmp.size();
        for (idx = 0; idx < size && ((LocationProvider)tmp.get(idx)).getAccuracy() == acc; ++idx) {
            tmp2.add(tmp.get(idx));
        }
        Collections.sort(tmp2, new LpCapabilityComparator(null));
        return (LocationProvider)tmp2.get(0);
    }

    public String getBestProvider(Criteria criteria, boolean enabledOnly) {
        List<String> goodProviders = this.getProviders(criteria, enabledOnly);
        if (!goodProviders.isEmpty()) {
            return this.best(goodProviders).getName();
        }
        criteria = new Criteria(criteria);
        int power = criteria.getPowerRequirement();
        while (goodProviders.isEmpty() && power != 0) {
            power = this.nextPower(power);
            criteria.setPowerRequirement(power);
            goodProviders = this.getProviders(criteria, enabledOnly);
        }
        if (!goodProviders.isEmpty()) {
            return this.best(goodProviders).getName();
        }
        int accuracy = criteria.getAccuracy();
        while (goodProviders.isEmpty() && accuracy != 0) {
            accuracy = this.nextAccuracy(accuracy);
            criteria.setAccuracy(accuracy);
            goodProviders = this.getProviders(criteria, enabledOnly);
        }
        if (!goodProviders.isEmpty()) {
            return this.best(goodProviders).getName();
        }
        criteria.setBearingRequired(false);
        goodProviders = this.getProviders(criteria, enabledOnly);
        if (!goodProviders.isEmpty()) {
            return this.best(goodProviders).getName();
        }
        criteria.setSpeedRequired(false);
        goodProviders = this.getProviders(criteria, enabledOnly);
        if (!goodProviders.isEmpty()) {
            return this.best(goodProviders).getName();
        }
        criteria.setAltitudeRequired(false);
        goodProviders = this.getProviders(criteria, enabledOnly);
        if (!goodProviders.isEmpty()) {
            return this.best(goodProviders).getName();
        }
        return null;
    }

    public void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener) {
        if (provider == null) {
            throw new IllegalArgumentException("provider==null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        this._requestLocationUpdates(provider, minTime, minDistance, listener, null);
    }

    public void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener, Looper looper) {
        if (provider == null) {
            throw new IllegalArgumentException("provider==null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        if (looper == null) {
            throw new IllegalArgumentException("looper==null");
        }
        this._requestLocationUpdates(provider, minTime, minDistance, listener, looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener, Looper looper) {
        if (minTime < 0L) {
            minTime = 0L;
        }
        if (minDistance < 0.0f) {
            minDistance = 0.0f;
        }
        try {
            HashMap<LocationListener, ListenerTransport> hashMap = this.mListeners;
            synchronized (hashMap) {
                ListenerTransport transport = this.mListeners.get(listener);
                if (transport == null) {
                    transport = new ListenerTransport(listener, looper);
                }
                this.mListeners.put(listener, transport);
                this.mService.requestLocationUpdates(provider, minTime, minDistance, transport);
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "requestLocationUpdates: DeadObjectException", ex);
        }
    }

    public void requestLocationUpdates(String provider, long minTime, float minDistance, PendingIntent intent) {
        if (provider == null) {
            throw new IllegalArgumentException("provider==null");
        }
        if (intent == null) {
            throw new IllegalArgumentException("intent==null");
        }
        this._requestLocationUpdates(provider, minTime, minDistance, intent);
    }

    public void _requestLocationUpdates(String provider, long minTime, float minDistance, PendingIntent intent) {
        if (minTime < 0L) {
            minTime = 0L;
        }
        if (minDistance < 0.0f) {
            minDistance = 0.0f;
        }
        try {
            this.mService.requestLocationUpdatesPI(provider, minTime, minDistance, intent);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "requestLocationUpdates: RemoteException", ex);
        }
    }

    public void removeUpdates(LocationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        Log.d(TAG, "removeUpdates: listener = " + listener);
        try {
            ListenerTransport transport = this.mListeners.remove(listener);
            if (transport != null) {
                this.mService.removeUpdates(transport);
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "removeUpdates: DeadObjectException", ex);
        }
    }

    public void removeUpdates(PendingIntent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("intent==null");
        }
        Log.d(TAG, "removeUpdates: intent = " + intent);
        try {
            this.mService.removeUpdatesPI(intent);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "removeUpdates: RemoteException", ex);
        }
    }

    public void addProximityAlert(double latitude, double longitude, float radius, long expiration, PendingIntent intent) {
        Log.d(TAG, "addProximityAlert: latitude = " + latitude + ", longitude = " + longitude + ", radius = " + radius + ", expiration = " + expiration + ", intent = " + intent);
        try {
            this.mService.addProximityAlert(latitude, longitude, radius, expiration, intent);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "addProximityAlert: RemoteException", ex);
        }
    }

    public void removeProximityAlert(PendingIntent intent) {
        Log.d(TAG, "removeProximityAlert: intent = " + intent);
        try {
            this.mService.removeProximityAlert(intent);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "removeProximityAlert: RemoteException", ex);
        }
    }

    public boolean isProviderEnabled(String provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider==null");
        }
        try {
            return this.mService.isProviderEnabled(provider);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "isProviderEnabled: RemoteException", ex);
            return false;
        }
    }

    public Location getLastKnownLocation(String provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider==null");
        }
        try {
            return this.mService.getLastKnownLocation(provider);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "getLastKnowLocation: RemoteException", ex);
            return null;
        }
    }

    public void addTestProvider(String name, boolean requiresNetwork, boolean requiresSatellite, boolean requiresCell, boolean hasMonetaryCost, boolean supportsAltitude, boolean supportsSpeed, boolean supportsBearing, int powerRequirement, int accuracy) {
        try {
            this.mService.addTestProvider(name, requiresNetwork, requiresSatellite, requiresCell, hasMonetaryCost, supportsAltitude, supportsSpeed, supportsBearing, powerRequirement, accuracy);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "addTestProvider: RemoteException", ex);
        }
    }

    public void removeTestProvider(String provider) {
        try {
            this.mService.removeTestProvider(provider);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "removeTestProvider: RemoteException", ex);
        }
    }

    public void setTestProviderLocation(String provider, Location loc) {
        try {
            this.mService.setTestProviderLocation(provider, loc);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "setTestProviderLocation: RemoteException", ex);
        }
    }

    public void clearTestProviderLocation(String provider) {
        try {
            this.mService.clearTestProviderLocation(provider);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "clearTestProviderLocation: RemoteException", ex);
        }
    }

    public void setTestProviderEnabled(String provider, boolean enabled) {
        try {
            this.mService.setTestProviderEnabled(provider, enabled);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "setTestProviderEnabled: RemoteException", ex);
        }
    }

    public void clearTestProviderEnabled(String provider) {
        try {
            this.mService.clearTestProviderEnabled(provider);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "clearTestProviderEnabled: RemoteException", ex);
        }
    }

    public void setTestProviderStatus(String provider, int status, Bundle extras, long updateTime) {
        try {
            this.mService.setTestProviderStatus(provider, status, extras, updateTime);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "setTestProviderStatus: RemoteException", ex);
        }
    }

    public void clearTestProviderStatus(String provider) {
        try {
            this.mService.clearTestProviderStatus(provider);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "clearTestProviderStatus: RemoteException", ex);
        }
    }

    public boolean addGpsStatusListener(GpsStatus.Listener listener) {
        boolean result;
        if (this.mGpsStatusListeners.get(listener) != null) {
            return true;
        }
        try {
            GpsStatusListenerTransport transport = new GpsStatusListenerTransport(listener);
            result = this.mService.addGpsStatusListener(transport);
            if (result) {
                this.mGpsStatusListeners.put(listener, transport);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in registerGpsStatusListener: ", e);
            result = false;
        }
        return result;
    }

    public void removeGpsStatusListener(GpsStatus.Listener listener) {
        try {
            GpsStatusListenerTransport transport = this.mGpsStatusListeners.remove(listener);
            if (transport != null) {
                this.mService.removeGpsStatusListener(transport);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in unregisterGpsStatusListener: ", e);
        }
    }

    public boolean addNmeaListener(GpsStatus.NmeaListener listener) {
        boolean result;
        if (this.mNmeaListeners.get(listener) != null) {
            return true;
        }
        try {
            GpsStatusListenerTransport transport = new GpsStatusListenerTransport(listener);
            result = this.mService.addGpsStatusListener(transport);
            if (result) {
                this.mNmeaListeners.put(listener, transport);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in registerGpsStatusListener: ", e);
            result = false;
        }
        return result;
    }

    public void removeNmeaListener(GpsStatus.NmeaListener listener) {
        try {
            GpsStatusListenerTransport transport = this.mNmeaListeners.remove(listener);
            if (transport != null) {
                this.mService.removeGpsStatusListener(transport);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in unregisterGpsStatusListener: ", e);
        }
    }

    public GpsStatus getGpsStatus(GpsStatus status) {
        if (status == null) {
            status = new GpsStatus();
        }
        status.setStatus(this.mGpsStatus);
        return status;
    }

    public boolean sendExtraCommand(String provider, String command, Bundle extras) {
        try {
            return this.mService.sendExtraCommand(provider, command, extras);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in sendExtraCommand: ", e);
            return false;
        }
    }

    public boolean installLocationProvider(String name, ILocationProvider provider) {
        try {
            this.mService.installLocationProvider(name, provider);
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in installLocationProvider: ", e);
            return false;
        }
    }

    public boolean installGeocodeProvider(IGeocodeProvider provider) {
        try {
            this.mService.installGeocodeProvider(provider);
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in setGeocodeProvider: ", e);
            return false;
        }
    }

    public void reportLocation(Location location) {
        try {
            this.mService.reportLocation(location);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in reportLocation: ", e);
        }
    }

    public boolean sendNiResponse(int notifId, int userResponse) {
        try {
            return this.mService.sendNiResponse(notifId, userResponse);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in sendNiResponse: ", e);
            return false;
        }
    }

    public static class 1 {
    }

    public class GpsStatusListenerTransport
    extends IGpsStatusListener.Stub {
        public final GpsStatus.Listener mListener;
        public final GpsStatus.NmeaListener mNmeaListener;
        public static final int NMEA_RECEIVED = 1000;
        public ArrayList<Nmea> mNmeaBuffer;
        public final Handler mGpsHandler = new Handler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                if (msg.what == 1000) {
                    ArrayList arrayList = GpsStatusListenerTransport.this.mNmeaBuffer;
                    synchronized (arrayList) {
                        int length = GpsStatusListenerTransport.this.mNmeaBuffer.size();
                        for (int i = 0; i < length; ++i) {
                            Nmea nmea = (Nmea)GpsStatusListenerTransport.this.mNmeaBuffer.get(i);
                            GpsStatusListenerTransport.this.mNmeaListener.onNmeaReceived(nmea.mTimestamp, nmea.mNmea);
                        }
                        GpsStatusListenerTransport.this.mNmeaBuffer.clear();
                    }
                }
                GpsStatus gpsStatus = LocationManager.this.mGpsStatus;
                synchronized (gpsStatus) {
                    GpsStatusListenerTransport.this.mListener.onGpsStatusChanged(msg.what);
                }
            }
        };

        public GpsStatusListenerTransport(GpsStatus.Listener listener) {
            this.mListener = listener;
            this.mNmeaListener = null;
        }

        public GpsStatusListenerTransport(GpsStatus.NmeaListener listener) {
            this.mNmeaListener = listener;
            this.mListener = null;
            this.mNmeaBuffer = new ArrayList();
        }

        public void onGpsStarted() {
            if (this.mListener != null) {
                Message msg = Message.obtain();
                msg.what = 1;
                this.mGpsHandler.sendMessage(msg);
            }
        }

        public void onGpsStopped() {
            if (this.mListener != null) {
                Message msg = Message.obtain();
                msg.what = 2;
                this.mGpsHandler.sendMessage(msg);
            }
        }

        public void onFirstFix(int ttff) {
            if (this.mListener != null) {
                LocationManager.this.mGpsStatus.setTimeToFirstFix(ttff);
                Message msg = Message.obtain();
                msg.what = 3;
                this.mGpsHandler.sendMessage(msg);
            }
        }

        public void onSvStatusChanged(int svCount, int[] prns, float[] snrs, float[] elevations, float[] azimuths, int ephemerisMask, int almanacMask, int usedInFixMask) {
            if (this.mListener != null) {
                LocationManager.this.mGpsStatus.setStatus(svCount, prns, snrs, elevations, azimuths, ephemerisMask, almanacMask, usedInFixMask);
                Message msg = Message.obtain();
                msg.what = 4;
                this.mGpsHandler.removeMessages(4);
                this.mGpsHandler.sendMessage(msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNmeaReceived(long timestamp, String nmea) {
            if (this.mNmeaListener != null) {
                ArrayList<Nmea> arrayList = this.mNmeaBuffer;
                synchronized (arrayList) {
                    this.mNmeaBuffer.add(new Nmea(timestamp, nmea));
                }
                Message msg = Message.obtain();
                msg.what = 1000;
                this.mGpsHandler.removeMessages(1000);
                this.mGpsHandler.sendMessage(msg);
            }
        }

        public class Nmea {
            public long mTimestamp;
            public String mNmea;

            public Nmea(long timestamp, String nmea) {
                this.mTimestamp = timestamp;
                this.mNmea = nmea;
            }
        }
    }

    public class LpCapabilityComparator
    extends LpComparator {
        public static final int ALTITUDE_SCORE = 4;
        public static final int BEARING_SCORE = 4;
        public static final int SPEED_SCORE = 4;

        public LpCapabilityComparator() {
            super(null);
        }

        public int score(LocationProvider p) {
            return (p.supportsAltitude() ? 4 : 0) + (p.supportsBearing() ? 4 : 0) + (p.supportsSpeed() ? 4 : 0);
        }

        public int compare(LocationProvider l1, LocationProvider l2) {
            int a1 = this.score(l1);
            int a2 = this.score(l2);
            return this.compare(-a1, -a2);
        }

        public boolean equals(LocationProvider l1, LocationProvider l2) {
            int a2;
            int a1 = this.score(l1);
            return a1 == (a2 = this.score(l2));
        }

        public /* synthetic */ LpCapabilityComparator(1 x1) {
            this();
        }
    }

    public class LpAccuracyComparator
    extends LpComparator {
        public LpAccuracyComparator() {
            super(null);
        }

        public int compare(LocationProvider l1, LocationProvider l2) {
            int a1 = l1.getAccuracy();
            int a2 = l2.getAccuracy();
            return this.compare(a1, a2);
        }

        public boolean equals(LocationProvider l1, LocationProvider l2) {
            int a2;
            int a1 = l1.getAccuracy();
            return a1 == (a2 = l2.getAccuracy());
        }

        public /* synthetic */ LpAccuracyComparator(1 x1) {
            this();
        }
    }

    public class LpPowerComparator
    extends LpComparator {
        public LpPowerComparator() {
            super(null);
        }

        public int compare(LocationProvider l1, LocationProvider l2) {
            int a1 = l1.getPowerRequirement();
            int a2 = l2.getPowerRequirement();
            return this.compare(a1, a2);
        }

        public boolean equals(LocationProvider l1, LocationProvider l2) {
            int a2;
            int a1 = l1.getPowerRequirement();
            return a1 == (a2 = l2.getPowerRequirement());
        }

        public /* synthetic */ LpPowerComparator(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class LpComparator
    implements Comparator<LocationProvider> {
        public LpComparator() {
        }

        @Override
        public int compare(int a1, int a2) {
            if (a1 < a2) {
                return -1;
            }
            if (a1 > a2) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compare(float a1, float a2) {
            if (a1 < a2) {
                return -1;
            }
            if (a1 > a2) {
                return 1;
            }
            return 0;
        }

        public /* synthetic */ LpComparator(1 x1) {
            this();
        }
    }

    public class ListenerTransport
    extends ILocationListener.Stub {
        public static final int TYPE_LOCATION_CHANGED = 1;
        public static final int TYPE_STATUS_CHANGED = 2;
        public static final int TYPE_PROVIDER_ENABLED = 3;
        public static final int TYPE_PROVIDER_DISABLED = 4;
        public LocationListener mListener;
        public final Handler mListenerHandler;

        public ListenerTransport(LocationListener listener, Looper looper) {
            this.mListener = listener;
            this.mListenerHandler = looper == null ? new Handler(){

                public void handleMessage(Message msg) {
                    ListenerTransport.this._handleMessage(msg);
                }
            } : new Handler(looper){

                public void handleMessage(Message msg) {
                    ListenerTransport.this._handleMessage(msg);
                }
            };
        }

        public void onLocationChanged(Location location) {
            Message msg = Message.obtain();
            msg.what = 1;
            msg.obj = location;
            this.mListenerHandler.sendMessage(msg);
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            Message msg = Message.obtain();
            msg.what = 2;
            Bundle b = new Bundle();
            b.putString("provider", provider);
            b.putInt(LocationManager.KEY_STATUS_CHANGED, status);
            if (extras != null) {
                b.putBundle("extras", extras);
            }
            msg.obj = b;
            this.mListenerHandler.sendMessage(msg);
        }

        public void onProviderEnabled(String provider) {
            Message msg = Message.obtain();
            msg.what = 3;
            msg.obj = provider;
            this.mListenerHandler.sendMessage(msg);
        }

        public void onProviderDisabled(String provider) {
            Message msg = Message.obtain();
            msg.what = 4;
            msg.obj = provider;
            this.mListenerHandler.sendMessage(msg);
        }

        public void _handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Location location = new Location((Location)msg.obj);
                    this.mListener.onLocationChanged(location);
                    break;
                }
                case 2: {
                    Bundle b = (Bundle)msg.obj;
                    String provider = b.getString("provider");
                    int status = b.getInt(LocationManager.KEY_STATUS_CHANGED);
                    Bundle extras = b.getBundle("extras");
                    this.mListener.onStatusChanged(provider, status, extras);
                    break;
                }
                case 3: {
                    this.mListener.onProviderEnabled((String)msg.obj);
                    break;
                }
                case 4: {
                    this.mListener.onProviderDisabled((String)msg.obj);
                }
            }
            try {
                LocationManager.this.mService.locationCallbackFinished(this);
            }
            catch (RemoteException e) {
                Log.e(LocationManager.TAG, "locationCallbackFinished: RemoteException", e);
            }
        }
    }
}

