/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SystemProperties;
import java.io.File;

public class Environment {
    public static final File ROOT_DIRECTORY = Environment.getDirectory("ANDROID_ROOT", "/system");
    public static final File DATA_DIRECTORY = Environment.getDirectory("ANDROID_DATA", "/data");
    public static final File EXTERNAL_STORAGE_DIRECTORY = Environment.getDirectory("EXTERNAL_STORAGE", "/sdcard");
    public static final File DOWNLOAD_CACHE_DIRECTORY = Environment.getDirectory("DOWNLOAD_CACHE", "/cache");
    public static final String MEDIA_REMOVED = "removed";
    public static final String MEDIA_UNMOUNTED = "unmounted";
    public static final String MEDIA_CHECKING = "checking";
    public static final String MEDIA_NOFS = "nofs";
    public static final String MEDIA_MOUNTED = "mounted";
    public static final String MEDIA_MOUNTED_READ_ONLY = "mounted_ro";
    public static final String MEDIA_SHARED = "shared";
    public static final String MEDIA_BAD_REMOVAL = "bad_removal";
    public static final String MEDIA_UNMOUNTABLE = "unmountable";

    public static File getRootDirectory() {
        return ROOT_DIRECTORY;
    }

    public static File getDataDirectory() {
        return DATA_DIRECTORY;
    }

    public static File getExternalStorageDirectory() {
        return EXTERNAL_STORAGE_DIRECTORY;
    }

    public static File getDownloadCacheDirectory() {
        return DOWNLOAD_CACHE_DIRECTORY;
    }

    public static String getExternalStorageState() {
        return SystemProperties.get("EXTERNAL_STORAGE_STATE", MEDIA_REMOVED);
    }

    public static File getDirectory(String variableName, String defaultPath) {
        String path = System.getenv(variableName);
        return path == null ? new File(defaultPath) : new File(path);
    }
}

