/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.HandlerState;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.util.LogPrinter;

public class HandlerStateMachine {
    public boolean mDbg = false;
    public static final String TAG = "HandlerStateMachine";
    public String mName;
    public SmHandler mHandler;
    public HandlerThread mHandlerThread;

    public HandlerStateMachine(String name) {
        this.mName = name;
        this.mHandlerThread = new HandlerThread(name);
        this.mHandlerThread.start();
        this.mHandler = new SmHandler(this.mHandlerThread.getLooper());
    }

    public Message obtainMessage() {
        Message msg = Message.obtain(this.mHandler);
        if (this.mDbg) {
            Log.d(TAG, "StateMachine.obtainMessage() EX target=" + msg.target);
        }
        return msg;
    }

    public Message obtainMessage(int what) {
        Message msg = Message.obtain((Handler)this.mHandler, what);
        if (this.mDbg) {
            Log.d(TAG, "StateMachine.obtainMessage(what) EX what=" + msg.what + " target=" + msg.target);
        }
        return msg;
    }

    public void sendMessage(Message msg) {
        if (this.mDbg) {
            Log.d(TAG, "StateMachine.sendMessage EX msg.what=" + msg.what);
        }
        this.mHandler.sendMessage(msg);
    }

    public void sendMessageDelayed(Message msg, long delayMillis) {
        if (this.mDbg) {
            Log.d(TAG, "StateMachine.sendMessageDelayed EX msg.what=" + msg.what + " delay=" + delayMillis);
        }
        this.mHandler.sendMessageDelayed(msg, delayMillis);
    }

    public void setInitialState(HandlerState initialState) {
        if (this.mDbg) {
            Log.d(TAG, "StateMachine.setInitialState EX initialState" + initialState.getClass().getName());
        }
        this.mHandler.mDestState = initialState;
    }

    public void transitionTo(HandlerState destState) {
        if (this.mDbg) {
            Log.d(TAG, "StateMachine.transitionTo EX destState" + destState.getClass().getName());
        }
        this.mHandler.mDestState = destState;
    }

    public void deferMessage(Message msg) {
        if (this.mDbg) {
            Log.d(TAG, "StateMachine.deferMessage EX mDeferredMessages=" + this.mHandler.mDeferredMessages);
        }
        Message newMsg = this.obtainMessage();
        newMsg.copyFrom(msg);
        newMsg.next = this.mHandler.mDeferredMessages;
        this.mHandler.mDeferredMessages = newMsg;
    }

    public String getName() {
        return this.mName;
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public boolean isDbg() {
        return this.mDbg;
    }

    public void setDbg(boolean dbg) {
        this.mDbg = dbg;
        if (this.mDbg) {
            this.mHandlerThread.getLooper().setMessageLogging(new LogPrinter(2, TAG));
        } else {
            this.mHandlerThread.getLooper().setMessageLogging(null);
        }
    }

    public class SmHandler
    extends Handler {
        public HandlerState mCurrentState;
        public HandlerState mDestState;
        public Message mDeferredMessages;

        public SmHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (HandlerStateMachine.this.mDbg) {
                Log.d(HandlerStateMachine.TAG, "SmHandler.handleMessage E");
            }
            if (this.mDestState != null) {
                if (HandlerStateMachine.this.mDbg) {
                    Log.d(HandlerStateMachine.TAG, "SmHandler.handleMessage; new destation call enter");
                }
                this.mCurrentState = this.mDestState;
                this.mDestState = null;
                this.mCurrentState.enter(msg);
            }
            if (this.mCurrentState != null) {
                if (HandlerStateMachine.this.mDbg) {
                    Log.d(HandlerStateMachine.TAG, "SmHandler.handleMessage; call processMessage");
                }
                this.mCurrentState.processMessage(msg);
            } else {
                Log.e(HandlerStateMachine.TAG, "handleMessage: no current state, did you call setInitialState");
            }
            if (this.mDestState != null) {
                if (HandlerStateMachine.this.mDbg) {
                    Log.d(HandlerStateMachine.TAG, "SmHandler.handleMessage; new destination call exit");
                }
                this.mCurrentState.exit(msg);
                while (this.mDeferredMessages != null) {
                    Message cur = this.mDeferredMessages;
                    this.mDeferredMessages = this.mDeferredMessages.next;
                    cur.when = 0L;
                    if (HandlerStateMachine.this.mDbg) {
                        Log.d(HandlerStateMachine.TAG, "SmHandler.handleMessage; queue deferred message what=" + cur.what + " target=" + cur.target);
                    }
                    this.sendMessageAtFrontOfQueue(cur);
                }
                if (HandlerStateMachine.this.mDbg) {
                    Log.d(HandlerStateMachine.TAG, "SmHandler.handleMessage X");
                }
            }
        }
    }
}

