/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Message;
import android.os.MessageQueue;
import android.os.Process;
import android.util.Printer;

public class Looper {
    public static final boolean DEBUG = false;
    public static final boolean localLOGV = false;
    public static final ThreadLocal sThreadLocal = new ThreadLocal();
    public final MessageQueue mQueue = new MessageQueue();
    public volatile boolean mRun = true;
    public Thread mThread = Thread.currentThread();
    public Printer mLogging = null;
    public static Looper mMainLooper = null;

    public static void prepare() {
        if (sThreadLocal.get() != null) {
            throw new RuntimeException("Only one Looper may be created per thread");
        }
        sThreadLocal.set(new Looper());
    }

    public static void prepareMainLooper() {
        Looper.prepare();
        Looper.setMainLooper(Looper.myLooper());
        if (Process.supportsProcesses()) {
            Looper.myLooper().mQueue.mQuitAllowed = false;
        }
    }

    public static synchronized void setMainLooper(Looper looper) {
        mMainLooper = looper;
    }

    public static synchronized Looper getMainLooper() {
        return mMainLooper;
    }

    public static void loop() {
        Looper me = Looper.myLooper();
        MessageQueue queue = me.mQueue;
        while (true) {
            Message msg;
            if ((msg = queue.next()) == null) {
                continue;
            }
            if (msg.target == null) {
                return;
            }
            if (me.mLogging != null) {
                me.mLogging.println(">>>>> Dispatching to " + msg.target + " " + msg.callback + ": " + msg.what);
            }
            msg.target.dispatchMessage(msg);
            if (me.mLogging != null) {
                me.mLogging.println("<<<<< Finished to    " + msg.target + " " + msg.callback);
            }
            msg.recycle();
        }
    }

    public static Looper myLooper() {
        return (Looper)sThreadLocal.get();
    }

    public void setMessageLogging(Printer printer) {
        this.mLogging = printer;
    }

    public static MessageQueue myQueue() {
        return Looper.myLooper().mQueue;
    }

    public void quit() {
        Message msg = Message.obtain();
        this.mQueue.enqueueMessage(msg, 0L);
    }

    public Thread getThread() {
        return this.mThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Printer pw, String prefix) {
        pw.println(prefix + this);
        pw.println(prefix + "mRun=" + this.mRun);
        pw.println(prefix + "mThread=" + this.mThread);
        pw.println(prefix + "mQueue=" + (this.mQueue != null ? this.mQueue : "(null"));
        if (this.mQueue != null) {
            MessageQueue messageQueue = this.mQueue;
            synchronized (messageQueue) {
                Message msg = this.mQueue.mMessages;
                int n = 0;
                while (msg != null) {
                    pw.println(prefix + "  Message " + n + ": " + msg);
                    ++n;
                    msg = msg.next;
                }
                pw.println(prefix + "(Total messages: " + n + ")");
            }
        }
    }

    public String toString() {
        return "Looper{" + Integer.toHexString(System.identityHashCode(this)) + "}";
    }

    public static class HandlerException
    extends Exception {
        public HandlerException(Message message, Throwable cause) {
            super(HandlerException.createMessage(cause), cause);
        }

        public static String createMessage(Throwable cause) {
            String causeMsg = cause.getMessage();
            if (causeMsg == null) {
                causeMsg = cause.toString();
            }
            return causeMsg;
        }
    }
}

