/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;

public class Message
implements Parcelable {
    public int what;
    public int arg1;
    public int arg2;
    public Object obj;
    public Messenger replyTo;
    public long when;
    public Bundle data;
    public Handler target;
    public Runnable callback;
    public Message next;
    public static Object mPoolSync = new Object();
    public static Message mPool;
    public static int mPoolSize;
    public static final int MAX_POOL_SIZE = 10;
    public static final Parcelable.Creator<Message> CREATOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message obtain() {
        Object object = mPoolSync;
        synchronized (object) {
            if (mPool != null) {
                Message m = mPool;
                mPool = m.next;
                m.next = null;
                return m;
            }
        }
        return new Message();
    }

    public static Message obtain(Message orig) {
        Message m = Message.obtain();
        m.what = orig.what;
        m.arg1 = orig.arg1;
        m.arg2 = orig.arg2;
        m.obj = orig.obj;
        m.replyTo = orig.replyTo;
        if (orig.data != null) {
            m.data = new Bundle(orig.data);
        }
        m.target = orig.target;
        m.callback = orig.callback;
        return m;
    }

    public static Message obtain(Handler h) {
        Message m = Message.obtain();
        m.target = h;
        return m;
    }

    public static Message obtain(Handler h, Runnable callback) {
        Message m = Message.obtain();
        m.target = h;
        m.callback = callback;
        return m;
    }

    public static Message obtain(Handler h, int what) {
        Message m = Message.obtain();
        m.target = h;
        m.what = what;
        return m;
    }

    public static Message obtain(Handler h, int what, Object obj) {
        Message m = Message.obtain();
        m.target = h;
        m.what = what;
        m.obj = obj;
        return m;
    }

    public static Message obtain(Handler h, int what, int arg1, int arg2) {
        Message m = Message.obtain();
        m.target = h;
        m.what = what;
        m.arg1 = arg1;
        m.arg2 = arg2;
        return m;
    }

    public static Message obtain(Handler h, int what, int arg1, int arg2, Object obj) {
        Message m = Message.obtain();
        m.target = h;
        m.what = what;
        m.arg1 = arg1;
        m.arg2 = arg2;
        m.obj = obj;
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Object object = mPoolSync;
        synchronized (object) {
            if (mPoolSize < 10) {
                this.clearForRecycle();
                this.next = mPool;
                mPool = this;
            }
        }
    }

    public void copyFrom(Message o) {
        this.what = o.what;
        this.arg1 = o.arg1;
        this.arg2 = o.arg2;
        this.obj = o.obj;
        this.replyTo = o.replyTo;
        this.data = o.data != null ? (Bundle)o.data.clone() : null;
    }

    public long getWhen() {
        return this.when;
    }

    public void setTarget(Handler target) {
        this.target = target;
    }

    public Handler getTarget() {
        return this.target;
    }

    public Runnable getCallback() {
        return this.callback;
    }

    public Bundle getData() {
        if (this.data == null) {
            this.data = new Bundle();
        }
        return this.data;
    }

    public Bundle peekData() {
        return this.data;
    }

    public void setData(Bundle data) {
        this.data = data;
    }

    public void sendToTarget() {
        this.target.sendMessage(this);
    }

    public void clearForRecycle() {
        this.what = 0;
        this.arg1 = 0;
        this.arg2 = 0;
        this.obj = null;
        this.replyTo = null;
        this.when = 0L;
        this.target = null;
        this.callback = null;
        this.data = null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{ what=");
        b.append(this.what);
        b.append(" when=");
        b.append(this.when);
        if (this.arg1 != 0) {
            b.append(" arg1=");
            b.append(this.arg1);
        }
        if (this.arg2 != 0) {
            b.append(" arg2=");
            b.append(this.arg2);
        }
        if (this.obj != null) {
            b.append(" obj=");
            b.append(this.obj);
        }
        b.append(" }");
        return b.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.obj != null || this.callback != null) {
            throw new RuntimeException("Can't marshal objects across processes.");
        }
        dest.writeInt(this.what);
        dest.writeInt(this.arg1);
        dest.writeInt(this.arg2);
        dest.writeLong(this.when);
        dest.writeBundle(this.data);
        Messenger.writeMessengerOrNullToParcel(this.replyTo, dest);
    }

    public void readFromParcel(Parcel source) {
        this.what = source.readInt();
        this.arg1 = source.readInt();
        this.arg2 = source.readInt();
        this.when = source.readLong();
        this.data = source.readBundle();
        this.replyTo = Messenger.readMessengerOrNullFromParcel(source);
    }

    static {
        mPoolSize = 0;
        CREATOR = new Parcelable.Creator<Message>(){

            @Override
            public Message createFromParcel(Parcel source) {
                Message msg = Message.obtain();
                msg.readFromParcel(source);
                return msg;
            }

            public Message[] newArray(int size) {
                return new Message[size];
            }
        };
    }
}

