/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IHardwareService;
import android.os.RemoteException;
import android.os.ServiceManager;

public class Vibrator {
    public IHardwareService mService;
    public final Binder mToken = new Binder();

    public Vibrator() {
        this.mService = IHardwareService.Stub.asInterface(ServiceManager.getService("hardware"));
    }

    public void vibrate(long milliseconds) {
        try {
            this.mService.vibrate(milliseconds, this.mToken);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void vibrate(long[] pattern, int repeat) {
        if (repeat < pattern.length) {
            try {
                this.mService.vibratePattern(pattern, repeat, this.mToken);
            }
            catch (RemoteException remoteException) {}
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void cancel() {
        try {
            this.mService.cancelVibrate(this.mToken);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

