/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RenderScript;
import java.lang.reflect.Field;

public class Element
extends BaseObj {
    public int mSize = 0;
    public Entry[] mEntries;

    public int getSizeBytes() {
        return this.mSize;
    }

    public int getComponentCount() {
        return this.mEntries.length;
    }

    public DataType getComponentDataType(int num) {
        return this.mEntries[num].mType;
    }

    public DataKind getComponentDataKind(int num) {
        return this.mEntries[num].mKind;
    }

    public boolean getComponentIsNormalized(int num) {
        return this.mEntries[num].mIsNormalized;
    }

    public int getComponentBits(int num) {
        return this.mEntries[num].mBits;
    }

    public String getComponentName(int num) {
        return this.mEntries[num].mName;
    }

    public static Element USER_U8(RenderScript rs) {
        if (rs.mElement_USER_U8 == null) {
            rs.mElement_USER_U8 = new Element(rs, 1);
            rs.mElement_USER_U8.mEntries[0] = new Entry(DataType.UNSIGNED, DataKind.USER, false, 8, null);
            rs.mElement_USER_U8.init();
        }
        return rs.mElement_USER_U8;
    }

    public static Element USER_I8(RenderScript rs) {
        if (rs.mElement_USER_I8 == null) {
            rs.mElement_USER_I8 = new Element(rs, 1);
            rs.mElement_USER_I8.mEntries[0] = new Entry(DataType.SIGNED, DataKind.USER, false, 8, null);
            rs.mElement_USER_I8.init();
        }
        return rs.mElement_USER_I8;
    }

    public static Element USER_U16(RenderScript rs) {
        if (rs.mElement_USER_U16 == null) {
            rs.mElement_USER_U16 = new Element(rs, 1);
            rs.mElement_USER_U16.mEntries[0] = new Entry(DataType.UNSIGNED, DataKind.USER, false, 16, null);
            rs.mElement_USER_U16.init();
        }
        return rs.mElement_USER_U16;
    }

    public static Element USER_I16(RenderScript rs) {
        if (rs.mElement_USER_I16 == null) {
            rs.mElement_USER_I16 = new Element(rs, 1);
            rs.mElement_USER_I16.mEntries[0] = new Entry(DataType.SIGNED, DataKind.USER, false, 16, null);
            rs.mElement_USER_I16.init();
        }
        return rs.mElement_USER_I16;
    }

    public static Element USER_U32(RenderScript rs) {
        if (rs.mElement_USER_U32 == null) {
            rs.mElement_USER_U32 = new Element(rs, 1);
            rs.mElement_USER_U32.mEntries[0] = new Entry(DataType.UNSIGNED, DataKind.USER, false, 32, null);
            rs.mElement_USER_U32.init();
        }
        return rs.mElement_USER_U32;
    }

    public static Element USER_I32(RenderScript rs) {
        if (rs.mElement_USER_I32 == null) {
            rs.mElement_USER_I32 = new Element(rs, 1);
            rs.mElement_USER_I32.mEntries[0] = new Entry(DataType.SIGNED, DataKind.USER, false, 32, null);
            rs.mElement_USER_I32.init();
        }
        return rs.mElement_USER_I32;
    }

    public static Element USER_F32(RenderScript rs) {
        if (rs.mElement_USER_FLOAT == null) {
            rs.mElement_USER_FLOAT = new Element(rs, 1);
            rs.mElement_USER_FLOAT.mEntries[0] = new Entry(DataType.FLOAT, DataKind.USER, false, 32, null);
            rs.mElement_USER_FLOAT.init();
        }
        return rs.mElement_USER_FLOAT;
    }

    public static Element A_8(RenderScript rs) {
        if (rs.mElement_A_8 == null) {
            rs.mElement_A_8 = new Element(rs, 1);
            rs.mElement_A_8.mEntries[0] = new Entry(DataType.UNSIGNED, DataKind.ALPHA, true, 8, "a");
            rs.mElement_A_8.init();
        }
        return rs.mElement_A_8;
    }

    public static Element RGB_565(RenderScript rs) {
        if (rs.mElement_RGB_565 == null) {
            rs.mElement_RGB_565 = new Element(rs, 3);
            rs.mElement_RGB_565.mEntries[0] = new Entry(DataType.UNSIGNED, DataKind.RED, true, 5, "r");
            rs.mElement_RGB_565.mEntries[1] = new Entry(DataType.UNSIGNED, DataKind.GREEN, true, 6, "g");
            rs.mElement_RGB_565.mEntries[2] = new Entry(DataType.UNSIGNED, DataKind.BLUE, true, 5, "b");
            rs.mElement_RGB_565.init();
        }
        return rs.mElement_RGB_565;
    }

    public static Element RGB_888(RenderScript rs) {
        if (rs.mElement_RGB_888 == null) {
            rs.mElement_RGB_888 = new Element(rs, 3);
            rs.mElement_RGB_888.mEntries[0] = new Entry(DataType.UNSIGNED, DataKind.RED, true, 8, "r");
            rs.mElement_RGB_888.mEntries[1] = new Entry(DataType.UNSIGNED, DataKind.GREEN, true, 8, "g");
            rs.mElement_RGB_888.mEntries[2] = new Entry(DataType.UNSIGNED, DataKind.BLUE, true, 8, "b");
            rs.mElement_RGB_888.init();
        }
        return rs.mElement_RGB_888;
    }

    public static Element RGBA_5551(RenderScript rs) {
        if (rs.mElement_RGBA_5551 == null) {
            rs.mElement_RGBA_5551 = new Element(rs, 4);
            rs.mElement_RGBA_5551.mEntries[0] = new Entry(DataType.UNSIGNED, DataKind.RED, true, 5, "r");
            rs.mElement_RGBA_5551.mEntries[1] = new Entry(DataType.UNSIGNED, DataKind.GREEN, true, 5, "g");
            rs.mElement_RGBA_5551.mEntries[2] = new Entry(DataType.UNSIGNED, DataKind.BLUE, true, 5, "b");
            rs.mElement_RGBA_5551.mEntries[3] = new Entry(DataType.UNSIGNED, DataKind.ALPHA, true, 1, "a");
            rs.mElement_RGBA_5551.init();
        }
        return rs.mElement_RGBA_5551;
    }

    public static Element RGBA_4444(RenderScript rs) {
        if (rs.mElement_RGBA_4444 == null) {
            rs.mElement_RGBA_4444 = new Element(rs, 4);
            rs.mElement_RGBA_4444.mEntries[0] = new Entry(DataType.UNSIGNED, DataKind.RED, true, 4, "r");
            rs.mElement_RGBA_4444.mEntries[1] = new Entry(DataType.UNSIGNED, DataKind.GREEN, true, 4, "g");
            rs.mElement_RGBA_4444.mEntries[2] = new Entry(DataType.UNSIGNED, DataKind.BLUE, true, 4, "b");
            rs.mElement_RGBA_4444.mEntries[3] = new Entry(DataType.UNSIGNED, DataKind.ALPHA, true, 4, "a");
            rs.mElement_RGBA_4444.init();
        }
        return rs.mElement_RGBA_4444;
    }

    public static Element RGBA_8888(RenderScript rs) {
        if (rs.mElement_RGBA_8888 == null) {
            rs.mElement_RGBA_8888 = new Element(rs, 4);
            rs.mElement_RGBA_8888.mEntries[0] = new Entry(DataType.UNSIGNED, DataKind.RED, true, 8, "r");
            rs.mElement_RGBA_8888.mEntries[1] = new Entry(DataType.UNSIGNED, DataKind.GREEN, true, 8, "g");
            rs.mElement_RGBA_8888.mEntries[2] = new Entry(DataType.UNSIGNED, DataKind.BLUE, true, 8, "b");
            rs.mElement_RGBA_8888.mEntries[3] = new Entry(DataType.UNSIGNED, DataKind.ALPHA, true, 8, "a");
            rs.mElement_RGBA_8888.init();
        }
        return rs.mElement_RGBA_8888;
    }

    public static Element INDEX_16(RenderScript rs) {
        if (rs.mElement_INDEX_16 == null) {
            rs.mElement_INDEX_16 = new Element(rs, 1);
            rs.mElement_INDEX_16.mEntries[0] = new Entry(DataType.UNSIGNED, DataKind.INDEX, false, 16, "index");
            rs.mElement_INDEX_16.init();
        }
        return rs.mElement_INDEX_16;
    }

    public static Element XY_F32(RenderScript rs) {
        if (rs.mElement_XY_F32 == null) {
            rs.mElement_XY_F32 = new Element(rs, 2);
            rs.mElement_XY_F32.mEntries[0] = new Entry(DataType.UNSIGNED, DataKind.X, false, 32, "x");
            rs.mElement_XY_F32.mEntries[1] = new Entry(DataType.UNSIGNED, DataKind.Y, false, 32, "y");
            rs.mElement_XY_F32.init();
        }
        return rs.mElement_XY_F32;
    }

    public static Element XYZ_F32(RenderScript rs) {
        if (rs.mElement_XYZ_F32 == null) {
            rs.mElement_XYZ_F32 = new Element(rs, 3);
            rs.mElement_XYZ_F32.mEntries[0] = new Entry(DataType.UNSIGNED, DataKind.X, false, 32, "x");
            rs.mElement_XYZ_F32.mEntries[1] = new Entry(DataType.UNSIGNED, DataKind.Y, false, 32, "y");
            rs.mElement_XYZ_F32.mEntries[2] = new Entry(DataType.UNSIGNED, DataKind.Z, false, 32, "z");
            rs.mElement_XYZ_F32.init();
        }
        return rs.mElement_XYZ_F32;
    }

    public static void initPredefined(RenderScript rs) {
        rs.nInitElements(Element.A_8((RenderScript)rs).mID, Element.RGBA_4444((RenderScript)rs).mID, Element.RGBA_8888((RenderScript)rs).mID, Element.RGB_565((RenderScript)rs).mID);
    }

    public Element(RenderScript rs, int count) {
        super(rs);
        this.mEntries = new Entry[count];
    }

    public void destroy() throws IllegalStateException {
        super.destroy();
    }

    public static Element createFromClass(RenderScript rs, Class c) {
        Field[] fields = c.getFields();
        Builder b = new Builder(rs);
        for (Field f : fields) {
            Class<?> fc = f.getType();
            if (fc == Integer.TYPE) {
                b.add(DataType.SIGNED, DataKind.USER, false, 32, f.getName());
                continue;
            }
            if (fc == Short.TYPE) {
                b.add(DataType.SIGNED, DataKind.USER, false, 16, f.getName());
                continue;
            }
            if (fc == Byte.TYPE) {
                b.add(DataType.SIGNED, DataKind.USER, false, 8, f.getName());
                continue;
            }
            if (fc == Float.TYPE) {
                b.add(DataType.FLOAT, DataKind.USER, false, 32, f.getName());
                continue;
            }
            throw new IllegalArgumentException("Unkown field type");
        }
        return b.create();
    }

    public static synchronized void internalCreate(RenderScript rs, Element e) {
        rs.nElementBegin();
        int bits = 0;
        for (int ct = 0; ct < e.mEntries.length; ++ct) {
            Entry en2 = e.mEntries[ct];
            rs.nElementAdd(en2.mKind.mID, en2.mType.mID, en2.mIsNormalized, en2.mBits, en2.mName);
            bits += en2.mBits;
        }
        e.mID = rs.nElementCreate();
        e.mSize = bits + 7 >> 3;
    }

    public void init() {
        Element.internalCreate(this.mRS, this);
    }

    public static class Builder {
        public RenderScript mRS;
        public Entry[] mEntries;
        public int mEntryCount;

        public Builder(RenderScript rs) {
            this.mRS = rs;
            this.mEntryCount = 0;
            this.mEntries = new Entry[8];
        }

        public void addEntry(Entry e) {
            if (this.mEntries.length >= this.mEntryCount) {
                Entry[] en2 = new Entry[this.mEntryCount + 8];
                System.arraycopy(this.mEntries, 0, en2, 0, this.mEntries.length);
                this.mEntries = en2;
            }
            this.mEntries[this.mEntryCount] = e;
            ++this.mEntryCount;
        }

        public Builder add(DataType dt, DataKind dk, boolean isNormalized, int bits, String name) {
            Entry en2 = new Entry(dt, dk, isNormalized, bits, name);
            this.addEntry(en2);
            return this;
        }

        public Builder add(DataType dt, DataKind dk, boolean isNormalized, int bits) {
            this.add(dt, dk, isNormalized, bits, null);
            return this;
        }

        public Builder addFloat(DataKind dk) {
            this.add(DataType.FLOAT, dk, false, 32, null);
            return this;
        }

        public Builder addFloat(DataKind dk, String name) {
            this.add(DataType.FLOAT, dk, false, 32, name);
            return this;
        }

        public Builder addFloatXY() {
            this.add(DataType.FLOAT, DataKind.X, false, 32, null);
            this.add(DataType.FLOAT, DataKind.Y, false, 32, null);
            return this;
        }

        public Builder addFloatXY(String prefix) {
            this.add(DataType.FLOAT, DataKind.X, false, 32, prefix + "x");
            this.add(DataType.FLOAT, DataKind.Y, false, 32, prefix + "y");
            return this;
        }

        public Builder addFloatXYZ() {
            this.add(DataType.FLOAT, DataKind.X, false, 32, null);
            this.add(DataType.FLOAT, DataKind.Y, false, 32, null);
            this.add(DataType.FLOAT, DataKind.Z, false, 32, null);
            return this;
        }

        public Builder addFloatXYZ(String prefix) {
            this.add(DataType.FLOAT, DataKind.X, false, 32, prefix + "x");
            this.add(DataType.FLOAT, DataKind.Y, false, 32, prefix + "y");
            this.add(DataType.FLOAT, DataKind.Z, false, 32, prefix + "z");
            return this;
        }

        public Builder addFloatST() {
            this.add(DataType.FLOAT, DataKind.S, false, 32, null);
            this.add(DataType.FLOAT, DataKind.T, false, 32, null);
            return this;
        }

        public Builder addFloatST(String prefix) {
            this.add(DataType.FLOAT, DataKind.S, false, 32, prefix + "s");
            this.add(DataType.FLOAT, DataKind.T, false, 32, prefix + "t");
            return this;
        }

        public Builder addFloatNorm() {
            this.add(DataType.FLOAT, DataKind.NX, false, 32, null);
            this.add(DataType.FLOAT, DataKind.NY, false, 32, null);
            this.add(DataType.FLOAT, DataKind.NZ, false, 32, null);
            return this;
        }

        public Builder addFloatNorm(String prefix) {
            this.add(DataType.FLOAT, DataKind.NX, false, 32, prefix + "nx");
            this.add(DataType.FLOAT, DataKind.NY, false, 32, prefix + "ny");
            this.add(DataType.FLOAT, DataKind.NZ, false, 32, prefix + "nz");
            return this;
        }

        public Builder addFloatPointSize() {
            this.add(DataType.FLOAT, DataKind.POINT_SIZE, false, 32, null);
            return this;
        }

        public Builder addFloatPointSize(String prefix) {
            this.add(DataType.FLOAT, DataKind.POINT_SIZE, false, 32, prefix + "pointSize");
            return this;
        }

        public Builder addFloatRGB() {
            this.add(DataType.FLOAT, DataKind.RED, false, 32, null);
            this.add(DataType.FLOAT, DataKind.GREEN, false, 32, null);
            this.add(DataType.FLOAT, DataKind.BLUE, false, 32, null);
            return this;
        }

        public Builder addFloatRGB(String prefix) {
            this.add(DataType.FLOAT, DataKind.RED, false, 32, prefix + "r");
            this.add(DataType.FLOAT, DataKind.GREEN, false, 32, prefix + "g");
            this.add(DataType.FLOAT, DataKind.BLUE, false, 32, prefix + "b");
            return this;
        }

        public Builder addFloatRGBA() {
            this.add(DataType.FLOAT, DataKind.RED, false, 32, null);
            this.add(DataType.FLOAT, DataKind.GREEN, false, 32, null);
            this.add(DataType.FLOAT, DataKind.BLUE, false, 32, null);
            this.add(DataType.FLOAT, DataKind.ALPHA, false, 32, null);
            return this;
        }

        public Builder addFloatRGBA(String prefix) {
            this.add(DataType.FLOAT, DataKind.RED, false, 32, prefix + "r");
            this.add(DataType.FLOAT, DataKind.GREEN, false, 32, prefix + "g");
            this.add(DataType.FLOAT, DataKind.BLUE, false, 32, prefix + "b");
            this.add(DataType.FLOAT, DataKind.ALPHA, false, 32, prefix + "a");
            return this;
        }

        public Builder addUNorm8RGBA() {
            this.add(DataType.UNSIGNED, DataKind.RED, true, 8, null);
            this.add(DataType.UNSIGNED, DataKind.GREEN, true, 8, null);
            this.add(DataType.UNSIGNED, DataKind.BLUE, true, 8, null);
            this.add(DataType.UNSIGNED, DataKind.ALPHA, true, 8, null);
            return this;
        }

        public Builder addUNorm8RGBA(String prefix) {
            this.add(DataType.UNSIGNED, DataKind.RED, true, 8, prefix + "r");
            this.add(DataType.UNSIGNED, DataKind.GREEN, true, 8, prefix + "g");
            this.add(DataType.UNSIGNED, DataKind.BLUE, true, 8, prefix + "b");
            this.add(DataType.UNSIGNED, DataKind.ALPHA, true, 8, prefix + "a");
            return this;
        }

        public Element create() {
            Element e = new Element(this.mRS, this.mEntryCount);
            System.arraycopy(this.mEntries, 0, e.mEntries, 0, this.mEntryCount);
            e.init();
            return e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataKind {
        USER(0),
        RED(1),
        GREEN(2),
        BLUE(3),
        ALPHA(4),
        LUMINANCE(5),
        INTENSITY(6),
        X(7),
        Y(8),
        Z(9),
        W(10),
        S(11),
        T(12),
        Q(13),
        R(14),
        NX(15),
        NY(16),
        NZ(17),
        INDEX(18),
        POINT_SIZE(19);

        public int mID;

        public DataKind(int id2) {
            this.mID = id2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        FLOAT(0),
        UNSIGNED(1),
        SIGNED(2);

        public int mID;

        public DataType(int id2) {
            this.mID = id2;
        }
    }

    public static class Entry {
        public DataType mType;
        public DataKind mKind;
        public boolean mIsNormalized;
        public int mBits;
        public String mName;

        public Entry(DataType dt, DataKind dk, boolean isNorm, int bits, String name) {
            this.mType = dt;
            this.mKind = dk;
            this.mIsNormalized = isNorm;
            this.mBits = bits;
            this.mName = name;
        }
    }
}

