/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RenderScript;

public class Light
extends BaseObj {
    public Light(int id2, RenderScript rs) {
        super(rs);
        this.mID = id2;
    }

    public void setColor(float r, float g, float b) {
        this.mRS.nLightSetColor(this.mID, r, g, b);
    }

    public void setPosition(float x, float y, float z) {
        this.mRS.nLightSetPosition(this.mID, x, y, z);
    }

    public static class Builder {
        public RenderScript mRS;
        public boolean mIsMono;
        public boolean mIsLocal;

        public Builder(RenderScript rs) {
            this.mRS = rs;
            this.mIsMono = false;
            this.mIsLocal = false;
        }

        public void lightSetIsMono(boolean isMono) {
            this.mIsMono = isMono;
        }

        public void lightSetIsLocal(boolean isLocal) {
            this.mIsLocal = isLocal;
        }

        public static synchronized Light internalCreate(RenderScript rs, Builder b) {
            rs.nSamplerBegin();
            rs.nLightSetIsMono(b.mIsMono);
            rs.nLightSetIsLocal(b.mIsLocal);
            int id2 = rs.nLightCreate();
            return new Light(id2, rs);
        }

        public Light create() {
            return Builder.internalCreate(this.mRS, this);
        }
    }
}

