/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.Sampler;
import android.renderscript.Type;

public class ProgramFragment
extends BaseObj {
    public static final int MAX_SLOT = 2;

    public ProgramFragment(int id2, RenderScript rs) {
        super(rs);
        this.mID = id2;
    }

    public void bindTexture(Allocation va, int slot) throws IllegalArgumentException {
        if (slot < 0 || slot >= 2) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        this.mRS.nProgramFragmentBindTexture(this.mID, slot, va.mID);
    }

    public void bindSampler(Sampler vs, int slot) throws IllegalArgumentException {
        if (slot < 0 || slot >= 2) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        this.mRS.nProgramFragmentBindSampler(this.mID, slot, vs.mID);
    }

    public static class Builder {
        public RenderScript mRS;
        public Element mIn;
        public Element mOut;
        public boolean mPointSpriteEnable;
        public Slot[] mSlots;

        public Builder(RenderScript rs, Element in, Element out) {
            this.mRS = rs;
            this.mIn = in;
            this.mOut = out;
            this.mSlots = new Slot[2];
            this.mPointSpriteEnable = false;
            for (int ct = 0; ct < 2; ++ct) {
                this.mSlots[ct] = new Slot();
            }
        }

        public void setType(int slot, Type t) throws IllegalArgumentException {
            if (slot < 0 || slot >= 2) {
                throw new IllegalArgumentException("Slot ID out of range.");
            }
            this.mSlots[slot].mType = t;
        }

        public void setTexEnable(boolean enable, int slot) throws IllegalArgumentException {
            if (slot < 0 || slot >= 2) {
                throw new IllegalArgumentException("Slot ID out of range.");
            }
            this.mSlots[slot].mTexEnable = enable;
        }

        public void setTexEnvMode(EnvMode env, int slot) throws IllegalArgumentException {
            if (slot < 0 || slot >= 2) {
                throw new IllegalArgumentException("Slot ID out of range.");
            }
            this.mSlots[slot].mEnv = env;
        }

        public void setPointSpriteTexCoordinateReplacement(boolean enable) {
            this.mPointSpriteEnable = enable;
        }

        public static synchronized ProgramFragment internalCreate(RenderScript rs, Builder b) {
            int inID = 0;
            int outID = 0;
            if (b.mIn != null) {
                inID = b.mIn.mID;
            }
            if (b.mOut != null) {
                outID = b.mOut.mID;
            }
            rs.nProgramFragmentBegin(inID, outID, b.mPointSpriteEnable);
            for (int ct = 0; ct < 2; ++ct) {
                if (!b.mSlots[ct].mTexEnable) continue;
                Slot s = b.mSlots[ct];
                int typeID = 0;
                if (s.mType != null) {
                    typeID = s.mType.mID;
                }
                rs.nProgramFragmentSetSlot(ct, true, s.mEnv.mID, typeID);
            }
            int id2 = rs.nProgramFragmentCreate();
            return new ProgramFragment(id2, rs);
        }

        public ProgramFragment create() {
            return Builder.internalCreate(this.mRS, this);
        }

        public class Slot {
            public Type mType;
            public EnvMode mEnv;
            public boolean mTexEnable = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnvMode {
        REPLACE(0),
        MODULATE(1),
        DECAL(2);

        public int mID;

        public EnvMode(int id2) {
            this.mID = id2;
        }
    }
}

