/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.Light;
import android.renderscript.Matrix;
import android.renderscript.RenderScript;

public class ProgramVertex
extends BaseObj {
    public static final int MAX_LIGHT = 8;

    public ProgramVertex(int id2, RenderScript rs) {
        super(rs);
        this.mID = id2;
    }

    public void bindAllocation(MatrixAllocation va) {
        this.mRS.nProgramVertexBindAllocation(this.mID, va.mAlloc.mID);
    }

    public static class MatrixAllocation {
        public static final int MODELVIEW_OFFSET = 0;
        public static final int PROJECTION_OFFSET = 16;
        public static final int TEXTURE_OFFSET = 32;
        public Matrix mModel = new Matrix();
        public Matrix mProjection = new Matrix();
        public Matrix mTexture = new Matrix();
        public Allocation mAlloc;

        public MatrixAllocation(RenderScript rs) {
            this.mAlloc = Allocation.createSized(rs, Element.USER_F32(rs), 48);
            this.mAlloc.subData1D(0, 16, this.mModel.mMat);
            this.mAlloc.subData1D(16, 16, this.mProjection.mMat);
            this.mAlloc.subData1D(32, 16, this.mTexture.mMat);
        }

        public void destroy() {
            this.mAlloc.destroy();
            this.mAlloc = null;
        }

        public void loadModelview(Matrix m) {
            this.mModel = m;
            this.mAlloc.subData1D(0, 16, m.mMat);
        }

        public void loadProjection(Matrix m) {
            this.mProjection = m;
            this.mAlloc.subData1D(16, 16, m.mMat);
        }

        public void loadTexture(Matrix m) {
            this.mTexture = m;
            this.mAlloc.subData1D(32, 16, m.mMat);
        }

        public void setupOrthoWindow(int w, int h) {
            this.mProjection.loadOrtho(0.0f, w, h, 0.0f, -1.0f, 1.0f);
            this.mAlloc.subData1D(16, 16, this.mProjection.mMat);
        }

        public void setupOrthoNormalized(int w, int h) {
            if (w > h) {
                float aspect = (float)w / (float)h;
                this.mProjection.loadOrtho(-aspect, aspect, -1.0f, 1.0f, -1.0f, 1.0f);
            } else {
                float aspect = (float)h / (float)w;
                this.mProjection.loadOrtho(-1.0f, 1.0f, -aspect, aspect, -1.0f, 1.0f);
            }
            this.mAlloc.subData1D(16, 16, this.mProjection.mMat);
        }

        public void setupProjectionNormalized(int w, int h) {
            Matrix m1 = new Matrix();
            Matrix m2 = new Matrix();
            if (w > h) {
                float aspect = (float)w / (float)h;
                m1.loadFrustum(-aspect, aspect, -1.0f, 1.0f, 1.0f, 100.0f);
            } else {
                float aspect = (float)h / (float)w;
                m1.loadFrustum(-1.0f, 1.0f, -aspect, aspect, 1.0f, 100.0f);
            }
            m2.loadRotate(180.0f, 0.0f, 1.0f, 0.0f);
            m1.loadMultiply(m1, m2);
            m2.loadScale(-2.0f, 2.0f, 1.0f);
            m1.loadMultiply(m1, m2);
            m2.loadTranslate(0.0f, 0.0f, 2.0f);
            m1.loadMultiply(m1, m2);
            this.mProjection = m1;
            this.mAlloc.subData1D(16, 16, this.mProjection.mMat);
        }
    }

    public static class Builder {
        public RenderScript mRS;
        public Element mIn;
        public Element mOut;
        public Light[] mLights;
        public int mLightCount;
        public boolean mTextureMatrixEnable;

        public Builder(RenderScript rs, Element in, Element out) {
            this.mRS = rs;
            this.mIn = in;
            this.mOut = out;
            this.mLights = new Light[8];
            this.mLightCount = 0;
        }

        public void setTextureMatrixEnable(boolean enable) {
            this.mTextureMatrixEnable = enable;
        }

        public void addLight(Light l) throws IllegalStateException {
            if (this.mLightCount >= 8) {
                throw new IllegalArgumentException("Max light count exceeded.");
            }
            this.mLights[this.mLightCount] = l;
            ++this.mLightCount;
        }

        public static synchronized ProgramVertex internalCreate(RenderScript rs, Builder b) {
            int inID = 0;
            int outID = 0;
            if (b.mIn != null) {
                inID = b.mIn.mID;
            }
            if (b.mOut != null) {
                outID = b.mOut.mID;
            }
            rs.nProgramVertexBegin(inID, outID);
            for (int ct = 0; ct < b.mLightCount; ++ct) {
                rs.nProgramVertexAddLight(b.mLights[ct].mID);
            }
            rs.nProgramVertexSetTextureMatrixEnable(b.mTextureMatrixEnable);
            int id2 = rs.nProgramVertexCreate();
            return new ProgramVertex(id2, rs);
        }

        public ProgramVertex create() {
            return Builder.internalCreate(this.mRS, this);
        }
    }
}

