/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.Context;
import android.renderscript.RenderScript;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;

public class RSSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    public SurfaceHolder mSurfaceHolder;
    public RenderScript mRS;

    public RSSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public RSSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public void init() {
        SurfaceHolder holder = this.getHolder();
        holder.addCallback(this);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Log.v("RenderScript_jni", "surfaceCreated");
        this.mSurfaceHolder = holder;
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        Log.v("RenderScript_jni", "surfaceDestroyed");
        if (this.mRS != null) {
            this.mRS.contextSetSurface(0, 0, null);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        Log.v("RenderScript_jni", "surfaceChanged");
        if (this.mRS != null) {
            this.mRS.contextSetSurface(w, h, holder.getSurface());
        }
    }

    public void onPause() {
        if (this.mRS != null) {
            this.mRS.pause();
        }
    }

    public void onResume() {
        if (this.mRS != null) {
            this.mRS.resume();
        }
    }

    public void queueEvent(Runnable r) {
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public RenderScript createRenderScript(boolean useDepth, boolean forceSW) {
        Log.v("RenderScript_jni", "createRenderScript");
        this.mRS = new RenderScript(useDepth, forceSW);
        return this.mRS;
    }

    public RenderScript createRenderScript(boolean useDepth) {
        return this.createRenderScript(useDepth, false);
    }

    public void destroyRenderScript() {
        Log.v("RenderScript_jni", "destroyRenderScript");
        this.mRS.destroy();
        this.mRS = null;
    }
}

