/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.graphics.Bitmap;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.ProgramFragment;
import android.renderscript.ProgramRaster;
import android.renderscript.ProgramStore;
import android.renderscript.ProgramVertex;
import android.renderscript.Script;
import android.renderscript.Type;
import android.util.Log;
import android.view.Surface;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;

public class RenderScript {
    public static final String LOG_TAG = "RenderScript_jni";
    public static final boolean DEBUG = false;
    public static final boolean LOG_ENABLED = false;
    public int mWidth = 0;
    public int mHeight = 0;
    public static boolean sInitialized = false;
    public int mDev = this.nDeviceCreate();
    public int mContext;
    public Surface mSurface = null;
    public MessageThread mMessageThread;
    public Element mElement_USER_U8;
    public Element mElement_USER_I8;
    public Element mElement_USER_U16;
    public Element mElement_USER_I16;
    public Element mElement_USER_U32;
    public Element mElement_USER_I32;
    public Element mElement_USER_FLOAT;
    public Element mElement_A_8;
    public Element mElement_RGB_565;
    public Element mElement_RGB_888;
    public Element mElement_RGBA_5551;
    public Element mElement_RGBA_4444;
    public Element mElement_RGBA_8888;
    public Element mElement_INDEX_16;
    public Element mElement_XY_F32;
    public Element mElement_XYZ_F32;
    public RSMessage mMessageCallback = null;

    public static void _nInit() {
        OverrideMethod.invokeV("android.renderscript.RenderScript#_nInit()V", true, null);
    }

    public void nInitElements(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nInitElements(IIII)V", true, this);
    }

    public int nDeviceCreate() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nDeviceCreate()I", true, this);
    }

    public void nDeviceDestroy(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nDeviceDestroy(I)V", true, this);
    }

    public void nDeviceSetConfig(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nDeviceSetConfig(III)V", true, this);
    }

    public int nContextCreate(int n, int n2, boolean bl) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nContextCreate(IIZ)I", true, this);
    }

    public void nContextDestroy(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextDestroy(I)V", true, this);
    }

    public void nContextSetSurface(int n, int n2, Surface surface) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextSetSurface(IILandroid/view/Surface;)V", true, this);
    }

    public void nContextBindRootScript(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextBindRootScript(I)V", true, this);
    }

    public void nContextBindSampler(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextBindSampler(II)V", true, this);
    }

    public void nContextBindProgramFragmentStore(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextBindProgramFragmentStore(I)V", true, this);
    }

    public void nContextBindProgramFragment(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextBindProgramFragment(I)V", true, this);
    }

    public void nContextBindProgramVertex(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextBindProgramVertex(I)V", true, this);
    }

    public void nContextBindProgramRaster(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextBindProgramRaster(I)V", true, this);
    }

    public void nContextAddDefineI32(String string2, int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextAddDefineI32(Ljava/lang/String;I)V", true, this);
    }

    public void nContextAddDefineF(String string2, float f) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextAddDefineF(Ljava/lang/String;F)V", true, this);
    }

    public void nContextPause() {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextPause()V", true, this);
    }

    public void nContextResume() {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextResume()V", true, this);
    }

    public int nContextGetMessage(int[] nArray, boolean bl) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nContextGetMessage([IZ)I", true, this);
    }

    public void nContextInitToClient() {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextInitToClient()V", true, this);
    }

    public void nContextDeinitToClient() {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextDeinitToClient()V", true, this);
    }

    public void nAssignName(int n, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAssignName(I[B)V", true, this);
    }

    public void nObjDestroy(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nObjDestroy(I)V", true, this);
    }

    public void nObjDestroyOOB(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nObjDestroyOOB(I)V", true, this);
    }

    public int nFileOpen(byte[] byArray) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nFileOpen([B)I", true, this);
    }

    public void nElementBegin() {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nElementBegin()V", true, this);
    }

    public void nElementAdd(int n, int n2, boolean bl, int n3, String string2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nElementAdd(IIZILjava/lang/String;)V", true, this);
    }

    public int nElementCreate() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nElementCreate()I", true, this);
    }

    public void nTypeBegin(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nTypeBegin(I)V", true, this);
    }

    public void nTypeAdd(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nTypeAdd(II)V", true, this);
    }

    public int nTypeCreate() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nTypeCreate()I", true, this);
    }

    public void nTypeFinalDestroy(Type type) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nTypeFinalDestroy(Landroid/renderscript/Type;)V", true, this);
    }

    public void nTypeSetupFields(Type type, int[] nArray, int[] nArray2, Field[] fieldArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nTypeSetupFields(Landroid/renderscript/Type;[I[I[Ljava/lang/reflect/Field;)V", true, this);
    }

    public int nAllocationCreateTyped(int n) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nAllocationCreateTyped(I)I", true, this);
    }

    public int nAllocationCreateFromBitmap(int n, boolean bl, Bitmap bitmap) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nAllocationCreateFromBitmap(IZLandroid/graphics/Bitmap;)I", true, this);
    }

    public int nAllocationCreateFromBitmapBoxed(int n, boolean bl, Bitmap bitmap) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nAllocationCreateFromBitmapBoxed(IZLandroid/graphics/Bitmap;)I", true, this);
    }

    public int nAllocationCreateFromAssetStream(int n, boolean bl, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nAllocationCreateFromAssetStream(IZI)I", true, this);
    }

    public void nAllocationUploadToTexture(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAllocationUploadToTexture(II)V", true, this);
    }

    public void nAllocationUploadToBufferObject(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAllocationUploadToBufferObject(I)V", true, this);
    }

    public void nAllocationSubData1D(int n, int n2, int n3, int[] nArray, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAllocationSubData1D(III[II)V", true, this);
    }

    public void nAllocationSubData1D(int n, int n2, int n3, short[] sArray, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAllocationSubData1D(III[SI)V", true, this);
    }

    public void nAllocationSubData1D(int n, int n2, int n3, byte[] byArray, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAllocationSubData1D(III[BI)V", true, this);
    }

    public void nAllocationSubData1D(int n, int n2, int n3, float[] fArray, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAllocationSubData1D(III[FI)V", true, this);
    }

    public void nAllocationSubData2D(int n, int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAllocationSubData2D(IIIII[II)V", true, this);
    }

    public void nAllocationSubData2D(int n, int n2, int n3, int n4, int n5, float[] fArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAllocationSubData2D(IIIII[FI)V", true, this);
    }

    public void nAllocationRead(int n, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAllocationRead(I[I)V", true, this);
    }

    public void nAllocationRead(int n, float[] fArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAllocationRead(I[F)V", true, this);
    }

    public void nAllocationSubDataFromObject(int n, Type type, int n2, Object object) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAllocationSubDataFromObject(ILandroid/renderscript/Type;ILjava/lang/Object;)V", true, this);
    }

    public void nAllocationSubReadFromObject(int n, Type type, int n2, Object object) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAllocationSubReadFromObject(ILandroid/renderscript/Type;ILjava/lang/Object;)V", true, this);
    }

    public void nAdapter1DBindAllocation(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAdapter1DBindAllocation(II)V", true, this);
    }

    public void nAdapter1DSetConstraint(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAdapter1DSetConstraint(III)V", true, this);
    }

    public void nAdapter1DData(int n, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAdapter1DData(I[I)V", true, this);
    }

    public void nAdapter1DData(int n, float[] fArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAdapter1DData(I[F)V", true, this);
    }

    public void nAdapter1DSubData(int n, int n2, int n3, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAdapter1DSubData(III[I)V", true, this);
    }

    public void nAdapter1DSubData(int n, int n2, int n3, float[] fArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAdapter1DSubData(III[F)V", true, this);
    }

    public int nAdapter1DCreate() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nAdapter1DCreate()I", true, this);
    }

    public void nAdapter2DBindAllocation(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAdapter2DBindAllocation(II)V", true, this);
    }

    public void nAdapter2DSetConstraint(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAdapter2DSetConstraint(III)V", true, this);
    }

    public void nAdapter2DData(int n, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAdapter2DData(I[I)V", true, this);
    }

    public void nAdapter2DData(int n, float[] fArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAdapter2DData(I[F)V", true, this);
    }

    public void nAdapter2DSubData(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAdapter2DSubData(IIIII[I)V", true, this);
    }

    public void nAdapter2DSubData(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAdapter2DSubData(IIIII[F)V", true, this);
    }

    public int nAdapter2DCreate() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nAdapter2DCreate()I", true, this);
    }

    public void nScriptBindAllocation(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nScriptBindAllocation(III)V", true, this);
    }

    public void nScriptSetClearColor(int n, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nScriptSetClearColor(IFFFF)V", true, this);
    }

    public void nScriptSetClearDepth(int n, float f) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nScriptSetClearDepth(IF)V", true, this);
    }

    public void nScriptSetClearStencil(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nScriptSetClearStencil(II)V", true, this);
    }

    public void nScriptSetTimeZone(int n, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nScriptSetTimeZone(I[B)V", true, this);
    }

    public void nScriptSetType(int n, boolean bl, String string2, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nScriptSetType(IZLjava/lang/String;I)V", true, this);
    }

    public void nScriptSetRoot(boolean bl) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nScriptSetRoot(Z)V", true, this);
    }

    public void nScriptSetInvokable(String string2, int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nScriptSetInvokable(Ljava/lang/String;I)V", true, this);
    }

    public void nScriptInvoke(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nScriptInvoke(II)V", true, this);
    }

    public void nScriptCBegin() {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nScriptCBegin()V", true, this);
    }

    public void nScriptCSetScript(byte[] byArray, int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nScriptCSetScript([BII)V", true, this);
    }

    public int nScriptCCreate() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nScriptCCreate()I", true, this);
    }

    public void nScriptCAddDefineI32(String string2, int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nScriptCAddDefineI32(Ljava/lang/String;I)V", true, this);
    }

    public void nScriptCAddDefineF(String string2, float f) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nScriptCAddDefineF(Ljava/lang/String;F)V", true, this);
    }

    public void nSamplerBegin() {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nSamplerBegin()V", true, this);
    }

    public void nSamplerSet(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nSamplerSet(II)V", true, this);
    }

    public int nSamplerCreate() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nSamplerCreate()I", true, this);
    }

    public void nProgramFragmentStoreBegin(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramFragmentStoreBegin(II)V", true, this);
    }

    public void nProgramFragmentStoreDepthFunc(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramFragmentStoreDepthFunc(I)V", true, this);
    }

    public void nProgramFragmentStoreDepthMask(boolean bl) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramFragmentStoreDepthMask(Z)V", true, this);
    }

    public void nProgramFragmentStoreColorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramFragmentStoreColorMask(ZZZZ)V", true, this);
    }

    public void nProgramFragmentStoreBlendFunc(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramFragmentStoreBlendFunc(II)V", true, this);
    }

    public void nProgramFragmentStoreDither(boolean bl) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramFragmentStoreDither(Z)V", true, this);
    }

    public int nProgramFragmentStoreCreate() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nProgramFragmentStoreCreate()I", true, this);
    }

    public int nProgramRasterCreate(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nProgramRasterCreate(IIZZZ)I", true, this);
    }

    public void nProgramRasterSetLineWidth(int n, float f) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramRasterSetLineWidth(IF)V", true, this);
    }

    public void nProgramRasterSetPointSize(int n, float f) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramRasterSetPointSize(IF)V", true, this);
    }

    public void nProgramFragmentBegin(int n, int n2, boolean bl) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramFragmentBegin(IIZ)V", true, this);
    }

    public void nProgramFragmentBindTexture(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramFragmentBindTexture(III)V", true, this);
    }

    public void nProgramFragmentBindSampler(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramFragmentBindSampler(III)V", true, this);
    }

    public void nProgramFragmentSetSlot(int n, boolean bl, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramFragmentSetSlot(IZII)V", true, this);
    }

    public int nProgramFragmentCreate() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nProgramFragmentCreate()I", true, this);
    }

    public void nProgramVertexBindAllocation(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramVertexBindAllocation(II)V", true, this);
    }

    public void nProgramVertexBegin(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramVertexBegin(II)V", true, this);
    }

    public void nProgramVertexSetTextureMatrixEnable(boolean bl) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramVertexSetTextureMatrixEnable(Z)V", true, this);
    }

    public void nProgramVertexAddLight(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nProgramVertexAddLight(I)V", true, this);
    }

    public int nProgramVertexCreate() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nProgramVertexCreate()I", true, this);
    }

    public void nLightBegin() {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nLightBegin()V", true, this);
    }

    public void nLightSetIsMono(boolean bl) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nLightSetIsMono(Z)V", true, this);
    }

    public void nLightSetIsLocal(boolean bl) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nLightSetIsLocal(Z)V", true, this);
    }

    public int nLightCreate() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nLightCreate()I", true, this);
    }

    public void nLightSetColor(int n, float f, float f2, float f3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nLightSetColor(IFFF)V", true, this);
    }

    public void nLightSetPosition(int n, float f, float f2, float f3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nLightSetPosition(IFFF)V", true, this);
    }

    public int nSimpleMeshCreate(int n, int n2, int[] nArray, int n3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nSimpleMeshCreate(II[II)I", true, this);
    }

    public void nSimpleMeshBindVertex(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nSimpleMeshBindVertex(III)V", true, this);
    }

    public void nSimpleMeshBindIndex(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nSimpleMeshBindIndex(II)V", true, this);
    }

    public void nAnimationBegin(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAnimationBegin(II)V", true, this);
    }

    public void nAnimationAdd(float f, float[] fArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nAnimationAdd(F[F)V", true, this);
    }

    public int nAnimationCreate() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nAnimationCreate()I", true, this);
    }

    public RenderScript(boolean useDepth, boolean forceSW) {
        if (forceSW) {
            this.nDeviceSetConfig(this.mDev, 0, 1);
        }
        this.mContext = this.nContextCreate(this.mDev, 0, useDepth);
        Element.initPredefined(this);
        this.mMessageThread = new MessageThread(this);
        this.mMessageThread.start();
    }

    public void contextSetSurface(int w, int h, Surface sur) {
        this.mSurface = sur;
        this.mWidth = w;
        this.mHeight = h;
        this.nContextSetSurface(w, h, this.mSurface);
    }

    public void destroy() {
        this.nContextDeinitToClient();
        this.mMessageThread.mRun = false;
        this.nContextDestroy(this.mContext);
        this.mContext = 0;
        this.nDeviceDestroy(this.mDev);
        this.mDev = 0;
    }

    public boolean isAlive() {
        return this.mContext != 0;
    }

    public void pause() {
        this.nContextPause();
    }

    public void resume() {
        this.nContextResume();
    }

    public File fileOpen(String s) throws IllegalStateException, IllegalArgumentException {
        if (s.length() < 1) {
            throw new IllegalArgumentException("fileOpen does not accept a zero length string.");
        }
        try {
            byte[] bytes = s.getBytes("UTF-8");
            int id2 = this.nFileOpen(bytes);
            return new File(id2);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public int safeID(BaseObj o) {
        if (o != null) {
            return o.mID;
        }
        return 0;
    }

    public void contextBindRootScript(Script s) {
        this.nContextBindRootScript(this.safeID(s));
    }

    public void contextBindProgramFragmentStore(ProgramStore p) {
        this.nContextBindProgramFragmentStore(this.safeID(p));
    }

    public void contextBindProgramFragment(ProgramFragment p) {
        this.nContextBindProgramFragment(this.safeID(p));
    }

    public void contextBindProgramRaster(ProgramRaster p) {
        this.nContextBindProgramRaster(this.safeID(p));
    }

    public void contextBindProgramVertex(ProgramVertex p) {
        this.nContextBindProgramVertex(this.safeID(p));
    }

    static {
        try {
            System.loadLibrary("rs_jni");
            RenderScript._nInit();
            sInitialized = true;
        }
        catch (UnsatisfiedLinkError e) {
            Log.d(LOG_TAG, "RenderScript JNI library not found!");
        }
    }

    public class File
    extends BaseObj {
        public File(int id2) {
            super(RenderScript.this);
            this.mID = id2;
        }
    }

    public static class MessageThread
    extends Thread {
        public RenderScript mRS;
        public boolean mRun = true;

        public MessageThread(RenderScript rs) {
            super("RSMessageThread");
            this.mRS = rs;
        }

        public void run() {
            int[] rbuf = new int[16];
            this.mRS.nContextInitToClient();
            while (this.mRun) {
                int msg = this.mRS.nContextGetMessage(rbuf, true);
                if (msg == 0) {
                    try {
                        MessageThread.sleep(1L, 0);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.mRS.mMessageCallback == null) continue;
                this.mRS.mMessageCallback.mData = rbuf;
                this.mRS.mMessageCallback.mID = msg;
                this.mRS.mMessageCallback.run();
            }
            Log.d(RenderScript.LOG_TAG, "MessageThread exiting.");
        }
    }

    public static class RSMessage
    implements Runnable {
        public int[] mData;
        public int mID;

        public void run() {
        }
    }
}

