/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RenderScript;

public class Sampler
extends BaseObj {
    public Sampler(int id2, RenderScript rs) {
        super(rs);
        this.mID = id2;
    }

    public static class Builder {
        public RenderScript mRS;
        public Value mMin;
        public Value mMag;
        public Value mWrapS;
        public Value mWrapT;
        public Value mWrapR;

        public Builder(RenderScript rs) {
            this.mRS = rs;
            this.mMin = Value.NEAREST;
            this.mMag = Value.NEAREST;
            this.mWrapS = Value.WRAP;
            this.mWrapT = Value.WRAP;
            this.mWrapR = Value.WRAP;
        }

        public void setMin(Value v) {
            this.mMin = v;
        }

        public void setMag(Value v) {
            this.mMag = v;
        }

        public void setWrapS(Value v) {
            this.mWrapS = v;
        }

        public void setWrapT(Value v) {
            this.mWrapT = v;
        }

        public void setWrapR(Value v) {
            this.mWrapR = v;
        }

        public static synchronized Sampler internalCreate(RenderScript rs, Builder b) {
            rs.nSamplerBegin();
            rs.nSamplerSet(0, b.mMin.mID);
            rs.nSamplerSet(1, b.mMag.mID);
            rs.nSamplerSet(2, b.mWrapS.mID);
            rs.nSamplerSet(3, b.mWrapT.mID);
            rs.nSamplerSet(4, b.mWrapR.mID);
            int id2 = rs.nSamplerCreate();
            return new Sampler(id2, rs);
        }

        public Sampler create() {
            return Builder.internalCreate(this.mRS, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Value {
        NEAREST(0),
        LINEAR(1),
        LINEAR_MIP_LINEAR(2),
        WRAP(3),
        CLAMP(4);

        public int mID;

        public Value(int id2) {
            this.mID = id2;
        }
    }
}

