/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Dimension;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import java.lang.reflect.Field;

public class Type
extends BaseObj {
    public int mDimX;
    public int mDimY;
    public int mDimZ;
    public boolean mDimLOD;
    public boolean mDimFaces;
    public int mElementCount;
    public Element mElement;
    public int mNativeCache;
    public Class mJavaClass;

    public int getX() {
        return this.mDimX;
    }

    public int getY() {
        return this.mDimY;
    }

    public int getZ() {
        return this.mDimZ;
    }

    public boolean getLOD() {
        return this.mDimLOD;
    }

    public boolean getFaces() {
        return this.mDimFaces;
    }

    public int getElementCount() {
        return this.mElementCount;
    }

    public void calcElementCount() {
        boolean hasLod = this.getLOD();
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        int faces = 1;
        if (this.getFaces()) {
            faces = 6;
        }
        if (x == 0) {
            x = 1;
        }
        if (y == 0) {
            y = 1;
        }
        if (z == 0) {
            z = 1;
        }
        int count = x * y * z * faces;
        if (hasLod && x > 1 && y > 1 && z > 1) {
            if (x > 1) {
                x >>= 1;
            }
            if (y > 1) {
                y >>= 1;
            }
            if (z > 1) {
                z >>= 1;
            }
            count += x * y * z * faces;
        }
        this.mElementCount = count;
    }

    public Type(int id2, RenderScript rs) {
        super(rs);
        this.mID = id2;
        this.mNativeCache = 0;
    }

    public void finalize() throws Throwable {
        if (this.mNativeCache != 0) {
            this.mRS.nTypeFinalDestroy(this);
            this.mNativeCache = 0;
        }
        super.finalize();
    }

    public static Type createFromClass(RenderScript rs, Class c, int size) {
        Element e = Element.createFromClass(rs, c);
        Builder b = new Builder(rs, e);
        b.add(Dimension.X, size);
        Type t = b.create();
        e.destroy();
        Field[] fields = c.getFields();
        int[] arTypes = new int[fields.length];
        int[] arBits = new int[fields.length];
        for (int ct = 0; ct < fields.length; ++ct) {
            Field f = fields[ct];
            Class<?> fc = f.getType();
            if (fc == Integer.TYPE) {
                arTypes[ct] = Element.DataType.SIGNED.mID;
                arBits[ct] = 32;
                continue;
            }
            if (fc == Short.TYPE) {
                arTypes[ct] = Element.DataType.SIGNED.mID;
                arBits[ct] = 16;
                continue;
            }
            if (fc == Byte.TYPE) {
                arTypes[ct] = Element.DataType.SIGNED.mID;
                arBits[ct] = 8;
                continue;
            }
            if (fc == Float.TYPE) {
                arTypes[ct] = Element.DataType.FLOAT.mID;
                arBits[ct] = 32;
                continue;
            }
            throw new IllegalArgumentException("Unkown field type");
        }
        rs.nTypeSetupFields(t, arTypes, arBits, fields);
        t.mJavaClass = c;
        return t;
    }

    public static Type createFromClass(RenderScript rs, Class c, int size, String scriptName) {
        Type t = Type.createFromClass(rs, c, size);
        t.setName(scriptName);
        return t;
    }

    public static class Builder {
        public RenderScript mRS;
        public Entry[] mEntries;
        public int mEntryCount;
        public Element mElement;

        public Builder(RenderScript rs, Element e) {
            if (e.mID == 0) {
                throw new IllegalArgumentException("Invalid element.");
            }
            this.mRS = rs;
            this.mEntries = new Entry[4];
            this.mElement = e;
        }

        public void add(Dimension d, int value) {
            if (value < 1) {
                throw new IllegalArgumentException("Values of less than 1 for Dimensions are not valid.");
            }
            if (this.mEntries.length >= this.mEntryCount) {
                Entry[] en2 = new Entry[this.mEntryCount + 8];
                System.arraycopy(this.mEntries, 0, en2, 0, this.mEntries.length);
                this.mEntries = en2;
            }
            this.mEntries[this.mEntryCount] = new Entry();
            this.mEntries[this.mEntryCount].mDim = d;
            this.mEntries[this.mEntryCount].mValue = value;
            ++this.mEntryCount;
        }

        public static synchronized Type internalCreate(RenderScript rs, Builder b) {
            rs.nTypeBegin(b.mElement.mID);
            for (int ct = 0; ct < b.mEntryCount; ++ct) {
                Entry en2 = b.mEntries[ct];
                rs.nTypeAdd(en2.mDim.mID, en2.mValue);
            }
            int id2 = rs.nTypeCreate();
            return new Type(id2, rs);
        }

        public Type create() {
            Type t = Builder.internalCreate(this.mRS, this);
            t.mElement = this.mElement;
            for (int ct = 0; ct < this.mEntryCount; ++ct) {
                if (this.mEntries[ct].mDim == Dimension.X) {
                    t.mDimX = this.mEntries[ct].mValue;
                }
                if (this.mEntries[ct].mDim == Dimension.Y) {
                    t.mDimY = this.mEntries[ct].mValue;
                }
                if (this.mEntries[ct].mDim == Dimension.Z) {
                    t.mDimZ = this.mEntries[ct].mValue;
                }
                if (this.mEntries[ct].mDim == Dimension.LOD) {
                    boolean bl = t.mDimLOD = this.mEntries[ct].mValue != 0;
                }
                if (this.mEntries[ct].mDim != Dimension.FACE) continue;
                t.mDimFaces = this.mEntries[ct].mValue != 0;
            }
            t.calcElementCount();
            return t;
        }

        public class Entry {
            public Dimension mDim;
            public int mValue;
        }
    }
}

