/*
 * Decompiled with CFR 0.152.
 */
package android.server.data;

import android.server.data.BuildData;
import android.server.data.ThrowableData;
import com.android.internal.util.Objects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CrashData {
    public final String id;
    public final String activity;
    public final long time;
    public final BuildData buildData;
    public final ThrowableData throwableData;
    public final byte[] state;

    public CrashData(String id2, String activity, BuildData buildData, ThrowableData throwableData) {
        this.id = Objects.nonNull(id2);
        this.activity = Objects.nonNull(activity);
        this.buildData = Objects.nonNull(buildData);
        this.throwableData = Objects.nonNull(throwableData);
        this.time = System.currentTimeMillis();
        this.state = null;
    }

    public CrashData(String id2, String activity, BuildData buildData, ThrowableData throwableData, byte[] state) {
        this.id = Objects.nonNull(id2);
        this.activity = Objects.nonNull(activity);
        this.buildData = Objects.nonNull(buildData);
        this.throwableData = Objects.nonNull(throwableData);
        this.time = System.currentTimeMillis();
        this.state = state;
    }

    public CrashData(DataInput in) throws IOException {
        int dataVersion = in.readInt();
        if (dataVersion != 0 && dataVersion != 1) {
            throw new IOException("Expected 0 or 1. Got: " + dataVersion);
        }
        this.id = in.readUTF();
        this.activity = in.readUTF();
        this.time = in.readLong();
        this.buildData = new BuildData(in);
        this.throwableData = new ThrowableData(in);
        if (dataVersion == 1) {
            int len = in.readInt();
            if (len == 0) {
                this.state = null;
            } else {
                this.state = new byte[len];
                in.readFully(this.state, 0, len);
            }
        } else {
            this.state = null;
        }
    }

    public CrashData(String tag, Throwable throwable) {
        this.id = "";
        this.activity = tag;
        this.buildData = new BuildData();
        this.throwableData = new ThrowableData(throwable);
        this.time = System.currentTimeMillis();
        this.state = null;
    }

    public void write(DataOutput out) throws IOException {
        if (this.state == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
        }
        out.writeUTF(this.id);
        out.writeUTF(this.activity);
        out.writeLong(this.time);
        this.buildData.write(out);
        this.throwableData.write(out);
        if (this.state != null) {
            out.writeInt(this.state.length);
            out.write(this.state, 0, this.state.length);
        }
    }

    public BuildData getBuildData() {
        return this.buildData;
    }

    public ThrowableData getThrowableData() {
        return this.throwableData;
    }

    public String getId() {
        return this.id;
    }

    public String getActivity() {
        return this.activity;
    }

    public long getTime() {
        return this.time;
    }

    public byte[] getState() {
        return this.state;
    }

    public String toString() {
        return "[CrashData: id=" + this.id + " activity=" + this.activity + " time=" + this.time + " buildData=" + this.buildData.toString() + " throwableData=" + this.throwableData.toString() + "]";
    }
}

