/*
 * Decompiled with CFR 0.152.
 */
package android.server.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StackTraceElementData {
    public final String className;
    public final String fileName;
    public final String methodName;
    public final int lineNumber;

    public StackTraceElementData(StackTraceElement element) {
        this.className = element.getClassName();
        String fileName = element.getFileName();
        this.fileName = fileName == null ? "[unknown source]" : fileName;
        this.methodName = element.getMethodName();
        this.lineNumber = element.getLineNumber();
    }

    public StackTraceElementData(DataInput in) throws IOException {
        int dataVersion = in.readInt();
        if (dataVersion != 0) {
            throw new IOException("Expected 0. Got: " + dataVersion);
        }
        this.className = in.readUTF();
        this.fileName = in.readUTF();
        this.methodName = in.readUTF();
        this.lineNumber = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(0);
        out.writeUTF(this.className);
        out.writeUTF(this.fileName);
        out.writeUTF(this.methodName);
        out.writeInt(this.lineNumber);
    }

    public String getClassName() {
        return this.className;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

