/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.telephony.CellLocation;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import com.android.internal.telephony.IPhoneStateListener;

public class PhoneStateListener {
    public static final int LISTEN_NONE = 0;
    public static final int LISTEN_SERVICE_STATE = 1;
    public static final int LISTEN_SIGNAL_STRENGTH = 2;
    public static final int LISTEN_MESSAGE_WAITING_INDICATOR = 4;
    public static final int LISTEN_CALL_FORWARDING_INDICATOR = 8;
    public static final int LISTEN_CELL_LOCATION = 16;
    public static final int LISTEN_CALL_STATE = 32;
    public static final int LISTEN_DATA_CONNECTION_STATE = 64;
    public static final int LISTEN_DATA_ACTIVITY = 128;
    public static final int LISTEN_SIGNAL_STRENGTHS = 256;
    public IPhoneStateListener callback = new IPhoneStateListener.Stub(){

        public void onServiceStateChanged(ServiceState serviceState) {
            Message.obtain(PhoneStateListener.this.mHandler, 1, 0, 0, serviceState).sendToTarget();
        }

        public void onSignalStrengthChanged(int asu) {
            Message.obtain(PhoneStateListener.this.mHandler, 2, asu, 0, null).sendToTarget();
        }

        public void onMessageWaitingIndicatorChanged(boolean mwi) {
            Message.obtain(PhoneStateListener.this.mHandler, 4, mwi ? 1 : 0, 0, null).sendToTarget();
        }

        public void onCallForwardingIndicatorChanged(boolean cfi) {
            Message.obtain(PhoneStateListener.this.mHandler, 8, cfi ? 1 : 0, 0, null).sendToTarget();
        }

        public void onCellLocationChanged(Bundle bundle) {
            CellLocation location = CellLocation.newFromBundle(bundle);
            Message.obtain(PhoneStateListener.this.mHandler, 16, 0, 0, location).sendToTarget();
        }

        public void onCallStateChanged(int state, String incomingNumber) {
            Message.obtain(PhoneStateListener.this.mHandler, 32, state, 0, incomingNumber).sendToTarget();
        }

        public void onDataConnectionStateChanged(int state, int networkType) {
            Message.obtain(PhoneStateListener.this.mHandler, 64, state, networkType, null).sendToTarget();
        }

        public void onDataActivity(int direction) {
            Message.obtain(PhoneStateListener.this.mHandler, 128, direction, 0, null).sendToTarget();
        }

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            Message.obtain(PhoneStateListener.this.mHandler, 256, 0, 0, signalStrength).sendToTarget();
        }
    };
    public Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PhoneStateListener.this.onServiceStateChanged((ServiceState)msg.obj);
                    break;
                }
                case 2: {
                    PhoneStateListener.this.onSignalStrengthChanged(msg.arg1);
                    break;
                }
                case 4: {
                    PhoneStateListener.this.onMessageWaitingIndicatorChanged(msg.arg1 != 0);
                    break;
                }
                case 8: {
                    PhoneStateListener.this.onCallForwardingIndicatorChanged(msg.arg1 != 0);
                    break;
                }
                case 16: {
                    PhoneStateListener.this.onCellLocationChanged((CellLocation)msg.obj);
                    break;
                }
                case 32: {
                    PhoneStateListener.this.onCallStateChanged(msg.arg1, (String)msg.obj);
                    break;
                }
                case 64: {
                    PhoneStateListener.this.onDataConnectionStateChanged(msg.arg1, msg.arg2);
                    PhoneStateListener.this.onDataConnectionStateChanged(msg.arg1);
                    break;
                }
                case 128: {
                    PhoneStateListener.this.onDataActivity(msg.arg1);
                    break;
                }
                case 256: {
                    PhoneStateListener.this.onSignalStrengthsChanged((SignalStrength)msg.obj);
                }
            }
        }
    };

    public void onServiceStateChanged(ServiceState serviceState) {
    }

    @Deprecated
    public void onSignalStrengthChanged(int asu) {
    }

    public void onMessageWaitingIndicatorChanged(boolean mwi) {
    }

    public void onCallForwardingIndicatorChanged(boolean cfi) {
    }

    public void onCellLocationChanged(CellLocation location) {
    }

    public void onCallStateChanged(int state, String incomingNumber) {
    }

    public void onDataConnectionStateChanged(int state) {
    }

    public void onDataConnectionStateChanged(int state, int networkType) {
    }

    public void onDataActivity(int direction) {
    }

    public void onSignalStrengthsChanged(SignalStrength signalStrength) {
    }
}

