/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmsMessage {
    public static final boolean LOCAL_DEBUG = true;
    public static final String LOG_TAG = "SMS";
    public static final int ENCODING_UNKNOWN = 0;
    public static final int ENCODING_7BIT = 1;
    public static final int ENCODING_8BIT = 2;
    public static final int ENCODING_16BIT = 3;
    public static final int MAX_USER_DATA_BYTES = 140;
    public static final int MAX_USER_DATA_BYTES_WITH_HEADER = 134;
    public static final int MAX_USER_DATA_SEPTETS = 160;
    public static final int MAX_USER_DATA_SEPTETS_WITH_HEADER = 153;
    public SmsMessageBase mWrappedSmsMessage;

    public SmsMessage() {
        this(SmsMessage.getSmsFacility());
    }

    public SmsMessage(SmsMessageBase smb) {
        this.mWrappedSmsMessage = smb;
    }

    public static SmsMessage createFromPdu(byte[] pdu) {
        int activePhone = TelephonyManager.getDefault().getPhoneType();
        SmsMessageBase wrappedMessage = 2 == activePhone ? com.android.internal.telephony.cdma.SmsMessage.createFromPdu(pdu) : com.android.internal.telephony.gsm.SmsMessage.createFromPdu(pdu);
        return new SmsMessage(wrappedMessage);
    }

    public static SmsMessage newFromCMT(String[] lines) {
        int activePhone = TelephonyManager.getDefault().getPhoneType();
        SmsMessageBase wrappedMessage = 2 == activePhone ? com.android.internal.telephony.cdma.SmsMessage.newFromCMT(lines) : com.android.internal.telephony.gsm.SmsMessage.newFromCMT(lines);
        return new SmsMessage(wrappedMessage);
    }

    public static SmsMessage newFromCMTI(String line) {
        int activePhone = TelephonyManager.getDefault().getPhoneType();
        SmsMessageBase wrappedMessage = 2 == activePhone ? com.android.internal.telephony.cdma.SmsMessage.newFromCMTI(line) : com.android.internal.telephony.gsm.SmsMessage.newFromCMTI(line);
        return new SmsMessage(wrappedMessage);
    }

    public static SmsMessage newFromCDS(String line) {
        int activePhone = TelephonyManager.getDefault().getPhoneType();
        SmsMessageBase wrappedMessage = 2 == activePhone ? com.android.internal.telephony.cdma.SmsMessage.newFromCDS(line) : com.android.internal.telephony.gsm.SmsMessage.newFromCDS(line);
        return new SmsMessage(wrappedMessage);
    }

    public static SmsMessage newFromParcel(Parcel p) {
        int activePhone = TelephonyManager.getDefault().getPhoneType();
        SmsMessageBase wrappedMessage = 2 == activePhone ? com.android.internal.telephony.cdma.SmsMessage.newFromParcel(p) : com.android.internal.telephony.gsm.SmsMessage.newFromParcel(p);
        return new SmsMessage(wrappedMessage);
    }

    public static SmsMessage createFromEfRecord(int index, byte[] data) {
        int activePhone = TelephonyManager.getDefault().getPhoneType();
        SmsMessageBase wrappedMessage = 2 == activePhone ? com.android.internal.telephony.cdma.SmsMessage.createFromEfRecord(index, data) : com.android.internal.telephony.gsm.SmsMessage.createFromEfRecord(index, data);
        return wrappedMessage != null ? new SmsMessage(wrappedMessage) : null;
    }

    public static int getTPLayerLengthForPDU(String pdu) {
        int activePhone = TelephonyManager.getDefault().getPhoneType();
        if (2 == activePhone) {
            return com.android.internal.telephony.cdma.SmsMessage.getTPLayerLengthForPDU(pdu);
        }
        return com.android.internal.telephony.gsm.SmsMessage.getTPLayerLengthForPDU(pdu);
    }

    public static int[] calculateLength(CharSequence msgBody, boolean use7bitOnly) {
        int activePhone = TelephonyManager.getDefault().getPhoneType();
        SmsMessageBase.TextEncodingDetails ted = 2 == activePhone ? com.android.internal.telephony.cdma.SmsMessage.calculateLength(msgBody, use7bitOnly) : com.android.internal.telephony.gsm.SmsMessage.calculateLength(msgBody, use7bitOnly);
        int[] ret = new int[]{ted.msgCount, ted.codeUnitCount, ted.codeUnitsRemaining, ted.codeUnitSize};
        return ret;
    }

    public static ArrayList<String> fragmentText(String text) {
        SmsMessageBase.TextEncodingDetails ted;
        int activePhone = TelephonyManager.getDefault().getPhoneType();
        SmsMessageBase.TextEncodingDetails textEncodingDetails = ted = 2 == activePhone ? com.android.internal.telephony.cdma.SmsMessage.calculateLength(text, false) : com.android.internal.telephony.gsm.SmsMessage.calculateLength(text, false);
        int limit = ted.msgCount > 1 ? (ted.codeUnitSize == 1 ? 153 : 134) : (ted.codeUnitSize == 1 ? 160 : 140);
        int pos = 0;
        int textLen = text.length();
        ArrayList<String> result = new ArrayList<String>(ted.msgCount);
        while (pos < textLen) {
            int nextPos = 0;
            nextPos = ted.codeUnitSize == 1 ? (activePhone == 2 && ted.msgCount == 1 ? pos + Math.min(limit, textLen - pos) : GsmAlphabet.findGsmSeptetLimitIndex(text, pos, limit)) : pos + Math.min(limit / 2, textLen - pos);
            if (nextPos <= pos || nextPos > textLen) {
                Log.e(LOG_TAG, "fragmentText failed (" + pos + " >= " + nextPos + " or " + nextPos + " >= " + textLen + ")");
                break;
            }
            result.add(text.substring(pos, nextPos));
            pos = nextPos;
        }
        return result;
    }

    public static int[] calculateLength(String messageBody, boolean use7bitOnly) {
        return SmsMessage.calculateLength((CharSequence)messageBody, use7bitOnly);
    }

    public static SubmitPdu getSubmitPdu(String scAddress, String destinationAddress, String message, boolean statusReportRequested, byte[] header) {
        int activePhone = TelephonyManager.getDefault().getPhoneType();
        SmsMessageBase.SubmitPduBase spb = 2 == activePhone ? com.android.internal.telephony.cdma.SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, statusReportRequested, SmsHeader.fromByteArray(header)) : com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, statusReportRequested, header);
        return new SubmitPdu(spb);
    }

    public static SubmitPdu getSubmitPdu(String scAddress, String destinationAddress, String message, boolean statusReportRequested) {
        int activePhone = TelephonyManager.getDefault().getPhoneType();
        SmsMessageBase.SubmitPduBase spb = 2 == activePhone ? com.android.internal.telephony.cdma.SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, statusReportRequested, null) : com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, statusReportRequested);
        return new SubmitPdu(spb);
    }

    public static SubmitPdu getSubmitPdu(String scAddress, String destinationAddress, short destinationPort, byte[] data, boolean statusReportRequested) {
        int activePhone = TelephonyManager.getDefault().getPhoneType();
        SmsMessageBase.SubmitPduBase spb = 2 == activePhone ? com.android.internal.telephony.cdma.SmsMessage.getSubmitPdu(scAddress, destinationAddress, destinationPort, data, statusReportRequested) : com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(scAddress, destinationAddress, destinationPort, data, statusReportRequested);
        return new SubmitPdu(spb);
    }

    public String getServiceCenterAddress() {
        return this.mWrappedSmsMessage.getServiceCenterAddress();
    }

    public String getOriginatingAddress() {
        return this.mWrappedSmsMessage.getOriginatingAddress();
    }

    public String getDisplayOriginatingAddress() {
        return this.mWrappedSmsMessage.getDisplayOriginatingAddress();
    }

    public String getMessageBody() {
        return this.mWrappedSmsMessage.getMessageBody();
    }

    public MessageClass getMessageClass() {
        return this.mWrappedSmsMessage.getMessageClass();
    }

    public String getDisplayMessageBody() {
        return this.mWrappedSmsMessage.getDisplayMessageBody();
    }

    public String getPseudoSubject() {
        return this.mWrappedSmsMessage.getPseudoSubject();
    }

    public long getTimestampMillis() {
        return this.mWrappedSmsMessage.getTimestampMillis();
    }

    public boolean isEmail() {
        return this.mWrappedSmsMessage.isEmail();
    }

    public String getEmailBody() {
        return this.mWrappedSmsMessage.getEmailBody();
    }

    public String getEmailFrom() {
        return this.mWrappedSmsMessage.getEmailFrom();
    }

    public int getProtocolIdentifier() {
        return this.mWrappedSmsMessage.getProtocolIdentifier();
    }

    public boolean isReplace() {
        return this.mWrappedSmsMessage.isReplace();
    }

    public boolean isCphsMwiMessage() {
        return this.mWrappedSmsMessage.isCphsMwiMessage();
    }

    public boolean isMWIClearMessage() {
        return this.mWrappedSmsMessage.isMWIClearMessage();
    }

    public boolean isMWISetMessage() {
        return this.mWrappedSmsMessage.isMWISetMessage();
    }

    public boolean isMwiDontStore() {
        return this.mWrappedSmsMessage.isMwiDontStore();
    }

    public byte[] getUserData() {
        return this.mWrappedSmsMessage.getUserData();
    }

    public SmsHeader getUserDataHeader() {
        return this.mWrappedSmsMessage.getUserDataHeader();
    }

    public byte[] getPdu() {
        return this.mWrappedSmsMessage.getPdu();
    }

    @Deprecated
    public int getStatusOnSim() {
        return this.mWrappedSmsMessage.getStatusOnIcc();
    }

    public int getStatusOnIcc() {
        return this.mWrappedSmsMessage.getStatusOnIcc();
    }

    @Deprecated
    public int getIndexOnSim() {
        return this.mWrappedSmsMessage.getIndexOnIcc();
    }

    public int getIndexOnIcc() {
        return this.mWrappedSmsMessage.getIndexOnIcc();
    }

    public int getStatus() {
        return this.mWrappedSmsMessage.getStatus();
    }

    public boolean isStatusReportMessage() {
        return this.mWrappedSmsMessage.isStatusReportMessage();
    }

    public boolean isReplyPathPresent() {
        return this.mWrappedSmsMessage.isReplyPathPresent();
    }

    public static SmsMessageBase getSmsFacility() {
        int activePhone = TelephonyManager.getDefault().getPhoneType();
        if (2 == activePhone) {
            return new com.android.internal.telephony.cdma.SmsMessage();
        }
        return new com.android.internal.telephony.gsm.SmsMessage();
    }

    public static class SubmitPdu {
        public byte[] encodedScAddress;
        public byte[] encodedMessage;

        public String toString() {
            return "SubmitPdu: encodedScAddress = " + Arrays.toString(this.encodedScAddress) + ", encodedMessage = " + Arrays.toString(this.encodedMessage);
        }

        public SubmitPdu(SmsMessageBase.SubmitPduBase spb) {
            this.encodedMessage = spb.encodedMessage;
            this.encodedScAddress = spb.encodedScAddress;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageClass {
        UNKNOWN,
        CLASS_0,
        CLASS_1,
        CLASS_2,
        CLASS_3;

    }
}

