/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import com.android.internal.util.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackedObjectVector<E> {
    public int mColumns;
    public int mRows;
    public int mRowGapStart;
    public int mRowGapLength;
    public Object[] mValues;

    public PackedObjectVector(int columns) {
        this.mColumns = columns;
        this.mRows = ArrayUtils.idealIntArraySize(0) / this.mColumns;
        this.mRowGapStart = 0;
        this.mRowGapLength = this.mRows;
        this.mValues = new Object[this.mRows * this.mColumns];
    }

    public E getValue(int row, int column) {
        if (row >= this.mRowGapStart) {
            row += this.mRowGapLength;
        }
        Object value = this.mValues[row * this.mColumns + column];
        return (E)value;
    }

    public void setValue(int row, int column, E value) {
        if (row >= this.mRowGapStart) {
            row += this.mRowGapLength;
        }
        this.mValues[row * this.mColumns + column] = value;
    }

    public void insertAt(int row, E[] values) {
        this.moveRowGapTo(row);
        if (this.mRowGapLength == 0) {
            this.growBuffer();
        }
        ++this.mRowGapStart;
        --this.mRowGapLength;
        if (values == null) {
            for (int i = 0; i < this.mColumns; ++i) {
                this.setValue(row, i, null);
            }
        } else {
            for (int i = 0; i < this.mColumns; ++i) {
                this.setValue(row, i, values[i]);
            }
        }
    }

    public void deleteAt(int row, int count) {
        this.moveRowGapTo(row + count);
        this.mRowGapStart -= count;
        this.mRowGapLength += count;
        if (this.mRowGapLength > this.size() * 2) {
            // empty if block
        }
    }

    public int size() {
        return this.mRows - this.mRowGapLength;
    }

    public int width() {
        return this.mColumns;
    }

    public void growBuffer() {
        int newsize = this.size() + 1;
        newsize = ArrayUtils.idealIntArraySize(newsize * this.mColumns) / this.mColumns;
        Object[] newvalues = new Object[newsize * this.mColumns];
        int after = this.mRows - (this.mRowGapStart + this.mRowGapLength);
        System.arraycopy(this.mValues, 0, newvalues, 0, this.mColumns * this.mRowGapStart);
        System.arraycopy(this.mValues, (this.mRows - after) * this.mColumns, newvalues, (newsize - after) * this.mColumns, after * this.mColumns);
        this.mRowGapLength += newsize - this.mRows;
        this.mRows = newsize;
        this.mValues = newvalues;
    }

    public void moveRowGapTo(int where) {
        if (where == this.mRowGapStart) {
            return;
        }
        if (where > this.mRowGapStart) {
            int moving = where + this.mRowGapLength - (this.mRowGapStart + this.mRowGapLength);
            for (int i = this.mRowGapStart + this.mRowGapLength; i < this.mRowGapStart + this.mRowGapLength + moving; ++i) {
                int destrow = i - (this.mRowGapStart + this.mRowGapLength) + this.mRowGapStart;
                for (int j = 0; j < this.mColumns; ++j) {
                    Object val;
                    this.mValues[destrow * this.mColumns + j] = val = this.mValues[i * this.mColumns + j];
                }
            }
        } else {
            int moving = this.mRowGapStart - where;
            for (int i = where + moving - 1; i >= where; --i) {
                int destrow = i - where + this.mRowGapStart + this.mRowGapLength - moving;
                for (int j = 0; j < this.mColumns; ++j) {
                    Object val;
                    this.mValues[destrow * this.mColumns + j] = val = this.mValues[i * this.mColumns + j];
                }
            }
        }
        this.mRowGapStart = where;
    }

    public void dump() {
        for (int i = 0; i < this.mRows; ++i) {
            for (int j = 0; j < this.mColumns; ++j) {
                Object val = this.mValues[i * this.mColumns + j];
                if (i < this.mRowGapStart || i >= this.mRowGapStart + this.mRowGapLength) {
                    System.out.print(val + " ");
                    continue;
                }
                System.out.print("(" + val + ") ");
            }
            System.out.print(" << \n");
        }
        System.out.print("-----\n\n");
    }
}

